/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import oracle.eclipse.tools.coherence.descriptors.override.CoherenceOverrideService;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ListItem;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ListItemResource;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideDomUtil;
import oracle.eclipse.tools.common.util.DomUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.LayeredListPropertyBinding;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.w3c.dom.Element;

public abstract class ListItemsController
extends LayeredListPropertyBinding {
    protected final Collection<String> xmlElementNames;
    private List<Element> baseElements;
    private HashMap<ListItem, ListItem> listItemMap = new HashMap();

    public ListItemsController(String path) {
        this.xmlElementNames = Collections.singleton(path);
    }

    protected abstract String getParentPath();

    protected abstract String getElementPath();

    protected abstract XmlPath getElementXmlPath();

    protected abstract String getPath();

    protected abstract String typeToId(ElementType var1);

    protected List<Element> getBaseElements() {
        if (this.baseElements == null) {
            IProject project = (IProject)this.property().element().adapt(IProject.class);
            Element baseParent = CoherenceOverrideService.getElement(project, this.getParentPath());
            this.baseElements = new ArrayList<Element>();
            if (baseParent != null) {
                for (Element baseElement : DomUtil.elements((Element)baseParent)) {
                    String elementName = baseElement.getLocalName();
                    if (!this.xmlElementNames.contains(elementName)) continue;
                    this.baseElements.add(baseElement);
                }
            }
        }
        return this.baseElements;
    }

    protected List<?> readUnderlyingList() {
        ArrayList<ListItem> mergeList = new ArrayList<ListItem>();
        XmlElement parent = this.getParentXmlElement(false);
        if (parent != null) {
            for (XmlElement element : parent.getChildElements()) {
                String elementName = element.getDomNode().getLocalName();
                if (!this.xmlElementNames.contains(elementName)) continue;
                ListItem item = this.findListItemMerge(element);
                mergeList.add(item);
            }
        }
        return mergeList;
    }

    protected XmlElement getParentXmlElement(boolean createIfNecessary) {
        XmlElement base = this.getBaseXmlElement(createIfNecessary);
        if (base != null) {
            return (XmlElement)base.getChildNode(this.getElementXmlPath(), createIfNecessary);
        }
        return base;
    }

    protected XmlElement getBaseXmlElement(boolean createIfNecessary) {
        XmlResource resource = (XmlResource)this.property().element().resource();
        return resource.getXmlElement(createIfNecessary);
    }

    private ListItem findListItemMerge(XmlElement element) {
        List<Element> list = this.getBaseElements();
        String id = element.getAttributeText("id");
        Element baseElement = null;
        if (id != null && id.length() > 0) {
            for (Element merge : list) {
                if (!id.equals(merge.getAttribute("id"))) continue;
                baseElement = merge;
                break;
            }
        }
        ListItem key = new ListItem(baseElement, element);
        return this.findListItemMerge(key);
    }

    protected ListItem findListItemMerge(ListItem key) {
        if (!this.listItemMap.containsKey(key)) {
            this.listItemMap.put(key, key);
        }
        return this.listItemMap.get(key);
    }

    protected void resetListItemMerge(ListItem key, ListItem value) {
        this.listItemMap.put(key, value);
    }

    protected void removeListItemCache(ListItem key) {
        this.listItemMap.remove(key);
    }

    protected Object insertUnderlyingObject(ElementType type, int position) {
        return this.insertUnderlyingObject(type);
    }

    private Object insertUnderlyingObject(ElementType type) {
        String id = this.typeToId(type);
        ListItem item = this.getListItem(id);
        if (item != null) {
            return item;
        }
        if (id == null) {
            id = this.getMaxId();
        }
        XmlElement parent = this.getParentXmlElement(true);
        XmlElement element = OverrideDomUtil.insertChildElement(parent, this.getPath(), id, this.getIds());
        if (id != null) {
            element.setAttributeText("id", id, true);
        }
        return this.findListItemMerge(element);
    }

    protected List<String> getIds() {
        return null;
    }

    private ListItem getListItem(String id) {
        if (id != null) {
            for (Object obj : this.readUnderlyingList()) {
                ListItem item = (ListItem)obj;
                if (!id.equals(item.getId())) continue;
                return item;
            }
        }
        return null;
    }

    protected String getMaxId() {
        int maxId = 1;
        List<Element> list = this.getBaseElements();
        for (Element baseElement : list) {
            String id = baseElement.getAttribute("id");
            try {
                maxId = Math.max(maxId, Integer.parseInt(id) + 1);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        XmlElement parent = this.getParentXmlElement(false);
        if (parent != null) {
            for (XmlElement element : parent.getChildElements()) {
                String elementName = element.getDomNode().getLocalName();
                if (!this.xmlElementNames.contains(elementName)) continue;
                String id = element.getAttributeText("id");
                try {
                    maxId = Math.max(maxId, Integer.parseInt(id) + 1);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return Integer.toString(maxId);
    }

    public void remove(Resource resource) {
        if (resource instanceof ListItemResource) {
            XmlElement parent;
            XmlElement base;
            ListItemResource item = (ListItemResource)resource;
            this.removeListItemCache(item.getListItem());
            XmlElement xmlElement = item.getXmlElement();
            if (xmlElement != null) {
                xmlElement.remove();
            }
            if ((base = this.getBaseXmlElement(false)) != null && (parent = (XmlElement)base.getChildNode(this.getElementXmlPath(), false)) != null && parent.isEmpty()) {
                base.removeChildNode(this.getElementXmlPath());
            }
        }
    }

    public void move(Resource resource, int position) {
        List list = this.read();
        Resource refResource = position < list.size() ? (Resource)list.get(position) : null;
        this.swap(resource, refResource);
    }

    protected void swap(Resource a, Resource b) {
        if (a instanceof ListItemResource && b instanceof ListItemResource) {
            ListItemResource itemA = (ListItemResource)a;
            ListItemResource itemB = (ListItemResource)b;
            if (itemA.getXmlElement() != null && itemB.getXmlElement() != null) {
                itemA.getXmlElement().move(itemB.getXmlElement());
            }
        }
    }
}

