/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.coherence.descriptors.override.IFilter;
import oracle.eclipse.tools.coherence.descriptors.override.IFilterClusterEncryption;
import oracle.eclipse.tools.coherence.descriptors.override.IFilterGeneric;
import oracle.eclipse.tools.coherence.descriptors.override.IFilterGzip;
import oracle.eclipse.tools.coherence.descriptors.override.IFilterSymmetricEncryption;
import oracle.eclipse.tools.coherence.descriptors.override.internal.FilterClusterEncryptionResource;
import oracle.eclipse.tools.coherence.descriptors.override.internal.FilterGenericResource;
import oracle.eclipse.tools.coherence.descriptors.override.internal.FilterGzipResource;
import oracle.eclipse.tools.coherence.descriptors.override.internal.FilterSymmetricEncryptionResource;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ListItem;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ListItemsController;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.xml.StandardXmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.w3c.dom.Element;

public class FiltersListController
extends ListItemsController {
    static final String PARENT_PATH = "cluster-config/filters";
    private static final String ELEMENT_PATH = "filters";
    private static final String PATH = "filter";
    private static final StandardXmlNamespaceResolver NAMESPACE_RESOLVER = new StandardXmlNamespaceResolver(IFilter.TYPE);
    private static final XmlPath ELEMENT_XML_PATH = new XmlPath("filters", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    public static final Map<ElementType, String> TYPE_TO_ID;

    static {
        HashMap<ElementType, String> map = new HashMap<ElementType, String>();
        map.put(IFilterGzip.TYPE, "1");
        map.put(IFilterSymmetricEncryption.TYPE, "2");
        map.put(IFilterClusterEncryption.TYPE, "3");
        TYPE_TO_ID = Collections.unmodifiableMap(map);
    }

    public FiltersListController() {
        super(PATH);
    }

    protected Resource resource(Object obj) {
        ListItem item = (ListItem)obj;
        XmlResource parentResource = (XmlResource)this.property().element().resource();
        if (item.getBaseElement() != null) {
            Element elem = item.getBaseElement();
            String id = elem.getAttribute("id");
            if ("1".equals(id)) {
                return new FilterGzipResource(parentResource, item);
            }
            if ("2".equals(id)) {
                return new FilterSymmetricEncryptionResource(parentResource, item);
            }
            if ("3".equals(id)) {
                return new FilterClusterEncryptionResource(parentResource, item);
            }
        }
        return new FilterGenericResource(parentResource, item);
    }

    public ElementType type(Resource resource) {
        if (resource instanceof FilterGzipResource) {
            return IFilterGzip.TYPE;
        }
        if (resource instanceof FilterSymmetricEncryptionResource) {
            return IFilterSymmetricEncryption.TYPE;
        }
        if (resource instanceof FilterClusterEncryptionResource) {
            return IFilterClusterEncryption.TYPE;
        }
        return IFilterGeneric.TYPE;
    }

    @Override
    protected String getParentPath() {
        return PARENT_PATH;
    }

    @Override
    protected String getElementPath() {
        return ELEMENT_PATH;
    }

    @Override
    protected XmlPath getElementXmlPath() {
        return ELEMENT_XML_PATH;
    }

    @Override
    protected String getPath() {
        return PATH;
    }

    @Override
    protected String typeToId(ElementType type) {
        return TYPE_TO_ID.get(type);
    }
}

