/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override.internal;

import oracle.eclipse.tools.coherence.CoherenceVersion;
import oracle.eclipse.tools.coherence.descriptors.internal.CoherenceVersionUtil;
import oracle.eclipse.tools.coherence.descriptors.override.CoherenceOverrideInfo;
import oracle.eclipse.tools.coherence.descriptors.override.ICoherenceOverride;
import oracle.eclipse.tools.common.util.ObjectUtil;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.w3c.dom.Document;

public class CoherenceVersionListener
extends FilteredListener<PropertyContentEvent> {
    protected void handleTypedEvent(PropertyContentEvent event) {
        ICoherenceOverride descriptor = (ICoherenceOverride)event.property().element().nearest(ICoherenceOverride.class);
        Version version = CoherenceVersion.major((Version)descriptor.getVersion().content());
        CoherenceOverrideInfo info = CoherenceOverrideInfo.getCoherenceOverrideInfo(version);
        XmlElement element = ((XmlResource)descriptor.adapt(XmlResource.class)).getXmlElement(true);
        String currentNamespace = element.getNamespace();
        String expectedNamespace = info.getNamespace();
        String expectedSchemaLocation = info.getSchemaLocation();
        String expectedSystemId = info.getSystemId();
        boolean namespaceChangeNeeded = false;
        Document document = ((XmlResource)descriptor.adapt(XmlResource.class)).getXmlElement().getDomNode().getOwnerDocument();
        if (expectedSystemId != null) {
            if (document.getDoctype() == null) {
                namespaceChangeNeeded = true;
            }
        } else if (ObjectUtil.equal((Object)currentNamespace, (Object)expectedNamespace)) {
            String currentSchemaLocation = element.getSchemaLocation();
            if (currentSchemaLocation == null || !currentSchemaLocation.equals(expectedSchemaLocation)) {
                namespaceChangeNeeded = true;
            }
        } else {
            namespaceChangeNeeded = true;
        }
        if (namespaceChangeNeeded) {
            CoherenceVersionUtil.changeNamespace(document, "coherence", currentNamespace, expectedNamespace, expectedSchemaLocation, expectedSystemId);
        }
    }
}

