/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override;

import java.math.BigDecimal;
import oracle.eclipse.tools.coherence.descriptors.IModelElementBase;
import oracle.eclipse.tools.coherence.descriptors.ISocketProviderInstance;
import oracle.eclipse.tools.coherence.descriptors.ISocketProviderSdp;
import oracle.eclipse.tools.coherence.descriptors.ISocketProviderSsl;
import oracle.eclipse.tools.coherence.descriptors.ISocketProviderSystem;
import oracle.eclipse.tools.coherence.descriptors.ISocketProviderTcp;
import oracle.eclipse.tools.coherence.descriptors.SizeUnit;
import oracle.eclipse.tools.coherence.descriptors.internal.NumberUnitEnabler;
import oracle.eclipse.tools.coherence.descriptors.internal.TextAndElementBinding;
import oracle.eclipse.tools.coherence.descriptors.override.IAddressProviderInstance;
import oracle.eclipse.tools.coherence.descriptors.override.ISocketAddress;
import oracle.eclipse.tools.coherence.descriptors.override.ISocketProviderUnicastName;
import oracle.eclipse.tools.coherence.descriptors.override.PacketBufferChoice;
import oracle.eclipse.tools.coherence.descriptors.override.ReliableTransport;
import oracle.eclipse.tools.coherence.descriptors.override.WellKnownAddressOption;
import oracle.eclipse.tools.coherence.descriptors.override.internal.NumberWithUnitDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.override.internal.NumberWithUnitPropertyCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideValuePropertyCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.override.internal.PacketBufferTypeCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.override.internal.SocketAddressesListController;
import oracle.eclipse.tools.coherence.descriptors.override.internal.UnicastSocketProviderNamePossibleTypesService;
import oracle.eclipse.tools.coherence.descriptors.override.internal.WellKnownAddressChoiceBinding;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.VersionCompatibility;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.FixedOrderList;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlElementBinding;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlListBinding;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlElementBinding;

public interface IUnicastListener
extends Element {
    public static final ElementType TYPE = new ElementType(IUnicastListener.class);
    @Type(base=IModelElementBase.class)
    @Service(impl=UnicastSocketProviderNamePossibleTypesService.class)
    @CustomXmlElementBinding(impl=TextAndElementBinding.class)
    @Label(standard="socket provider")
    @Since(value="3.6")
    @XmlElementBinding(path="socket-provider", mappings={@XmlElementBinding.Mapping(element="$$ANY", type=ISocketProviderUnicastName.class), @XmlElementBinding.Mapping(element="system", type=ISocketProviderSystem.class), @XmlElementBinding.Mapping(element="ssl", type=ISocketProviderSsl.class), @XmlElementBinding.Mapping(element="tcp", type=ISocketProviderTcp.class), @XmlElementBinding.Mapping(element="sdp", type=ISocketProviderSdp.class), @XmlElementBinding.Mapping(element="instance", type=ISocketProviderInstance.class)})
    public static final ElementProperty PROP_SOCKET_PROVIDER = new ElementProperty(TYPE, "SocketProvider");
    @Type(base=ReliableTransport.class)
    @Label(standard="reliable transport")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"reliable-transport"})
    @DefaultValue(text="datagram")
    @Since(value="3.7.1")
    @Documentation(content="The reliable-transport element contains the name of the transport used by the TCMP for reliable point-to-point communications.")
    public static final ValueProperty PROP_RELIABLE_TRANSPORT = new ValueProperty(TYPE, "ReliableTransport");
    @Type(base=WellKnownAddressOption.class)
    @CustomXmlValueBinding(impl=WellKnownAddressChoiceBinding.class)
    @Label(standard="well known address")
    @DefaultValue(text="SOCKET_ADDRESS")
    public static final ValueProperty PROP_WELL_KNOWN_ADDRESS = new ValueProperty(TYPE, "WellKnownAddress");
    @Type(base=ISocketAddress.class)
    @CustomXmlListBinding(impl=SocketAddressesListController.class)
    @Label(standard="socket addresses")
    @FixedOrderList
    @Documentation(content="Specifies a list of \"well known\" addresses (WKA) that are used by the cluster discovery protocol in place of multicast broadcast. If one or more WKA is specified, for a member to join the cluster it will either have to be a WKA or there will have to be at least one WKA member running. Additionally, all cluster communication will be performed using unicast. If empty or unspecified multicast communications will be used.")
    public static final ListProperty PROP_SOCKET_ADDRESSES = new ListProperty(TYPE, "SocketAddresses");
    @Type(base=IAddressProviderInstance.class)
    @XmlBinding(path="well-known-addresses/address-provider")
    public static final ImpliedElementProperty PROP_ADDRESS_PROVIDER = new ImpliedElementProperty(TYPE, "AddressProvider");
    @Label(standard="machine id")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"machine-id"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/unicast-listener/machine-id")})
    @VersionCompatibility(value="3.2]")
    public static final ValueProperty PROP_MACHINE_ID = new ValueProperty(TYPE, "MachineId");
    @Label(standard="address")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"address"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/unicast-listener/address")})
    @Documentation(content="Specifies the IP address that a Socket will listen or publish on.[pbr/]Note: The localhost setting may not work on systems that define localhost as the loopback address; in that case, specify the machine name or the specific IP address.")
    public static final ValueProperty PROP_ADDRESS = new ValueProperty(TYPE, "Address");
    @Type(base=Integer.class)
    @Label(standard="port")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"port"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/unicast-listener/port")})
    @NumericRange(min="1", max="65535")
    @Documentation(content="Specifies the port that the Socket will listen or publish on.")
    public static final ValueProperty PROP_PORT = new ValueProperty(TYPE, "Port");
    @Type(base=Boolean.class)
    @Label(standard="port auto adjust")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"port-auto-adjust"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/unicast-listener/port-auto-adjust")})
    @Documentation(content="Specifies whether or not the unicast port will be automatically incremented if the specified port cannot be bound to because it is already in use. [pbr/]It is recommended that this value be configured to false for production environments.")
    public static final ValueProperty PROP_PORT_AUTO_ADJUST = new ValueProperty(TYPE, "PortAutoAdjust");
    @Type(base=Boolean.class)
    @XmlBinding(path="ignore-socket-closed")
    @Label(standard="ignore socket closed")
    @DefaultValue(text="false")
    @VersionCompatibility(value="3.2]")
    public static final ValueProperty PROP_IGNORE_SOCKET_CLOSED = new ValueProperty(TYPE, "IgnoreSocketClosed");
    @Type(base=Integer.class)
    @XmlBinding(path="maximum-socket-closed-exceptions")
    @Label(standard="maximum socket closed exceptions")
    @NumericRange(min="0")
    @Enablement(expr="${ ! IgnoreSocketClosed }")
    @VersionCompatibility(value="3.2]")
    public static final ValueProperty PROP_MAXIMUM_SOCKET_CLOSED_EXCEPTIONS = new ValueProperty(TYPE, "MaximumSocketClosedExceptions");
    @Type(base=PacketBufferChoice.class)
    @Label(standard="packet buffer")
    @DefaultValue(text="NONE")
    @CustomXmlValueBinding(impl=PacketBufferTypeCustomBinding.class)
    public static final ValueProperty PROP_PACKET_BUFFER_CHOICE = new ValueProperty(TYPE, "PacketBufferChoice");
    @Type(base=Integer.class)
    @Label(standard="maximum packets")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"packet-buffer/maximum-packets"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/unicast-listener/packet-buffer/maximum-packets"), @Service.Param(name="default", value="1428")})
    @NumericRange(min="0")
    @Documentation(content="Specifies the number of packets of maximum size that the datagram socket will be asked to size itself to buffer.")
    public static final ValueProperty PROP_PACKET_BUFFER_MAXIMUM_PACKETS = new ValueProperty(TYPE, "PacketBufferMaximumPackets");
    @Type(base=BigDecimal.class)
    @Label(standard="packet buffer size")
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"packet-buffer/size", "true", "16MB"})
    @Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/unicast-listener/packet-buffer/size"), @Service.Param(name="isNumber", value="true"), @Service.Param(name="default", value="16MB")})
    @NumericRange(min="1")
    @Since(value="3.7")
    public static final ValueProperty PROP_PACKET_BUFFER_SIZE = new ValueProperty(TYPE, "PacketBufferSize");
    @Type(base=SizeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"packet-buffer/size", "false", "16MB"})
    @Since(value="3.7")
    @Services(value={@Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/unicast-listener/packet-buffer/size"), @Service.Param(name="isNumber", value="false"), @Service.Param(name="default", value="16MB")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="PacketBufferSize")})})
    public static final ValueProperty PROP_PACKET_BUFFER_SIZE_UNIT = new ValueProperty(TYPE, "PacketBufferSizeUnit");
    @Type(base=Integer.class)
    @Label(standard="priority")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"priority"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/unicast-listener/priority")})
    @NumericRange(min="1", max="10")
    @Documentation(content="Specifies a priority of the unicast listener execution thread.")
    public static final ValueProperty PROP_PRIORITY = new ValueProperty(TYPE, "Priority");

    public ElementHandle<IModelElementBase> getSocketProvider();

    public Value<ReliableTransport> getReliableTransport();

    public void setReliableTransport(String var1);

    public void setReliableTransport(ReliableTransport var1);

    public Value<WellKnownAddressOption> getWellKnownAddress();

    public void setWellKnownAddress(String var1);

    public void setWellKnownAddress(WellKnownAddressOption var1);

    public ElementList<ISocketAddress> getSocketAddresses();

    public IAddressProviderInstance getAddressProvider();

    public Value<String> getMachineId();

    public void setMachineId(String var1);

    public Value<String> getAddress();

    public void setAddress(String var1);

    public Value<Integer> getPort();

    public void setPort(String var1);

    public void setPort(Integer var1);

    public Value<Boolean> getPortAutoAdjust();

    public void setPortAutoAdjust(String var1);

    public void setPortAutoAdjust(Boolean var1);

    public Value<Boolean> getIgnoreSocketClosed();

    public void setIgnoreSocketClosed(String var1);

    public void setIgnoreSocketClosed(Boolean var1);

    public Value<Integer> getMaximumSocketClosedExceptions();

    public void setMaximumSocketClosedExceptions(String var1);

    public void setMaximumSocketClosedExceptions(Integer var1);

    public Value<PacketBufferChoice> getPacketBufferChoice();

    public void setPacketBufferChoice(String var1);

    public void setPacketBufferChoice(PacketBufferChoice var1);

    public Value<Integer> getPacketBufferMaximumPackets();

    public void setPacketBufferMaximumPackets(String var1);

    public void setPacketBufferMaximumPackets(Integer var1);

    public Value<BigDecimal> getPacketBufferSize();

    public void setPacketBufferSize(String var1);

    public void setPacketBufferSize(BigDecimal var1);

    public Value<SizeUnit> getPacketBufferSizeUnit();

    public void setPacketBufferSizeUnit(String var1);

    public void setPacketBufferSizeUnit(SizeUnit var1);

    public Value<Integer> getPriority();

    public void setPriority(String var1);

    public void setPriority(Integer var1);
}

