/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override;

import oracle.eclipse.tools.coherence.descriptors.override.IService;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ListItemDefaultValueProvider;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NamedValues;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;

@Label(standard="local cache")
public interface IServiceLocalCache
extends IService {
    public static final ElementType TYPE = new ElementType(IServiceLocalCache.class);
    @Type(base=Boolean.class)
    @Label(standard="lock enforce")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(1)/param-value")})
    @Documentation(content="If true the locking is enforced for put, remove and clear operations; otherwise a client is responsible for calling lock and unlock explicitly.")
    public static final ValueProperty PROP_LOCK_ENFORCE = new ValueProperty(TYPE, "LockEnforce");
    @NamedValues(arbitraryValueLabel="lock wait (msecs)", defaultArbitraryValue="0", namedValues={@NamedValues.NamedValue(value="-1", label="block the calling thread until the lock could be obtained.")})
    @Type(base=Long.class)
    @Label(standard="lock wait")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(2)/param-value")})
    @NumericRange(min="-1")
    @Enablement(expr="${ LockEnforce }")
    @Documentation(content="If locking enforcement is required then this parameter specifies the number of milliseconds to continue trying to obtain a lock; -1 blocks the calling thread until the lock could be obtained.")
    public static final ValueProperty PROP_LOCK_WAIT = new ValueProperty(TYPE, "LockWait");

    public Value<Boolean> getLockEnforce();

    public void setLockEnforce(String var1);

    public void setLockEnforce(Boolean var1);

    public Value<Long> getLockWait();

    public void setLockWait(String var1);

    public void setLockWait(Long var1);
}

