/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override;

import oracle.eclipse.tools.coherence.descriptors.override.IService;
import oracle.eclipse.tools.coherence.descriptors.override.IServiceTaskTimeout;
import oracle.eclipse.tools.coherence.descriptors.override.IServiceTimeout;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ListItemDefaultValueProvider;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;

@Label(standard="invocation service")
public interface IServiceInvocation
extends IService,
IServiceTimeout,
IServiceTaskTimeout {
    public static final ElementType TYPE = new ElementType(IServiceInvocation.class);
    @Type(base=Integer.class)
    @Label(standard="thread count")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(1)/param-value")})
    @NumericRange(min="0")
    @Documentation(content="Specifies the number of daemon threads to be used by the invocation service.[pbr/]If zero, all relevant tasks are performed on the service thread.")
    public static final ValueProperty PROP_THREAD_COUNT = new ValueProperty(TYPE, "ThreadCount");
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(2)/param-value")})
    @Enablement(expr="${ ThreadCount > 0 }")
    @Documentation(content="Specifies the amount of time in milliseconds that a task can execute before it is considered \"hung\". Note: a posted task that has not yet started is never considered as hung. This attribute is applied only if the Thread pool is used (the \"thread-count\" value is positive).")
    public static final ValueProperty PROP_TASK_HUNG_THRESHOLD = new ValueProperty(TYPE, IServiceTaskTimeout.PROP_TASK_HUNG_THRESHOLD);
    @Enablement(expr="${ ThreadCount > 0 }")
    public static final ValueProperty PROP_TASK_HUNG_THRESHOLD_UNIT = new ValueProperty(TYPE, IServiceTaskTimeout.PROP_TASK_HUNG_THRESHOLD_UNIT);
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(3)/param-value")})
    @Enablement(expr="${ ThreadCount > 0 }")
    @Documentation(content="Specifies the default timeout value in milliseconds for tasks that can be timed-out (e.g. implement the com.tangosol.net.PriorityTask interface), but don't explicitly specify the task execution timeout value. The task execution time is measured on the server side and does not include the time spent waiting in a service backlog queue before being started. This attribute is applied only if the thread pool is used (the \"thread-count\" value is positive).")
    public static final ValueProperty PROP_TASK_TIMEOUT = new ValueProperty(TYPE, IServiceTaskTimeout.PROP_TASK_TIMEOUT);
    @Enablement(expr="${ ThreadCount > 0 }")
    public static final ValueProperty PROP_TASK_TIMEOUT_UNIT = new ValueProperty(TYPE, IServiceTaskTimeout.PROP_TASK_TIMEOUT_UNIT);
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(4)/param-value")})
    @Documentation(content="Specifies the default timeout value in milliseconds for requests that can time-out (e.g. implement the com.tangosol.net.PriorityTask interface), but don't explicitly specify the request timeout value. The request time is measured on the client side as the time elapsed from the moment a request is sent for execution to the corresponding server node(s) and includes the following: [ol][li]The time it takes to deliver the request to an executing node (server).[/li][li]The interval between the time the task is received and placed into a service queue until the execution starts.[/li][li]The task execution time.[/li][li]The time it takes to deliver a result back to the client.[/li][/ol]")
    public static final ValueProperty PROP_REQUEST_TIMEOUT = new ValueProperty(TYPE, IServiceTimeout.PROP_REQUEST_TIMEOUT);
    public static final ValueProperty PROP_REQUEST_TIMEOUT_UNIT = new ValueProperty(TYPE, IServiceTimeout.PROP_REQUEST_TIMEOUT_UNIT);
    @Label(standard="serializer")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(5)/param-value")})
    public static final ValueProperty PROP_SERIALIZER = new ValueProperty(TYPE, "Serializer");
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(6)/param-value")})
    @Documentation(content="Specifies the guardian timeout value to use for guarding the service and any dependant threads. An explicitly specified timeout of 0 will prevent the service (and any dependant threads) from being guarded.")
    public static final ValueProperty PROP_GUARDIAN_TIMEOUT = new ValueProperty(TYPE, IServiceTimeout.PROP_GUARDIAN_TIMEOUT);
    public static final ValueProperty PROP_GUARDIAN_TIMEOUT_UNIT = new ValueProperty(TYPE, IServiceTimeout.PROP_GUARDIAN_TIMEOUT_UNIT);
    @Label(standard="service failure policy")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(7)/param-value")})
    @Since(value="3.6")
    public static final ValueProperty PROP_SERVICE_FAILURE_POLICY = new ValueProperty(TYPE, "ServiceFailurePolicy");
    @Type(base=JavaTypeName.class)
    @Reference(target=JavaType.class)
    @Label(standard="member listener class")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(8)/param-value")})
    @Since(value="3.6")
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS}, type={"com.tangosol.net.MemberListener"})
    @MustExist
    public static final ValueProperty PROP_MEMBER_LISTENER_CLASS_NAME = new ValueProperty(TYPE, "MemberListenerClassName");
    @Type(base=Integer.class)
    @Label(standard="service priority")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(9)/param-value")})
    @NumericRange(min="1", max="10")
    @Since(value="12.1.2")
    public static final ValueProperty PROP_SERVICE_PRIORITY = new ValueProperty(TYPE, "ServicePriority");
    @Type(base=Integer.class)
    @Label(standard="event dispatcher priority")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(10)/param-value")})
    @NumericRange(min="1", max="10")
    @Since(value="12.1.2")
    public static final ValueProperty PROP_EVENT_DISPATCHER_PRIORITY = new ValueProperty(TYPE, "EventDispatcherPriority");
    @Type(base=Integer.class)
    @Label(standard="worker priority")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(11)/param-value")})
    @NumericRange(min="1", max="10")
    @Since(value="12.1.2")
    public static final ValueProperty PROP_WORKER_PRIORITY = new ValueProperty(TYPE, "WorkerPriority");
    @Label(standard="reliable transport")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(12)/param-value")})
    @Since(value="12.1.2")
    public static final ValueProperty PROP_RELIABLE_TRANSPORT = new ValueProperty(TYPE, "ReliableTransport");

    public Value<Integer> getThreadCount();

    public void setThreadCount(String var1);

    public void setThreadCount(Integer var1);

    public Value<String> getSerializer();

    public void setSerializer(String var1);

    public Value<String> getServiceFailurePolicy();

    public void setServiceFailurePolicy(String var1);

    public ReferenceValue<JavaTypeName, JavaType> getMemberListenerClassName();

    public void setMemberListenerClassName(String var1);

    public void setMemberListenerClassName(JavaTypeName var1);

    public Value<Integer> getServicePriority();

    public void setServicePriority(String var1);

    public void setServicePriority(Integer var1);

    public Value<Integer> getEventDispatcherPriority();

    public void setEventDispatcherPriority(String var1);

    public void setEventDispatcherPriority(Integer var1);

    public Value<Integer> getWorkerPriority();

    public void setWorkerPriority(String var1);

    public void setWorkerPriority(Integer var1);

    public Value<String> getReliableTransport();

    public void setReliableTransport(String var1);
}

