/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override;

import oracle.eclipse.tools.coherence.descriptors.override.MBeanOptions;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ListItemDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideMethodValuesProvider;
import oracle.eclipse.tools.coherence.descriptors.override.internal.UniqueMBeanNameValidator;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;

@Label(standard="MBean")
public interface IMBean
extends Element {
    public static final ElementType TYPE = new ElementType(IMBean.class);
    @Type(base=MBeanOptions.class)
    @Label(standard="option")
    @DefaultValue(text="MBEAN_QUERY")
    public static final ValueProperty PROP_MBEAN_OPTIONS = new ValueProperty(TYPE, "MbeanOptions");
    @Type(base=JavaTypeName.class)
    @Reference(target=JavaType.class)
    @Label(standard="class")
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS})
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="mbean-class")})
    @MustExist
    @Required
    @Enablement(expr="${ MbeanOptions == 'MBEAN_CLASS' }")
    @Documentation(content="Specifies the class of the standard MBean to instantiate.")
    public static final ValueProperty PROP_MBEAN_CLASS = new ValueProperty(TYPE, "MbeanClass");
    @Type(base=JavaTypeName.class)
    @Reference(target=JavaType.class)
    @Label(standard="factory")
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS})
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="mbean-factory")})
    @MustExist
    @Required
    @Enablement(expr="${ MbeanOptions == 'MBEAN_FACTORY' }")
    @Documentation(content="Specifies the class of the factory used to instantiate the MBean.")
    public static final ValueProperty PROP_MBEAN_FACTORY = new ValueProperty(TYPE, "MbeanFactory");
    @Label(standard="query")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="mbean-query")})
    @Required
    @Enablement(expr="${ MbeanOptions == 'MBEAN_QUERY' }")
    @Documentation(content="Specified the JMX ObjectName query pattern used to retrieve the MBeans.")
    public static final ValueProperty PROP_MBEAN_QUERY = new ValueProperty(TYPE, "MbeanQuery");
    @Label(standard="server domain")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="mbean-server-domain")})
    @Documentation(content="Specifies the name of a default domain for the source MBeanServer.")
    public static final ValueProperty PROP_MBEAN_SERVER_DOMAIN = new ValueProperty(TYPE, "MbeanServerDomain");
    @Label(standard="accessor")
    @Services(value={@Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="mbean-accessor")}), @Service(impl=OverrideMethodValuesProvider.class)})
    @Required
    @Enablement(expr="${ MbeanOptions == 'MBEAN_FACTORY' }")
    @Documentation(content="Specifies the accessor method on the <mbean-factory> used to instantiate the MBean.")
    public static final ValueProperty PROP_MBEAN_ACCESSOR = new ValueProperty(TYPE, "MbeanAccessor");
    @Label(standard="name")
    @Services(value={@Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="mbean-name")}), @Service(impl=UniqueMBeanNameValidator.class)})
    @Documentation(content="Specifies the ObjectName prefix for the resulting MBeans. This ObjectName prefix should be a comma separated Key=Value pair. The Coherence MBean naming convention stipulates that the name should begin with a \"type\"/\"value\" pair (i.e. type=Platform).")
    public static final ValueProperty PROP_MBEAN_NAME = new ValueProperty(TYPE, "MbeanName");
    @Type(base=Boolean.class)
    @Label(standard="local only")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="local-only"), @Service.Param(name="default", value="false")})
    @Documentation(content="Controls the MBean visibility across the cluster. If set to true, the MBean is registered only with a local MBeanServer and is not accessible by other cluster nodes; otherwise the \"nodeId=...\" key attribute is added to its name and the MBean will be visible from any of the \"managing\" nodes (the ones that have the managed-nodes element set to values of all  or remote-only).")
    public static final ValueProperty PROP_LOCAL_ONLY = new ValueProperty(TYPE, "LocalOnly");
    @Type(base=Boolean.class)
    @Label(standard="enabled")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="enabled"), @Service.Param(name="default", value="false")})
    @Documentation(content="Specifies if the MBean should be registered on this instance.")
    public static final ValueProperty PROP_ENABLED = new ValueProperty(TYPE, "Enabled");
    @Type(base=Boolean.class)
    @Label(standard="extend lifecycle")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="extend-lifecycle")})
    @Documentation(content="Specifies if the MBean should extend beyond the node connection life cycle. If false, the MBean will be destroyed and re-created when a node is disconnected from the grid. If true, the MBean will maintain the statistics and values across connections.")
    public static final ValueProperty PROP_EXTEND_LIFECYCLE = new ValueProperty(TYPE, "ExtendLifecycle");

    public Value<MBeanOptions> getMbeanOptions();

    public void setMbeanOptions(String var1);

    public void setMbeanOptions(MBeanOptions var1);

    public ReferenceValue<JavaTypeName, JavaType> getMbeanClass();

    public void setMbeanClass(String var1);

    public void setMbeanClass(JavaTypeName var1);

    public ReferenceValue<JavaTypeName, JavaType> getMbeanFactory();

    public void setMbeanFactory(String var1);

    public void setMbeanFactory(JavaTypeName var1);

    public Value<String> getMbeanQuery();

    public void setMbeanQuery(String var1);

    public Value<String> getMbeanServerDomain();

    public void setMbeanServerDomain(String var1);

    public Value<String> getMbeanAccessor();

    public void setMbeanAccessor(String var1);

    public Value<String> getMbeanName();

    public void setMbeanName(String var1);

    public Value<Boolean> getLocalOnly();

    public void setLocalOnly(String var1);

    public void setLocalOnly(Boolean var1);

    public Value<Boolean> getEnabled();

    public void setEnabled(String var1);

    public void setEnabled(Boolean var1);

    public Value<Boolean> getExtendLifecycle();

    public void setExtendLifecycle(String var1);

    public void setExtendLifecycle(Boolean var1);
}

