/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override;

import java.math.BigDecimal;
import oracle.eclipse.tools.coherence.descriptors.SizeUnit;
import oracle.eclipse.tools.coherence.descriptors.internal.NumberUnitEnabler;
import oracle.eclipse.tools.coherence.descriptors.override.internal.NumberWithUnitDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.override.internal.NumberWithUnitPropertyCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideValuePropertyCustomBinding;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.VersionCompatibility;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;

public interface IIncomingMessageHandler
extends Element {
    public static final ElementType TYPE = new ElementType(IIncomingMessageHandler.class);
    @Type(base=Integer.class)
    @Label(standard="maximum time variance (msec)")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"maximum-time-variance"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/incoming-message-handler/maximum-time-variance")})
    @NumericRange(min="1", max="1000")
    public static final ValueProperty PROP_MAXIMUM_TIME_VARIANCE = new ValueProperty(TYPE, "MaximumTimeVariance");
    @Type(base=Integer.class)
    @Label(standard="packet pool maximum packets")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"packet-pool/maximum-packets"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/incoming-message-handler/packet-pool/maximum-packets")})
    @NumericRange(min="1", max="10000")
    @VersionCompatibility(value="3.5]")
    @Documentation(content="The maximum number of reusable packets to be utilized by the services responsible for publishing and receiving. The pools are intially small, and will grow on demand up to the specified limits.")
    public static final ValueProperty PROP_PACKET_POOL_MAXIMUM_PACKETS = new ValueProperty(TYPE, "PacketPoolMaximumPackets");
    @Type(base=BigDecimal.class)
    @Label(standard="packet pool size")
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"packet-pool/size", "true", "16MB"})
    @Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/incoming-message-handler/packet-pool/size"), @Service.Param(name="isNumber", value="true"), @Service.Param(name="default", value="16MB")})
    @NumericRange(min="1")
    @VersionCompatibility(value="[3.6-12.1.2)")
    public static final ValueProperty PROP_PACKET_POOL_SIZE = new ValueProperty(TYPE, "PacketPoolSize");
    @Type(base=SizeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"packet-pool/size", "false", "16MB"})
    @VersionCompatibility(value="[3.6-12.1.2)")
    @Services(value={@Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/incoming-message-handler/packet-pool/size"), @Service.Param(name="isNumber", value="false"), @Service.Param(name="default", value="16MB")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="PacketPoolSize")})})
    public static final ValueProperty PROP_PACKET_POOL_SIZE_UNIT = new ValueProperty(TYPE, "PacketPoolSizeUnit");
    @Type(base=Boolean.class)
    @Label(standard="use negative acknowledgments")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"use-nack-packets"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/incoming-message-handler/use-nack-packets")})
    @Documentation(content="Specifies whether the packet receiver will use negative acknowledgments (packet requests) to pro-actively respond to known missing packets.")
    public static final ValueProperty PROP_USE_NACK_PACKETS = new ValueProperty(TYPE, "UseNackPackets");
    @Type(base=Integer.class)
    @Label(standard="priority")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"priority"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/incoming-message-handler/priority")})
    @NumericRange(min="1", max="10")
    @Documentation(content="Specifies a priority of the incoming message handler execution thread.")
    public static final ValueProperty PROP_PRIORITY = new ValueProperty(TYPE, "Priority");

    public Value<Integer> getMaximumTimeVariance();

    public void setMaximumTimeVariance(String var1);

    public void setMaximumTimeVariance(Integer var1);

    public Value<Integer> getPacketPoolMaximumPackets();

    public void setPacketPoolMaximumPackets(String var1);

    public void setPacketPoolMaximumPackets(Integer var1);

    public Value<BigDecimal> getPacketPoolSize();

    public void setPacketPoolSize(String var1);

    public void setPacketPoolSize(BigDecimal var1);

    public Value<SizeUnit> getPacketPoolSizeUnit();

    public void setPacketPoolSizeUnit(String var1);

    public void setPacketPoolSizeUnit(SizeUnit var1);

    public Value<Boolean> getUseNackPackets();

    public void setUseNackPackets(String var1);

    public void setUseNackPackets(Boolean var1);

    public Value<Integer> getPriority();

    public void setPriority(String var1);

    public void setPriority(Integer var1);
}

