/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override;

import java.math.BigDecimal;
import oracle.eclipse.tools.coherence.descriptors.SizeKMUnit;
import oracle.eclipse.tools.coherence.descriptors.SizeUnit;
import oracle.eclipse.tools.coherence.descriptors.TimeUnit;
import oracle.eclipse.tools.coherence.descriptors.internal.NumberUnitEnabler;
import oracle.eclipse.tools.coherence.descriptors.internal.SizeValidator;
import oracle.eclipse.tools.coherence.descriptors.override.internal.NumberWithUnitDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.override.internal.NumberWithUnitPropertyCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideValuePropertyCustomBinding;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.annotations.AbsolutePath;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.FileSystemResourceType;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.annotations.ValidFileSystemResourceType;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;

public interface IFlashjournalManager
extends Element {
    public static final ElementType TYPE = new ElementType(IFlashjournalManager.class);
    @Label(standard="minimum load factor")
    @Type(base=Double.class)
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"minimum-load-factor"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/journaling-config/flashjournal-manager/minimum-load-factor")})
    @NumericRange(min="0.01", max="0.99")
    @Since(value="3.7")
    @Documentation(content="The factor of live data below which a Journal file is eligible for compaction (garbage collection).")
    public static final ValueProperty PROP_MINIMUM_LOAD_FACTOR = new ValueProperty(TYPE, "MinimumLoadFactor");
    @Label(standard="maximum value size")
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"maximum-value-size", "true", "64KB"})
    @Services(value={@Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/journaling-config/flashjournal-manager/maximum-value-size"), @Service.Param(name="isNumber", value="true"), @Service.Param(name="default", value="64KB")}), @Service(impl=SizeValidator.class, params={@Service.Param(name="unitProp", value="MaximumValueSizeUnit"), @Service.Param(name="min", value="0"), @Service.Param(name="max", value="64MB")})})
    @Since(value="3.7")
    @Documentation(content="Specifies the maximum size, in bytes, of binary values that are to be stored in the flash journal. The value cannot exceed 64MB.")
    public static final ValueProperty PROP_MAXIMUM_VALUE_SIZE = new ValueProperty(TYPE, "MaximumValueSize");
    @Type(base=SizeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"maximum-value-size", "false", "64KB"})
    @Since(value="3.7")
    @Services(value={@Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/journaling-config/flashjournal-manager/maximum-value-size"), @Service.Param(name="isNumber", value="false"), @Service.Param(name="default", value="64KB")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="MaximumValueSize")})})
    public static final ValueProperty PROP_MAXIMUM_VALUE_SIZE_UNIT = new ValueProperty(TYPE, "MaximumValueSizeUnit");
    @Label(standard="maximum file size")
    @Type(base=Integer.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"maximum-file-size", "true", "2GB"})
    @Services(value={@Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/journaling-config/flashjournal-manager/maximum-file-size"), @Service.Param(name="isNumber", value="true"), @Service.Param(name="default", value="2GB")}), @Service(impl=SizeValidator.class, params={@Service.Param(name="unitProp", value="MaximumFileSizeUnit"), @Service.Param(name="min", value="1MB"), @Service.Param(name="max", value="4GB")})})
    @Since(value="3.7")
    @Documentation(content="Specifies the maximum file size of the underlying journal files. The value must be a power of two and a multiple of the block size. The value must be between 1MB and 4GB.")
    public static final ValueProperty PROP_MAXIMUM_FILE_SIZE = new ValueProperty(TYPE, "MaximumFileSize");
    @Type(base=SizeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"maximum-file-size", "false", "2GB"})
    @Since(value="3.7")
    @Services(value={@Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/journaling-config/flashjournal-manager/maximum-file-size"), @Service.Param(name="isNumber", value="false"), @Service.Param(name="default", value="2GB")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="MaximumFileSize")})})
    public static final ValueProperty PROP_MAXIMUM_FILE_SIZE_UNIT = new ValueProperty(TYPE, "MaximumFileSizeUnit");
    @Label(standard="block size")
    @Type(base=Integer.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"block-size", "true", "256KB"})
    @Services(value={@Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/journaling-config/flashjournal-manager/block-size"), @Service.Param(name="isNumber", value="true"), @Service.Param(name="default", value="256KB")}), @Service(impl=SizeValidator.class, params={@Service.Param(name="unitProp", value="BlockSizeUnit"), @Service.Param(name="min", value="4KB"), @Service.Param(name="max", value="1MB")})})
    @NumericRange(min="0")
    @Since(value="3.7")
    @Documentation(content="Specifies the size of the write buffers in which writes to an underlying disk file occur. The size should match or be a multiple of the physical device's optimal block size and must be a power of two. The value must be between 4KB and 1MB.")
    public static final ValueProperty PROP_BLOCK_SIZE = new ValueProperty(TYPE, "BlockSize");
    @Type(base=SizeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"block-size", "false", "256KB"})
    @Since(value="3.7")
    @Services(value={@Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/journaling-config/flashjournal-manager/block-size"), @Service.Param(name="isNumber", value="false"), @Service.Param(name="default", value="256KB")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="BlockSize")})})
    public static final ValueProperty PROP_BLOCK_SIZE_UNIT = new ValueProperty(TYPE, "BlockSizeUnit");
    @Label(standard="maximum pool size")
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"maximum-pool-size", "true", "16MB"})
    @Services(value={@Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/journaling-config/flashjournal-manager/maximum-pool-size"), @Service.Param(name="isNumber", value="true"), @Service.Param(name="default", value="16MB")}), @Service(impl=SizeValidator.class, params={@Service.Param(name="unitProp", value="MaximumPoolSizeUnit"), @Service.Param(name="min", value=""), @Service.Param(name="max", value="1GB")})})
    @NumericRange(min="0")
    @Since(value="3.7")
    @Documentation(content="Specifies the size, in bytes, for the buffer pool. The size does not limit the number of buffers that can be allocated or that can exist at any point in time. The size only determines the amount of buffers that are recycled. The pools size cannot exceed 1GB.")
    public static final ValueProperty PROP_MAXIMUM_POOL_SIZE = new ValueProperty(TYPE, "MaximumPoolSize");
    @Type(base=SizeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"maximum-pool-size", "false", "16MB"})
    @Since(value="3.7")
    @Services(value={@Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/journaling-config/flashjournal-manager/maximum-pool-size"), @Service.Param(name="isNumber", value="false"), @Service.Param(name="default", value="16MB")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="MaximumPoolSize")})})
    public static final ValueProperty PROP_MAXIMUM_POOL_SIZE_UNIT = new ValueProperty(TYPE, "MaximumPoolSizeUnit");
    @Label(standard="directory")
    @Type(base=Path.class)
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"directory"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/journaling-config/flashjournal-manager/directory")})
    @Since(value="3.7")
    @ValidFileSystemResourceType(value=FileSystemResourceType.FOLDER)
    @AbsolutePath
    @Documentation(content="Specifies the directory where the journal files should be placed. The directory must exist and is not created at run time. If the directory does not exist or is not specified, the JVM/operating system default temporary directory is used. The suggested location is a local flash (SSD) drive. [pbr/]Specifying a directory that is located on a drive which is shared by other applications or system operations increases the potential for unplanned space usage. Use a directory location on a non-shared disk partition to ensure a more predictable environment.")
    public static final ValueProperty PROP_DIRECTORY = new ValueProperty(TYPE, "Directory");
    @Label(standard="async limit")
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"async-limit", "true", "16MB"})
    @Services(value={@Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/journaling-config/flashjournal-manager/async-limit"), @Service.Param(name="isNumber", value="true"), @Service.Param(name="default", value="16MB")}), @Service(impl=SizeValidator.class, params={@Service.Param(name="unitProp", value="AsyncLimitUnit"), @Service.Param(name="min", value="4KB"), @Service.Param(name="max", value="1GB")})})
    @NumericRange(min="0")
    @Since(value="3.7")
    @Documentation(content="Specifies the maximum size, in bytes, of the backlog. The backlog is the amount of data that has yet to be persisted. Client threads are blocked if the configured limit is exceeded and remain blocked until the backlog recedes below the limit. This helps prevent out-of-memory conditions.[pbr/]Note: The maximum amount of memory used by the backlog is at least twice the configured amount, since the data is in binary form and rendered to the write-behind buffers. The value must be between 4KB and 1GB.")
    public static final ValueProperty PROP_ASYNC_LIMIT = new ValueProperty(TYPE, "AsyncLimit");
    @Type(base=SizeKMUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"async-limit", "false", "16MB"})
    @Since(value="3.7")
    @Services(value={@Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/journaling-config/flashjournal-manager/async-limit"), @Service.Param(name="isNumber", value="false"), @Service.Param(name="default", value="16MB")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="AsyncLimit")})})
    public static final ValueProperty PROP_ASYNC_LIMIT_UNIT = new ValueProperty(TYPE, "AsyncLimitUnit");
    @Label(standard="purge delay")
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"tmp-purge-delay", "true", "1ms"})
    @Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/journaling-config/flashjournal-manager/tmp-purge-delay"), @Service.Param(name="isNumber", value="true"), @Service.Param(name="default", value="1ms")})
    @NumericRange(min="0")
    @Since(value="3.7")
    @Documentation(content="The delay after last usage which a temporary file used by the Journaling subsystem is eligible for removal.")
    public static final ValueProperty PROP_TMP_PURGE_DELAY = new ValueProperty(TYPE, "TmpPurgeDelay");
    @Type(base=TimeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"tmp-purge-delay", "false", "1ms"})
    @Since(value="3.7")
    @Services(value={@Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/journaling-config/flashjournal-manager/tmp-purge-delay"), @Service.Param(name="isNumber", value="false"), @Service.Param(name="default", value="1ms")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="TmpPurgeDelay")})})
    public static final ValueProperty PROP_TMP_PURGE_DELAY_UNIT = new ValueProperty(TYPE, "TmpPurgeDelayUnit");
    @Label(standard="high journal size")
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"high-journal-size", "true", "11GB"})
    @Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/journaling-config/flashjournal-manager/high-journal-size"), @Service.Param(name="isNumber", value="true"), @Service.Param(name="default", value="11GB")})
    @NumericRange(min="0")
    @Since(value="12.1.2")
    @Documentation(content="Specifies a soft limit on the journal size. This allows the GC thread to tune itself to try to avoid growing the journal beyond the high journal size.[pbr/]This is not a hard-limit and the journal could still grow beyond that up to the max file count (512).")
    public static final ValueProperty PROP_HIGH_JOURNAL_SIZE = new ValueProperty(TYPE, "HighJournalSize");
    @Type(base=SizeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"high-journal-size", "false", "11GB"})
    @Since(value="12.1.2")
    @Services(value={@Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/journaling-config/flashjournal-manager/high-journal-size"), @Service.Param(name="isNumber", value="false"), @Service.Param(name="default", value="11GB")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="HighJournalSize")})})
    public static final ValueProperty PROP_HIGH_JOURNAL_SIZE_UNIT = new ValueProperty(TYPE, "HighJournalSizeUnit");

    public Value<Double> getMinimumLoadFactor();

    public void setMinimumLoadFactor(String var1);

    public void setMinimumLoadFactor(Double var1);

    public Value<BigDecimal> getMaximumValueSize();

    public void setMaximumValueSize(String var1);

    public void setMaximumValueSize(BigDecimal var1);

    public Value<SizeUnit> getMaximumValueSizeUnit();

    public void setMaximumValueSizeUnit(String var1);

    public void setMaximumValueSizeUnit(SizeUnit var1);

    public Value<Integer> getMaximumFileSize();

    public void setMaximumFileSize(String var1);

    public void setMaximumFileSize(Integer var1);

    public Value<SizeUnit> getMaximumFileSizeUnit();

    public void setMaximumFileSizeUnit(String var1);

    public void setMaximumFileSizeUnit(SizeUnit var1);

    public Value<Integer> getBlockSize();

    public void setBlockSize(String var1);

    public void setBlockSize(Integer var1);

    public Value<SizeUnit> getBlockSizeUnit();

    public void setBlockSizeUnit(String var1);

    public void setBlockSizeUnit(SizeUnit var1);

    public Value<BigDecimal> getMaximumPoolSize();

    public void setMaximumPoolSize(String var1);

    public void setMaximumPoolSize(BigDecimal var1);

    public Value<SizeUnit> getMaximumPoolSizeUnit();

    public void setMaximumPoolSizeUnit(String var1);

    public void setMaximumPoolSizeUnit(SizeUnit var1);

    public Value<Path> getDirectory();

    public void setDirectory(String var1);

    public void setDirectory(Path var1);

    public Value<BigDecimal> getAsyncLimit();

    public void setAsyncLimit(String var1);

    public void setAsyncLimit(BigDecimal var1);

    public Value<SizeKMUnit> getAsyncLimitUnit();

    public void setAsyncLimitUnit(String var1);

    public void setAsyncLimitUnit(SizeKMUnit var1);

    public Value<BigDecimal> getTmpPurgeDelay();

    public void setTmpPurgeDelay(String var1);

    public void setTmpPurgeDelay(BigDecimal var1);

    public Value<TimeUnit> getTmpPurgeDelayUnit();

    public void setTmpPurgeDelayUnit(String var1);

    public void setTmpPurgeDelayUnit(TimeUnit var1);

    public Value<BigDecimal> getHighJournalSize();

    public void setHighJournalSize(String var1);

    public void setHighJournalSize(BigDecimal var1);

    public Value<SizeUnit> getHighJournalSizeUnit();

    public void setHighJournalSizeUnit(String var1);

    public void setHighJournalSizeUnit(SizeUnit var1);
}

