/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override;

import oracle.eclipse.tools.coherence.descriptors.override.IFilter;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ListItemDefaultValueProvider;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.PossibleValues;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.SensitiveData;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;

@Label(standard="symmetric encryption filter")
public interface IFilterSymmetricEncryption
extends IFilter {
    public static final ElementType TYPE = new ElementType(IFilterSymmetricEncryption.class);
    @Label(standard="password")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(1)/param-value")})
    @Required
    @SensitiveData
    @Documentation(content="Specifies the raw material used to generate the secret key.")
    public static final ValueProperty PROP_PASSWORD = new ValueProperty(TYPE, "Password");
    @Label(standard="salt")
    @DefaultValue(text="nosecret")
    @Documentation(content="Specifies the salt to use in deriving the key.")
    public static final ValueProperty PROP_SALT = new ValueProperty(TYPE, "Salt");
    @Label(standard="iterations")
    @Type(base=Integer.class)
    @NumericRange(min="0")
    @DefaultValue(text="32")
    @Documentation(content="Specifies theiteration count to use in deriving the key.")
    public static final ValueProperty PROP_ITERATIONS = new ValueProperty(TYPE, "Iterations");
    @PossibleValues(values={"AES", "Blowfish", "DES", "DESede", "PBEWithMD5AndDES", "PBEWithHmacSHA1AndDESede", "RC2", "RC4", "RC5", "RSA"}, invalidValueSeverity=Status.Severity.OK)
    @Label(standard="algorithm")
    @DefaultValue(text="PBEWithMD5AndDES")
    @Documentation(content="Specifies the mechanism to use in deriving a secret key from the above material.")
    public static final ValueProperty PROP_ALGORITHM = new ValueProperty(TYPE, "Algorithm");

    public Value<String> getPassword();

    public void setPassword(String var1);

    public Value<String> getSalt();

    public void setSalt(String var1);

    public Value<Integer> getIterations();

    public void setIterations(String var1);

    public void setIterations(Integer var1);

    public Value<String> getAlgorithm();

    public void setAlgorithm(String var1);
}

