/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideDomUtil;
import oracle.eclipse.tools.coherence.internal.CoherenceURIResolverExtension;
import oracle.eclipse.tools.common.util.DomUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class CoherenceOverrideService {
    public static final String SYSTEM_PROPERTY = "system-property";
    static CoherenceOverrideService service = new CoherenceOverrideService();
    private Map<IProject, Element> projectToDom = new HashMap<IProject, Element>();
    private List<IPath> triggerFiles = new ArrayList<IPath>();

    private CoherenceOverrideService() {
        this.triggerFiles.add((IPath)new Path(".settings/org.eclipse.wst.common.project.facet.core.xml"));
        this.triggerFiles.add((IPath)new Path(".settings/oracle.eclipse.tools.weblogic.syslib.xml"));
        this.triggerFiles.add((IPath)new Path(".settings/com.bea.workshop.wls.core.systemlibs.xml"));
        this.triggerFiles.add((IPath)new Path("oracle.eclipse.tools.coherence.lib.omw"));
    }

    private Element getDomForProject(IProject project) {
        if (this.projectToDom.containsKey(project)) {
            return this.projectToDom.get(project);
        }
        CoherenceURIResolverExtension resolver = new CoherenceURIResolverExtension();
        URI path = resolver.resolve(project, "tangosol-coherence.xml");
        if (path != null) {
            try {
                Document doc = DomUtil.doc((InputStream)path.toURL().openStream());
                Element root = doc.getDocumentElement();
                this.projectToDom.put(project, root);
                this.addListeners(project);
                return root;
            }
            catch (MalformedURLException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.coherence", (Throwable)e);
            }
            catch (IOException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.coherence", (Throwable)e);
            }
        } else {
            this.projectToDom.put(project, null);
        }
        return null;
    }

    private void addListeners(IProject project) {
        project.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event.getDelta() != null) {
                    IResourceDelta[] iResourceDeltaArray = event.getDelta().getAffectedChildren();
                    int n = iResourceDeltaArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResourceDelta subdelta = iResourceDeltaArray[n2];
                        IProject project = (IProject)subdelta.getResource();
                        boolean relevant = false;
                        for (IPath p : CoherenceOverrideService.this.triggerFiles) {
                            if (subdelta.findMember(p) == null) continue;
                            relevant = true;
                            break;
                        }
                        if (relevant) {
                            CoherenceOverrideService.this.projectToDom.remove(project);
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    private String getTextValueImpl(IProject project, String path) {
        Element elem = this.getDomForProject(project);
        return elem != null ? OverrideDomUtil.getText(elem, path) : null;
    }

    private String getSystemPropertyImpl(IProject project, String path) {
        Element child;
        Element elem = this.getDomForProject(project);
        if (elem != null && (child = OverrideDomUtil.getChildElement(elem, path)) != null) {
            return child.getAttribute(SYSTEM_PROPERTY);
        }
        return null;
    }

    private Element getElementImpl(IProject project, String path) {
        Element elem = this.getDomForProject(project);
        if (elem != null) {
            return OverrideDomUtil.getChildElement(elem, path);
        }
        return null;
    }

    public static String getTextValue(IProject project, String path) {
        return service.getTextValueImpl(project, path);
    }

    public static String getSystemProperty(IProject project, String path) {
        return service.getSystemPropertyImpl(project, path);
    }

    public static Element getElement(IProject project, String path) {
        return service.getElementImpl(project, path);
    }

    public static String getFullXmlPath(XmlElement element, String relative) {
        LinkedList<String> trail = new LinkedList<String>();
        XmlElement el = element;
        while (el.getParent() != null) {
            trail.addFirst(el.getLocalName());
            el = el.getParent();
        }
        StringBuilder buf = new StringBuilder();
        for (String segment : trail) {
            if (buf.length() > 0) {
                buf.append('/');
            }
            buf.append(segment);
        }
        if (buf.length() > 0) {
            buf.append('/');
        }
        buf.append(relative);
        return buf.toString();
    }
}

