/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.operations.internal;

import java.io.File;
import oracle.eclipse.tools.coherence.descriptors.operations.IGarExportWizardOp;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class DestinationFileValidationService
extends ValidationService {
    private Listener listener;

    protected void initValidationService() {
        super.initValidationService();
        IGarExportWizardOp op = (IGarExportWizardOp)this.context(IGarExportWizardOp.class);
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                DestinationFileValidationService.this.refresh();
            }
        };
        op.getFolder().attach(this.listener);
        op.getOverwriteExistingFile().attach(this.listener);
    }

    public void dispose() {
        super.dispose();
        IGarExportWizardOp op = (IGarExportWizardOp)this.context(IGarExportWizardOp.class);
        if (op != null && !op.disposed()) {
            op.getFolder().detach(this.listener);
            op.getOverwriteExistingFile().detach(this.listener);
        }
    }

    protected Status compute() {
        File file;
        Path folder;
        Value value = (Value)this.context(Value.of(Path.class));
        IGarExportWizardOp op = (IGarExportWizardOp)value.nearest(IGarExportWizardOp.class);
        boolean overwrite = (Boolean)op.getOverwriteExistingFile().content();
        if (!overwrite && (folder = (Path)value.content()) != null && (file = folder.toFile()).exists()) {
            return Status.createErrorStatus((String)Resources.bind((String)Resources.destinationExists, (Object)folder));
        }
        return Status.createOkStatus();
    }

    private static final class Resources
    extends NLS {
        public static String destinationExists;

        static {
            Resources.initializeMessages((String)DestinationFileValidationService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

