/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.operations.internal;

import oracle.eclipse.tools.common.util.jdt.JavaProjectUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;

public class CreateCoherenceConfigurationOpFolderValidator
extends ValidationService {
    private final String moduleFacetId;

    public CreateCoherenceConfigurationOpFolderValidator() {
        this.moduleFacetId = "oracle.coherence";
    }

    protected Status compute() {
        IResource resource;
        Value target = (Value)this.context(Value.of(Path.class));
        Path path = (Path)target.content();
        if (path != null && (resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path.toPortableString())) != null) {
            IProject project = resource.getProject();
            IVirtualComponent vc = null;
            try {
                if (FacetedProjectFramework.hasProjectFacet((IProject)project, (String)this.moduleFacetId)) {
                    vc = ComponentCore.createComponent((IProject)project);
                }
            }
            catch (CoreException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.coherence", (CoreException)e);
            }
            if (vc == null) {
                String msg = NLS.bind((String)Resources.notInRightLocation, (Object)path.toPortableString());
                return Status.createWarningStatus((String)msg);
            }
            if (!JavaProjectUtil.isResourceInsideSourceFolder((IResource)resource)) {
                String msg = NLS.bind((String)Resources.notInRightLocation, (Object)path.toPortableString());
                return Status.createWarningStatus((String)msg);
            }
        }
        return Status.createOkStatus();
    }

    private static final class Resources
    extends NLS {
        public static String notInRightLocation;

        static {
            Resources.initializeMessages((String)CreateCoherenceConfigurationOpFolderValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

