/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.launchConfig.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.CoherenceModel;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.IJmxConfig;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.ILaunchConfig;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.internal.JmxConfigResource;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.internal.SystemPropertyResource;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListPropertyBinding;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.sapphire.modeling.ElementPropertyBinding;

public final class LaunchConfigResource
extends Resource {
    private CoherenceModel model;
    private Map<String, SystemPropertyResource> map = new HashMap<String, SystemPropertyResource>();

    public LaunchConfigResource(CoherenceModel model) {
        super(null);
        this.model = model;
    }

    public CoherenceModel getCoherenceModel() {
        return this.model;
    }

    private SystemPropertyResource getSystemPropertyResource(String name) {
        if (!this.map.containsKey(name)) {
            this.map.put(name, new SystemPropertyResource(this.getCoherenceModel(), name));
        }
        return this.map.get(name);
    }

    protected PropertyBinding createBinding(final Property property) {
        PropertyDef p = property.definition();
        if (p == ILaunchConfig.PROP_JMX_CONFIG) {
            return new ElementPropertyBinding(){
                private JmxConfigResource resource;

                public Resource read() {
                    if (this.resource == null) {
                        this.resource = new JmxConfigResource(LaunchConfigResource.this.getCoherenceModel());
                    }
                    return this.resource;
                }

                public ElementType type(Resource resource) {
                    return IJmxConfig.TYPE;
                }
            };
        }
        if (p == ILaunchConfig.PROP_SYSTEM_PROPERTIES) {
            return new ListPropertyBinding(){

                public List<Resource> read() {
                    ArrayList<Resource> list = new ArrayList<Resource>();
                    for (String name : LaunchConfigResource.this.getCoherenceModel().getSystemProperties()) {
                        list.add(LaunchConfigResource.this.getSystemPropertyResource(name));
                    }
                    return list;
                }

                public ElementType type(Resource resource) {
                    return property.definition().getType();
                }
            };
        }
        if (p instanceof ValueProperty) {
            return new ValuePropertyBinding(){

                public String read() {
                    return LaunchConfigResource.this.getCoherenceModel().getValue(property.name());
                }

                public void write(String value) {
                    LaunchConfigResource.this.getCoherenceModel().setValue(property.name(), value);
                }
            };
        }
        throw new IllegalArgumentException();
    }
}

