/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.launchConfig.internal;

import oracle.eclipse.tools.coherence.descriptors.internal.NumberWithUnit;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.CoherenceModel;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.IJmxConfig;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.ValuePropertyBinding;

public final class JmxConfigResource
extends Resource {
    private CoherenceModel model;

    public JmxConfigResource(CoherenceModel model) {
        super(null);
        this.model = model;
    }

    public CoherenceModel getCoherenceModel() {
        return this.model;
    }

    protected PropertyBinding createBinding(final Property property) {
        PropertyDef p = property.definition();
        if (p == IJmxConfig.PROP_REFRESH_EXPIRY) {
            return new ValuePropertyBinding(){

                public String read() {
                    String expiry = JmxConfigResource.this.getCoherenceModel().getValue("RefreshExpiry");
                    NumberWithUnit nu = NumberWithUnit.parse(expiry);
                    return nu.getNumber();
                }

                public void write(String value) {
                    if (value == null) {
                        JmxConfigResource.this.getCoherenceModel().setValue("RefreshExpiry", null);
                        return;
                    }
                    String expiry = JmxConfigResource.this.getCoherenceModel().getValue("RefreshExpiry");
                    NumberWithUnit nu = NumberWithUnit.parse(expiry);
                    nu.setNumber(value);
                    if (nu.getNumber() == null || nu.getUnit() == null) {
                        String defaultExpiry = JmxConfigResource.this.getCoherenceModel().getDefaultValue("RefreshExpiry");
                        NumberWithUnit defaultNu = NumberWithUnit.parse(defaultExpiry);
                        nu.addDefault(defaultNu);
                    }
                    JmxConfigResource.this.getCoherenceModel().setValue("RefreshExpiry", nu.toString());
                }
            };
        }
        if (p == IJmxConfig.PROP_REFRESH_EXPIRY_UNITS) {
            return new ValuePropertyBinding(){

                public String read() {
                    String expiry = JmxConfigResource.this.getCoherenceModel().getValue("RefreshExpiry");
                    NumberWithUnit nu = NumberWithUnit.parse(expiry);
                    return nu.getUnit();
                }

                public void write(String value) {
                    if (value == null) {
                        JmxConfigResource.this.getCoherenceModel().setValue("RefreshExpiry", null);
                        return;
                    }
                    String expiry = JmxConfigResource.this.getCoherenceModel().getValue("RefreshExpiry");
                    NumberWithUnit nu = NumberWithUnit.parse(expiry);
                    nu.setUnit(value);
                    if (nu.getNumber() == null || nu.getUnit() == null) {
                        String defaultExpiry = JmxConfigResource.this.getCoherenceModel().getDefaultValue("RefreshExpiry");
                        NumberWithUnit defaultNu = NumberWithUnit.parse(defaultExpiry);
                        nu.addDefault(defaultNu);
                    }
                    JmxConfigResource.this.getCoherenceModel().setValue("RefreshExpiry", nu.toString());
                }
            };
        }
        if (p instanceof ValueProperty) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JmxConfigResource.this.getCoherenceModel().getValue(property.name());
                }

                public void write(String value) {
                    JmxConfigResource.this.getCoherenceModel().setValue(property.name(), value);
                }
            };
        }
        throw new IllegalArgumentException();
    }
}

