/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.launchConfig;

import oracle.eclipse.tools.coherence.descriptors.internal.IPAddressValidationService;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.IJmxConfig;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.ISystemProperty;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.LocalStorage;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.NetworkCommunication;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.internal.LaunchConfigDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.internal.LaunchConfigEnabler;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.internal.LaunchConfigListener;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.internal.LaunchConfigValidator;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.internal.LogDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.internal.NetworkCommunicationListener;
import oracle.eclipse.tools.coherence.descriptors.override.LoggingDestination;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Listeners;
import org.eclipse.sapphire.modeling.annotations.NamedValues;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.ReadOnly;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;

public interface ILaunchConfig
extends Element {
    public static final ElementType TYPE = new ElementType(ILaunchConfig.class);
    public static final String CACHE_CONFIG_NAME = "CacheConfig";
    public static final String LOCAL_STORAGE_NAME = "LocalStorage";
    public static final String LOG_NAME = "Log";
    public static final String LOG_FILE_NAME_NAME = "LogFileName";
    public static final String LOGGER_NAME = "LoggerName";
    public static final String LOG_LEVEL_NAME = "LogLevel";
    public static final String LOG_LIMIT_NAME = "LogLimit";
    public static final String COMMUNICATION_NAME = "Communication";
    public static final String CLUSTER_ADDRESS_NAME = "ClusterAddress";
    public static final String CLUSTER_PORT_NAME = "ClusterPort";
    public static final String TTL_NAME = "Ttl";
    public static final String WKA_NAME = "Wka";
    public static final String WKA_PORT_NAME = "WkaPort";
    @Type(base=Path.class)
    @Label(standard="cache configuration &descriptor")
    @Listeners(value={LaunchConfigListener.class})
    @Services(value={@Service(impl=LaunchConfigValidator.class), @Service(impl=LaunchConfigEnabler.class), @Service(impl=LaunchConfigDefaultValueProvider.class)})
    @Documentation(content="Specify the location of the cache configuration deployment descriptor. Unless an absolute or relative path is specified, such as with ./path/to/config.xml, the application's classpath will be used to find the specified descriptor.")
    public static final ValueProperty PROP_CACHE_CONFIG = new ValueProperty(TYPE, "CacheConfig");
    @Type(base=LocalStorage.class)
    @Label(standard="&local storage")
    @Listeners(value={LaunchConfigListener.class})
    @Services(value={@Service(impl=LaunchConfigValidator.class), @Service(impl=LaunchConfigEnabler.class), @Service(impl=LaunchConfigDefaultValueProvider.class)})
    @Documentation(content="Specifies whether or not this member of the DistributedCache service enables the local storage.")
    public static final ValueProperty PROP_LOCAL_STORAGE = new ValueProperty(TYPE, "LocalStorage");
    @Type(base=LoggingDestination.class)
    @Label(standard="destination")
    @Listeners(value={LaunchConfigListener.class})
    @Services(value={@Service(impl=LaunchConfigValidator.class), @Service(impl=LaunchConfigEnabler.class), @Service(impl=LogDefaultValueProvider.class, params={@Service.Param(name="isLoggingDestination", value="true")})})
    @Documentation(content="Specifies the output device used by the logging system. [pbr/]Legal values are:[ul][li]stdout[/li][li]stderr[/li][li]jdk[/li][li]log4j[/li][li]a file name[/li][/ul]")
    public static final ValueProperty PROP_LOG = new ValueProperty(TYPE, "Log");
    @Label(standard="file")
    @Services(value={@Service(impl=LaunchConfigEnabler.class), @Service(impl=LogDefaultValueProvider.class, params={@Service.Param(name="isLoggingDestination", value="false")})})
    @Required
    public static final ValueProperty PROP_LOG_FILE_NAME = new ValueProperty(TYPE, "LogFileName");
    @Label(standard="logger name")
    @Services(value={@Service(impl=LaunchConfigEnabler.class), @Service(impl=LaunchConfigValidator.class), @Service(impl=LaunchConfigDefaultValueProvider.class, params={@Service.Param(name="default", value="Coherence")})})
    public static final ValueProperty PROP_LOGGER_NAME = new ValueProperty(TYPE, "LoggerName");
    @Type(base=Integer.class)
    @Label(standard="le&vel")
    @Listeners(value={LaunchConfigListener.class})
    @NumericRange(min="-1", max="9")
    @Services(value={@Service(impl=LaunchConfigValidator.class), @Service(impl=LaunchConfigEnabler.class), @Service(impl=LaunchConfigDefaultValueProvider.class)})
    @Documentation(content="Specifies which logged messages will be output to the log destination.[pbr/]Legal values are:[ul][li]0: only output without a logging severity level specified will be logged[/li][li]1: all the above plus errors[/li][li]2: all the above plus warnings[/li][li]3: all the above plus informational messages[/li][li]4-9: all the above plus internal debugging messages (the higher the number, the more the messages)[/li][li]-1: no messages[/li][/ul]")
    public static final ValueProperty PROP_LOG_LEVEL = new ValueProperty(TYPE, "LogLevel");
    @Type(base=Integer.class)
    @NamedValues(arbitraryValueLabel="c&haracter limit", defaultArbitraryValue="1048576", namedValues={@NamedValues.NamedValue(value="0", label="no limi&t")})
    @Label(standard="character limit")
    @Listeners(value={LaunchConfigListener.class})
    @NumericRange(min="0")
    @Services(value={@Service(impl=LaunchConfigValidator.class), @Service(impl=LaunchConfigEnabler.class), @Service(impl=LaunchConfigDefaultValueProvider.class)})
    @Documentation(content="Specifies the maximum number of characters that the logger daemon will process from the message queue before discarding all remaining messages in the queue. Note that the message that caused the total number of characters to exceed the maximum will NOT be truncated, and all messages that are discarded will be summarized by the logging system with a single log entry detailing the number of messages that were discarded and their total size. The truncation of the logging is only temporary, since once the queue is processed (emptied), the logger is reset so that subsequent messages will be logged.[pbr/]The purpose of this setting is to avoid a situation where logging can itself prevent recovery from a failing condition. For example, with tight timings, logging can actually change the timings, causing more failures and probably more logging, which becomes a vicious cycle. A limit on the logging being done at any one point in time is a \"pressure valve\" that prevents such a vicious cycle from occurring. Note that logging occurs on a dedicated low-priority thread to even further reduce its impact on the critical portions of the system.")
    public static final ValueProperty PROP_LOG_LIMIT = new ValueProperty(TYPE, "LogLimit");
    @Type(base=NetworkCommunication.class)
    @Label(standard="communication")
    @Listeners(value={NetworkCommunicationListener.class})
    @DefaultValue(text="multicast")
    @Service(impl=LaunchConfigValidator.class)
    public static final ValueProperty PROP_COMMUNICATION = new ValueProperty(TYPE, "Communication");
    @Label(standard="cluster &address")
    @Listeners(value={LaunchConfigListener.class})
    @Services(value={@Service(impl=LaunchConfigValidator.class), @Service(impl=IPAddressValidationService.class), @Service(impl=LaunchConfigDefaultValueProvider.class), @Service(impl=LaunchConfigEnabler.class)})
    @Documentation(content="Specifies the multicast IP address that a Socket will listen or publish on.[pbr/]Legal values are from 224.0.0.0 to 239.255.255.255.")
    public static final ValueProperty PROP_CLUSTER_ADDRESS = new ValueProperty(TYPE, "ClusterAddress");
    @Type(base=Integer.class)
    @Label(standard="cluster &port")
    @Listeners(value={LaunchConfigListener.class})
    @NumericRange(min="1", max="65535")
    @Services(value={@Service(impl=LaunchConfigValidator.class), @Service(impl=LaunchConfigEnabler.class), @Service(impl=LaunchConfigDefaultValueProvider.class)})
    @Documentation(content="Specifies the port that the Socket will listen or publish on.")
    public static final ValueProperty PROP_CLUSTER_PORT = new ValueProperty(TYPE, "ClusterPort");
    @Type(base=Integer.class)
    @Label(standard="t&ime to live")
    @Listeners(value={LaunchConfigListener.class})
    @NumericRange(min="0", max="255")
    @Services(value={@Service(impl=LaunchConfigValidator.class), @Service(impl=LaunchConfigEnabler.class), @Service(impl=LaunchConfigDefaultValueProvider.class)})
    @Documentation(content="Specifies the time-to-live setting for the multicast. This determines the maximum number of \"hops\" a packet may traverse, where a hop is measured as a traversal from one network segment to another via a router. [pbr/]For production use, this value should be set to the lowest integer value that works. On a single server cluster, it should work at 0; on a simple switched backbone, it should work at 1; on an advanced backbone with intelligent switching, it may require a value of 2 or more. Setting the value too high can use unnecessary bandwidth on other LAN segments and can even cause the OS or network devices to disable multicast traffic. While a value of 0 is meant to keep packets from leaving the originating machine, some OSs do not implement this correctly, and the packets may in fact be transmitted on the network.")
    public static final ValueProperty PROP_TTL = new ValueProperty(TYPE, "Ttl");
    @Label(standard="well known IP &address")
    @Listeners(value={LaunchConfigListener.class})
    @Services(value={@Service(impl=LaunchConfigValidator.class), @Service(impl=LaunchConfigEnabler.class), @Service(impl=LaunchConfigDefaultValueProvider.class)})
    @Documentation(content="Specifies a list of \"well known\" addresses (WKA) that are used by the cluster discovery protocol in place of multicast broadcast. If one or more WKA is specified, for a member to join the cluster it will either have to be a WKA or there will have to be at least one WKA member running. Additionally, all cluster communication will be performed using unicast. If empty or unspecified multicast communications will be used.")
    public static final ValueProperty PROP_WKA = new ValueProperty(TYPE, "Wka");
    @Type(base=Integer.class)
    @Label(standard="well known IP &port")
    @Listeners(value={LaunchConfigListener.class})
    @NumericRange(min="1", max="65535")
    @Services(value={@Service(impl=LaunchConfigValidator.class), @Service(impl=LaunchConfigEnabler.class), @Service(impl=LaunchConfigDefaultValueProvider.class)})
    @Documentation(content="Specifies a list of \"well known\" addresses (WKA) that are used by the cluster discovery protocol in place of multicast broadcast. If one or more WKA is specified, for a member to join the cluster it will either have to be a WKA or there will have to be at least one WKA member running. Additionally, all cluster communication will be performed using unicast. If empty or unspecified multicast communications will be used.")
    public static final ValueProperty PROP_WKA_PORT = new ValueProperty(TYPE, "WkaPort");
    @Type(base=IJmxConfig.class)
    @Label(standard="JMX")
    public static final ImpliedElementProperty PROP_JMX_CONFIG = new ImpliedElementProperty(TYPE, "JmxConfig");
    @Label(standard="system properties")
    @Type(base=ISystemProperty.class)
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="system-properties", type=ISystemProperty.class)})
    @ReadOnly
    @Documentation(content="The table details all the preconfigured overrides.")
    public static final ListProperty PROP_SYSTEM_PROPERTIES = new ListProperty(TYPE, "SystemProperties");

    public Value<Path> getCacheConfig();

    public void setCacheConfig(String var1);

    public void setCacheConfig(Path var1);

    public Value<LocalStorage> getLocalStorage();

    public void setLocalStorage(String var1);

    public void setLocalStorage(LocalStorage var1);

    public Value<LoggingDestination> getLog();

    public void setLog(String var1);

    public void setLog(LoggingDestination var1);

    public Value<String> getLogFileName();

    public void setLogFileName(String var1);

    public Value<String> getLoggerName();

    public void setLoggerName(String var1);

    public Value<Integer> getLogLevel();

    public void setLogLevel(String var1);

    public void setLogLevel(Integer var1);

    public Value<Integer> getLogLimit();

    public void setLogLimit(String var1);

    public void setLogLimit(Integer var1);

    public Value<NetworkCommunication> getCommunication();

    public void setCommunication(String var1);

    public void setCommunication(NetworkCommunication var1);

    public Value<String> getClusterAddress();

    public void setClusterAddress(String var1);

    public Value<Integer> getClusterPort();

    public void setClusterPort(String var1);

    public void setClusterPort(Integer var1);

    public Value<Integer> getTtl();

    public void setTtl(String var1);

    public void setTtl(Integer var1);

    public Value<String> getWka();

    public void setWka(String var1);

    public Value<Integer> getWkaPort();

    public void setWkaPort(String var1);

    public void setWkaPort(Integer var1);

    public IJmxConfig getJmxConfig();

    public ElementList<ISystemProperty> getSystemProperties();
}

