/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.internal;

import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class PrimeNumberValidator
extends ValidationService {
    protected Status compute() {
        String number = ((Value)this.context(Value.class)).text();
        if (number != null && number.length() > 0) {
            try {
                if (!this.isPrime(Integer.parseInt(number))) {
                    return Status.createErrorStatus((String)NLS.bind((String)Resources.primeNumberError, (Object)number));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return Status.createOkStatus();
    }

    private boolean isPrime(int number) {
        if (number == 0 || number == 1) {
            return false;
        }
        int i = 2;
        while (i < number) {
            int n = number % i;
            if (n == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static final class Resources
    extends NLS {
        public static String primeNumberError;

        static {
            Resources.initializeMessages((String)PrimeNumberValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

