/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.internal;

public class NumberWithUnit {
    private static final String[] UNITS = new String[]{"ns", "us", "ms", "s", "m", "h", "d", "KB", "MB", "GB", "TB", "%"};
    private String number;
    private String unit;
    private String defaultNumber;
    private String defaultUnit;

    public NumberWithUnit(String number, String unit) {
        if (number != null && number.length() > 0) {
            this.number = number;
        }
        if (unit != null && unit.length() > 0) {
            this.unit = unit;
        }
    }

    public void addDefault(NumberWithUnit defaultNumber) {
        this.defaultNumber = defaultNumber.getNumber();
        this.defaultUnit = defaultNumber.getUnit();
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String toString() {
        if (this.number == null && this.unit == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        if (this.number != null) {
            buf.append(this.number);
        } else if (this.defaultNumber != null) {
            buf.append(this.defaultNumber);
        }
        if (this.number != null && !this.number.equals("0")) {
            if (this.unit != null) {
                buf.append(this.unit);
            } else if (this.defaultUnit != null) {
                buf.append(this.defaultUnit);
            }
        }
        return buf.toString();
    }

    public static NumberWithUnit parse(String str) {
        String theUnit = null;
        if (str != null) {
            str = str.trim();
            String[] stringArray = UNITS;
            int n = UNITS.length;
            int n2 = 0;
            while (n2 < n) {
                String unit = stringArray[n2];
                String unitUpper = unit.toUpperCase();
                if (str.toUpperCase().endsWith(unitUpper)) {
                    theUnit = unit;
                    str = str.substring(0, str.length() - unit.length());
                    break;
                }
                ++n2;
            }
        }
        return new NumberWithUnit(str, theUnit);
    }
}

