/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.coherence.descriptors.IInstanceBase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.PropertyValidationEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.services.PossibleValuesService;

public class MethodValuesProvider
extends PossibleValuesService {
    private List<String> validBaseTypes;

    protected void init() {
        super.init();
        this.getFactory().attach((Listener)new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                if (event instanceof PropertyContentEvent || event instanceof PropertyValidationEvent) {
                    MethodValuesProvider.this.broadcast();
                }
            }
        });
    }

    protected void fillPossibleValues(Set<String> values) {
        IType type = this.getType();
        IMethod[] methods = null;
        try {
            methods = type != null ? type.getMethods() : null;
        }
        catch (JavaModelException javaModelException) {}
        if (methods != null) {
            Element descriptor = ((Element)this.context(Element.class)).root();
            this.validBaseTypes = this.getReturnTypes();
            IMethod[] iMethodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                String signature = this.getFullyQualifiedReturnType(type, method);
                if (this.validate(signature, (IProject)descriptor.adapt(IProject.class))) {
                    values.add(method.getElementName());
                }
                ++n2;
            }
        }
    }

    private String getFullyQualifiedReturnType(IType type, IMethod method) {
        try {
            String signature = method.getReturnType();
            String packageName = Signature.getSignatureQualifier((String)signature);
            String fullName = String.valueOf(packageName.trim().equals("") ? "" : String.valueOf(packageName) + ".") + Signature.getSignatureSimpleName((String)signature);
            String[][] returnType = type.resolveType(fullName);
            if (returnType != null && returnType.length > 0) {
                if (returnType[0][0] != null && returnType[0][0].length() > 0) {
                    return String.valueOf(returnType[0][0]) + "." + returnType[0][1];
                }
                return returnType[0][1];
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    protected Value<?> getFactory() {
        Element elem = (Element)this.context(Element.class);
        if (elem instanceof IInstanceBase) {
            return ((IInstanceBase)elem).getClassFactoryName();
        }
        return null;
    }

    protected ValueProperty getValueProperty(Element elem) {
        ValueProperty property = null;
        if (elem instanceof IInstanceBase) {
            property = ((IInstanceBase)elem).getClassName().definition();
        }
        return property;
    }

    private IType getType() {
        Element descriptor;
        IJavaProject javaProject;
        String className;
        Value<?> factory = this.getFactory();
        if (factory != null && (className = factory.text()) != null && (javaProject = JavaCore.create((IProject)((IProject)(descriptor = ((Element)this.context(Element.class)).root()).adapt(IProject.class)))) != null && javaProject.exists()) {
            IType type = null;
            try {
                type = javaProject.findType(className);
                if (type != null && (!type.exists() || type.isAnonymous())) {
                    type = null;
                }
                return type;
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    private IMethod[] getAllMethods() {
        IType type = this.getType();
        try {
            if (type != null) {
                return type.getMethods();
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    private List<String> getReturnTypes() {
        JavaTypeConstraint javaTypeConstraintsAnnotation;
        ArrayList<String> types = new ArrayList<String>();
        ValueProperty property = this.getValueProperty((Element)this.context(Element.class));
        if (property != null && (javaTypeConstraintsAnnotation = (JavaTypeConstraint)property.getAnnotation(JavaTypeConstraint.class)) != null) {
            String[] stringArray = javaTypeConstraintsAnnotation.type();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                types.add(type);
                ++n2;
            }
        }
        return types;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validate(String val, IProject project) {
        boolean typeMustExist = true;
        boolean isAbstractClassOk = true;
        boolean isClassOk = true;
        boolean isAnnotationOk = true;
        boolean isInterfaceOk = true;
        boolean isEnumOk = true;
        if (val == null) return false;
        if (project == null) return false;
        try {
            IType type = MethodValuesProvider.getType(val, project);
            if (type == null || !type.exists()) {
                return !typeMustExist;
            }
            if (type.isClass()) {
                boolean isAbstract = Flags.isAbstract((int)type.getFlags());
                if (isAbstract ? !isAbstractClassOk : !isClassOk) {
                    return false;
                }
                boolean st = this.validateRequiredType(type, val);
                if (st) return true;
                return st;
            } else if (type.isAnnotation()) {
                if (isAnnotationOk) return true;
                return false;
            } else if (type.isInterface()) {
                if (!isInterfaceOk) {
                    return false;
                }
                boolean st = this.validateRequiredType(type, val);
                if (st) return true;
                return st;
            } else {
                if (!type.isEnum() || isEnumOk) return true;
                return false;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    private boolean validateRequiredType(IType type, String typeName) throws JavaModelException {
        if (this.validBaseTypes != null && this.validBaseTypes.size() > 0) {
            ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(null);
            for (String baseType : this.validBaseTypes) {
                if (type.getFullyQualifiedName().equals(baseType)) {
                    return true;
                }
                IType[] iTypeArray = typeHierarchy.getAllSupertypes(type);
                int n = iTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IType t = iTypeArray[n2];
                    if (t.getFullyQualifiedName().equals(baseType)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
        return true;
    }

    private static IType getType(String fullyQualifiedType, IProject project) {
        if (fullyQualifiedType.trim().length() == 0 || fullyQualifiedType.startsWith(".") || fullyQualifiedType.endsWith(".")) {
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null || !javaProject.exists()) {
            return null;
        }
        IType type = null;
        try {
            type = javaProject.findType(fullyQualifiedType);
            if (type != null && (!type.exists() || type.isAnonymous())) {
                type = null;
            }
        }
        catch (JavaModelException javaModelException) {}
        return type;
    }

    public String getInvalidValueMessage(String invalidValue) {
        String className = this.getFactory().text();
        IMethod[] methods = this.getAllMethods();
        if (methods != null) {
            IMethod[] iMethodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (invalidValue.equals(method.getElementName())) {
                    try {
                        this.validBaseTypes = this.getReturnTypes();
                        if (this.validBaseTypes != null && this.validBaseTypes.size() > 0) {
                            String returnType = Signature.toString((String)method.getReturnType());
                            return Resources.bind((String)Resources.invalidReturnTypeMessage, (Object)returnType, (Object)this.validBaseTypes.get(0));
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
                ++n2;
            }
        }
        return Resources.bind((String)Resources.invalidValueMessage, (Object)invalidValue, (Object)className);
    }

    private static final class Resources
    extends NLS {
        public static String invalidValueMessage;
        public static String invalidReturnTypeMessage;

        static {
            Resources.initializeMessages((String)MethodValuesProvider.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

