/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.internal;

import java.util.ArrayList;
import java.util.SortedSet;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.LayeredElementBindingImpl;
import org.eclipse.sapphire.modeling.xml.ChildXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlMetaComment;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.XmlUtil;
import org.eclipse.sapphire.modeling.xml.annotations.XmlElementBinding;
import org.eclipse.sapphire.services.PossibleTypesService;
import org.w3c.dom.Node;

public class InstanceGroupElementBinding
extends LayeredElementBindingImpl {
    @Text(value="failure = {0}.{1} : {2}")
    private static LocalizableText failure;
    private XmlPath parent_path;
    private ElementType instanceType;
    private QName[] instanceNames;
    private ElementType thisType;
    private QName[] thisNames;

    static {
        LocalizableText.init(InstanceGroupElementBinding.class);
    }

    public void init(Property property) {
        super.init(property);
        this.initBindingMetadata();
    }

    private void initBindingMetadata() {
        Property property = this.property();
        try {
            XmlElementBinding xmlElementBindingAnnotation = (XmlElementBinding)property.definition().getAnnotation(XmlElementBinding.class);
            XmlNamespaceResolver xmlNamespaceResolver = ((XmlResource)property.element().resource()).getXmlNamespaceResolver();
            PossibleTypesService possibleTypesService = (PossibleTypesService)property.service(PossibleTypesService.class);
            SortedSet possible = possibleTypesService.types();
            ElementType[] ElementTypes = possible.toArray(new ElementType[possible.size()]);
            if (xmlElementBindingAnnotation.path().length() > 0) {
                String path = xmlElementBindingAnnotation.path();
                this.parent_path = new XmlPath(path, xmlNamespaceResolver);
            }
            XmlElementBinding.Mapping[] mappings = xmlElementBindingAnnotation.mappings();
            int i = 0;
            while (i < ElementTypes.length) {
                ElementType type = ElementTypes[i];
                XmlElementBinding.Mapping[] mappingArray = mappings;
                int n = mappings.length;
                int n2 = 0;
                while (n2 < n) {
                    XmlElementBinding.Mapping mapping = mappingArray[n2];
                    if (mapping.type() == type.getModelElementClass()) {
                        String mappingElementName = mapping.element().trim();
                        if ("$$instance".equals(mappingElementName)) {
                            this.instanceType = type;
                            this.instanceNames = new QName[4];
                            this.instanceNames[0] = XmlUtil.createQualifiedName((String)"class-name", (XmlNamespaceResolver)xmlNamespaceResolver);
                            this.instanceNames[1] = XmlUtil.createQualifiedName((String)"class-factory-name", (XmlNamespaceResolver)xmlNamespaceResolver);
                            this.instanceNames[2] = XmlUtil.createQualifiedName((String)"method-name", (XmlNamespaceResolver)xmlNamespaceResolver);
                            this.instanceNames[3] = XmlUtil.createQualifiedName((String)"init-params", (XmlNamespaceResolver)xmlNamespaceResolver);
                        } else {
                            this.thisType = type;
                            ArrayList<String> list = new ArrayList<String>();
                            StringTokenizer tokenizer = new StringTokenizer(mappingElementName, ",");
                            while (tokenizer.hasMoreTokens()) {
                                list.add(tokenizer.nextToken());
                            }
                            this.thisNames = new QName[list.size()];
                            int index = 0;
                            for (String name : list) {
                                this.thisNames[index++] = XmlUtil.createQualifiedName((String)name, (XmlNamespaceResolver)xmlNamespaceResolver);
                            }
                        }
                    }
                    ++n2;
                }
                ++i;
            }
        }
        catch (Exception e) {
            String msg = failure.format(new Object[]{property.element().type().getSimpleName(), property.name(), e.getMessage()});
            throw new RuntimeException(msg, e);
        }
    }

    protected XmlElement base(boolean createIfNecessary) {
        XmlResource resource = (XmlResource)this.property().element().resource();
        return resource.getXmlElement(createIfNecessary);
    }

    protected XmlElement parent(boolean createIfNecessary) {
        XmlElement parent = this.base(createIfNecessary);
        if (parent != null && this.parent_path != null) {
            parent = (XmlElement)parent.getChildNode(this.parent_path, createIfNecessary);
        }
        return parent;
    }

    protected QName createDefaultElementName(ElementType type, XmlNamespaceResolver xmlNamespaceResolver) {
        return XmlUtil.createDefaultElementName((ElementType)type);
    }

    protected Object readUnderlyingObject() {
        XmlElement parent = this.parent(false);
        if (parent != null) {
            String comment = parent.getMetaCommentText(this.property().name());
            if ("instance".equals(comment)) {
                return parent;
            }
            if (this.property().name().equals(comment)) {
                return parent;
            }
            for (XmlElement element : parent.getChildElements()) {
                QName xmlElementName = XmlUtil.createQualifiedName((Node)element.getDomNode());
                if (XmlUtil.contains((QName[])this.instanceNames, (QName)xmlElementName, (String)xmlElementName.getNamespaceURI())) {
                    return parent;
                }
                if (!XmlUtil.contains((QName[])this.thisNames, (QName)xmlElementName, (String)xmlElementName.getNamespaceURI())) continue;
                return parent;
            }
        }
        return null;
    }

    protected Object createUnderlyingObject(ElementType type) {
        XmlElement parent;
        XmlElement base = this.base(false);
        if (base != null && (parent = this.parent(false)) != null) {
            XmlMetaComment comment = parent.getMetaComment(this.property().name(), false);
            if (comment != null) {
                comment.remove();
            }
            for (XmlElement element : parent.getChildElements()) {
                QName xmlElementName = XmlUtil.createQualifiedName((Node)element.getDomNode());
                if (XmlUtil.contains((QName[])this.instanceNames, (QName)xmlElementName, (String)xmlElementName.getNamespaceURI())) {
                    element.remove();
                }
                if (!XmlUtil.contains((QName[])this.thisNames, (QName)xmlElementName, (String)xmlElementName.getNamespaceURI())) continue;
                element.remove();
            }
        }
        parent = this.parent(true);
        if (type.equals(this.thisType)) {
            parent.setMetaCommentText(this.property().name(), this.property().name());
            return parent;
        }
        if (type.equals(this.instanceType)) {
            parent.setMetaCommentText(this.property().name(), "instance");
            return parent;
        }
        return null;
    }

    protected Resource createResource(Object obj) {
        XmlElement xmlElement = (XmlElement)obj;
        XmlResource parentXmlResource = (XmlResource)this.property().element().resource();
        return new ChildXmlResource((Resource)parentXmlResource, xmlElement);
    }

    public ElementType type(Resource resource) {
        XmlElement xmlElement = ((XmlResource)resource).getXmlElement();
        String text = xmlElement.getMetaCommentText(this.property().name());
        if ("instance".equals(text)) {
            return this.instanceType;
        }
        if (this.property().name().equals(text)) {
            return this.thisType;
        }
        for (XmlElement element : xmlElement.getChildElements()) {
            QName xmlElementName = XmlUtil.createQualifiedName((Node)element.getDomNode());
            if (XmlUtil.contains((QName[])this.instanceNames, (QName)xmlElementName, (String)xmlElementName.getNamespaceURI())) {
                return this.instanceType;
            }
            if (!XmlUtil.contains((QName[])this.thisNames, (QName)xmlElementName, (String)xmlElementName.getNamespaceURI())) continue;
            return this.thisType;
        }
        throw new IllegalStateException();
    }

    public void remove() {
        XmlElement parent;
        XmlElement base = this.base(false);
        if (base != null && (parent = this.parent(false)) != null) {
            XmlMetaComment comment = parent.getMetaComment(this.property().name(), false);
            if (comment != null) {
                comment.remove();
            }
            for (XmlElement element : parent.getChildElements()) {
                QName xmlElementName = XmlUtil.createQualifiedName((Node)element.getDomNode());
                if (XmlUtil.contains((QName[])this.instanceNames, (QName)xmlElementName, (String)xmlElementName.getNamespaceURI())) {
                    element.remove();
                }
                if (!XmlUtil.contains((QName[])this.thisNames, (QName)xmlElementName, (String)xmlElementName.getNamespaceURI())) continue;
                element.remove();
            }
            if (parent != base && parent.isEmpty()) {
                base.removeChildNode(this.parent_path);
            }
        }
    }
}

