/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.internal;

import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class IPAddressValidationService
extends ValidationService {
    protected Status compute() {
        Value value = (Value)this.context(Value.class);
        String address = value.text();
        if (address != null && !address.equals("")) {
            int j = 0;
            while (j < 4) {
                int index = address.indexOf(".");
                if (index == -1 && j < 3) {
                    String label = value.definition().getLabel(true, CapitalizationType.NO_CAPS, false);
                    return Status.createErrorStatus((String)Resources.bind((String)Resources.ipAddressError, (Object)value.text(), (Object)label));
                }
                if (j == 3) {
                    index = address.length();
                }
                int i = 0;
                while (i < index) {
                    if (!Character.isDigit(address.charAt(i))) {
                        String label = value.definition().getLabel(true, CapitalizationType.NO_CAPS, false);
                        return Status.createErrorStatus((String)Resources.bind((String)Resources.ipAddressError, (Object)value.text(), (Object)label));
                    }
                    ++i;
                }
                if (j < 3) {
                    address = address.substring(index + 1);
                }
                ++j;
            }
        }
        return Status.createOkStatus();
    }

    private static final class Resources
    extends NLS {
        public static String ipAddressError;

        static {
            Resources.initializeMessages((String)IPAddressValidationService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

