/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.internal;

import oracle.eclipse.tools.coherence.CoherenceVersion;
import oracle.eclipse.tools.coherence.facets.CoherenceFacet;
import org.eclipse.core.resources.IProject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public final class CoherenceVersionValidator
extends ValidationService {
    protected Status compute() {
        Version version;
        Value value = (Value)this.context(Value.class);
        String stringValue = value.text(false);
        if (stringValue != null && (version = (Version)value.content(false)) != null) {
            IProjectFacetVersion fv;
            Version major = CoherenceVersion.major(version);
            if (major == null) {
                String msg = NLS.bind((String)Resources.cannotParseValueMessage, (Object)stringValue);
                return Status.createErrorStatus((String)msg);
            }
            IProject project = (IProject)value.element().adapt(IProject.class);
            if (project != null && (fv = CoherenceFacet.getProjectFacet(project)) != null && !fv.getVersionString().equals(major.toString())) {
                String msg = NLS.bind((String)Resources.facetDoesNotMatchMessage, (Object)fv.getProjectFacet().getLabel());
                return Status.createErrorStatus((String)msg);
            }
        }
        return Status.createOkStatus();
    }

    private static final class Resources
    extends NLS {
        public static String cannotParseValueMessage;
        public static String facetDoesNotMatchMessage;

        static {
            Resources.initializeMessages((String)CoherenceVersionValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

