/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal;

import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ICacheMappingInitParam;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ICachingScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ICoherenceCacheConfig;
import oracle.eclipse.tools.coherence.descriptors.internal.NumberWithUnit;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class UserParamsValuesValidator
extends ValidationService {
    private FilteredListener<PropertyContentEvent> listener;

    protected void initValidationService() {
        super.initValidationService();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                UserParamsValuesValidator.this.refresh();
            }
        };
        ICacheMappingInitParam param = (ICacheMappingInitParam)this.context(ICacheMappingInitParam.class);
        if (param != null) {
            param.getParamName().attach(this.listener);
        }
    }

    public void dispose() {
        super.dispose();
        ICacheMappingInitParam param = (ICacheMappingInitParam)this.context(ICacheMappingInitParam.class);
        if (param != null && !param.disposed()) {
            param.getParamName().detach(this.listener);
        }
    }

    protected Status compute() {
        Value value = (Value)this.context(Value.class);
        String content = value.text();
        if (content != null && content.length() > 0) {
            ICacheMappingInitParam param = (ICacheMappingInitParam)this.context(ICacheMappingInitParam.class);
            String name = param.getParamName().text();
            return this.validate(name, content);
        }
        return Status.createOkStatus();
    }

    private Status validate(String name, String value) {
        Element descriptor = ((Element)this.context(Element.class)).root();
        if (descriptor instanceof ICoherenceCacheConfig) {
            ICoherenceCacheConfig config = (ICoherenceCacheConfig)descriptor;
            for (ICachingScheme scheme : config.getCachingSchemes()) {
                ElementType type = scheme.type();
                String paramPropertyName = null;
                for (PropertyDef property : type.properties()) {
                    String text;
                    Property obj;
                    if (!property.name().endsWith("Param") || !((obj = scheme.property(property)) instanceof Value) || !name.equals(text = ((Value)obj).text())) continue;
                    paramPropertyName = property.name();
                    break;
                }
                if (paramPropertyName == null) continue;
                paramPropertyName = paramPropertyName.substring(0, paramPropertyName.length() - "Param".length());
                for (PropertyDef property : type.properties()) {
                    if (!property.name().equals(paramPropertyName)) continue;
                    PropertyDef unitProperty = this.getUnitProperty(type, paramPropertyName);
                    if (unitProperty != null) {
                        NumberWithUnit nu = NumberWithUnit.parse(value);
                        ICoherenceCacheConfig newConfig = (ICoherenceCacheConfig)ICoherenceCacheConfig.TYPE.instantiate();
                        Element newElement = newConfig.getCachingSchemes().insert(property.getModelElementType());
                        newElement.resource().binding((ValueProperty)property).write(nu.getNumber());
                        newElement.resource().binding((ValueProperty)unitProperty).write(nu.getUnit());
                        newElement.property(property).refresh();
                        newElement.property(unitProperty).refresh();
                        Value newValue = newElement.property((ValueProperty)property);
                        Value newUnitValue = newElement.property((ValueProperty)unitProperty);
                        Status.CompositeStatusFactory factory = Status.factoryForComposite();
                        factory.merge(newValue.validation());
                        factory.merge(newUnitValue.validation());
                        return factory.create();
                    }
                    if (!(property instanceof ValueProperty)) continue;
                    ICoherenceCacheConfig newConfig = (ICoherenceCacheConfig)ICoherenceCacheConfig.TYPE.instantiate();
                    Element newElement = newConfig.getCachingSchemes().insert(property.getModelElementType());
                    newElement.resource().binding((ValueProperty)property).write(value);
                    newElement.property(property).refresh();
                    Value newValue = newElement.property((ValueProperty)property);
                    return newValue.validation();
                }
            }
        }
        return Status.createOkStatus();
    }

    private PropertyDef getUnitProperty(ElementType type, String name) {
        String unitName = String.valueOf(name) + "Unit";
        for (PropertyDef property : type.properties()) {
            if (!property.name().equals(unitName)) continue;
            return property;
        }
        return null;
    }
}

