/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal;

import java.math.BigDecimal;
import oracle.eclipse.tools.coherence.descriptors.TimeUnit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class TimeValidator
extends ValidationService {
    private String unitProp;
    private BigDecimal minSec;
    private BigDecimal maxSec;

    protected void initValidationService() {
        this.unitProp = this.param("unitProp");
        try {
            int minSecInt = Integer.parseInt(this.param("min"));
            this.minSec = new BigDecimal(minSecInt);
            int maxSecInt = Integer.parseInt(this.param("max"));
            this.maxSec = new BigDecimal(maxSecInt);
        }
        catch (NumberFormatException numberFormatException) {}
    }

    protected Status compute() {
        BigDecimal digit;
        Value value = (Value)this.context(Value.class);
        if (value.content() != null && !BigDecimal.ZERO.equals(digit = (BigDecimal)value.content())) {
            ElementType type;
            ValueProperty prop;
            TimeUnit unit;
            BigDecimal time;
            Element element = value.element();
            if (this.unitProp != null && ((time = this.getTimeInSeconds(digit, unit = (TimeUnit)((Object)element.property(prop = (ValueProperty)(type = element.type()).property(this.unitProp)).content()))).compareTo(this.minSec) < 0 || time.compareTo(this.maxSec) > 0)) {
                return Status.createErrorStatus((String)Resources.bind((String)Resources.time_boundary, (Object)this.minSec, (Object)this.maxSec));
            }
        }
        return Status.createOkStatus();
    }

    private BigDecimal getTimeInSeconds(BigDecimal digit, TimeUnit unit) {
        switch (unit) {
            case MILLISECONDS: {
                return digit.divide(new BigDecimal(1000));
            }
            case MINUTES: {
                return digit.multiply(new BigDecimal(60));
            }
            case HOURS: {
                return digit.multiply(new BigDecimal(3600));
            }
            case DAYS: {
                return digit.multiply(new BigDecimal(86400));
            }
        }
        return digit;
    }

    private static final class Resources
    extends NLS {
        public static String time_boundary;

        static {
            Resources.initializeMessages((String)TimeValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

