/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal;

import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ICachingScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ICoherenceCacheConfig;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.VersionConstraint;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.services.ValidationService;

public final class SchemesModelElementHandleValidationService
extends ValidationService {
    @Text(value="{0} is not supported in this version.")
    private static LocalizableText notSupported;

    static {
        LocalizableText.init(SchemesModelElementHandleValidationService.class);
    }

    protected Status compute() {
        Value<String> value;
        Enablement enablement;
        ElementHandle handle = (ElementHandle)this.context(ElementHandle.of(ICachingScheme.class));
        ICachingScheme scheme = (ICachingScheme)handle.content();
        if (scheme != null && (enablement = (Enablement)(value = scheme.getSchemeName()).definition().getAnnotation(Enablement.class)) != null) {
            String expr = enablement.expr();
            int startIndex = expr.indexOf("'");
            int endIndex = expr.indexOf("'", startIndex + 1);
            if (startIndex > 0 && endIndex > startIndex) {
                Version version;
                VersionConstraint versionExpr;
                boolean isValid;
                String parameter = expr.substring(startIndex + 1, endIndex);
                ICoherenceCacheConfig cacheConfig = (ICoherenceCacheConfig)this.context(ICoherenceCacheConfig.class);
                if (cacheConfig != null && !(isValid = (versionExpr = new VersionConstraint(parameter)).check(version = (Version)cacheConfig.getVersion().content()))) {
                    String name = scheme.type().getLabel(false, CapitalizationType.FIRST_WORD_ONLY, false);
                    return Status.createErrorStatus((String)notSupported.format(new Object[]{name}));
                }
            }
        }
        return Status.createOkStatus();
    }
}

