/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal;

public class ParamType {
    private static final String PARAM_START = "{";
    private static final String PARAM_END = "}";
    private String name;
    private String value;

    public ParamType(String value) {
        this(null, value);
    }

    public ParamType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        if (this.name == null) {
            return this.value;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(PARAM_START);
        buf.append(this.name);
        if (this.value != null) {
            buf.append(" ");
            buf.append(this.value);
        }
        buf.append(PARAM_END);
        return buf.toString();
    }

    public static ParamType parse(String str) {
        String name = null;
        String value = str;
        if (value != null) {
            int index;
            if (value.startsWith(PARAM_START)) {
                value = value.substring(1);
            }
            if (value.endsWith(PARAM_END)) {
                value = value.substring(0, value.length() - 1);
            }
            if ((index = (value = value.trim()).indexOf(32)) > 0) {
                name = value.substring(0, index);
                value = value.substring(index + 1, value.length());
            }
        }
        return new ParamType(name, value);
    }
}

