/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal;

import oracle.eclipse.tools.coherence.descriptors.cacheConfig.CacheConfigInfo;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ICoherenceCacheConfig;
import oracle.eclipse.tools.coherence.descriptors.internal.CoherenceVersionUtil;
import oracle.eclipse.tools.common.util.ObjectUtil;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.w3c.dom.Document;

public class CacheConfigVersionListener
extends FilteredListener<PropertyContentEvent> {
    protected void handleTypedEvent(PropertyContentEvent event) {
        ICoherenceCacheConfig descriptor = (ICoherenceCacheConfig)event.property().element().nearest(ICoherenceCacheConfig.class);
        Version version = (Version)descriptor.getVersion().content();
        CacheConfigInfo info = CacheConfigInfo.getCacheConfigInfo(version);
        XmlElement element = ((XmlResource)descriptor.adapt(XmlResource.class)).getXmlElement(true);
        String currentNamespace = element.getNamespace();
        String expectedNamespace = info.getNamespace();
        String expectedSchemaLocation = info.getSchemaLocation();
        String expectedSystemId = info.getSystemId();
        boolean namespaceChangeNeeded = false;
        Document document = ((XmlResource)descriptor.adapt(XmlResource.class)).getXmlElement().getDomNode().getOwnerDocument();
        if (expectedSystemId != null) {
            if (document.getDoctype() == null) {
                namespaceChangeNeeded = true;
            }
        } else if (ObjectUtil.equal((Object)currentNamespace, (Object)expectedNamespace)) {
            String currentSchemaLocation = element.getSchemaLocation();
            if (currentSchemaLocation == null || !currentSchemaLocation.equals(expectedSchemaLocation)) {
                namespaceChangeNeeded = true;
            }
        } else {
            namespaceChangeNeeded = true;
        }
        if (namespaceChangeNeeded) {
            CoherenceVersionUtil.changeNamespace(document, "cache-config", currentNamespace, expectedNamespace, expectedSchemaLocation, expectedSystemId);
        }
    }
}

