/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.cacheConfig;

import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ICachingScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IInitiatorConfig;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IOperationBundling;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.OverrideValuesProvider;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.ParamTypeCustomBinding;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IRemoteCacheScheme
extends ICachingScheme {
    public static final ElementType TYPE = new ElementType(IRemoteCacheScheme.class);
    @XmlBinding(path="service-name")
    @Label(standard="service")
    @Service(impl=OverrideValuesProvider.class, params={@Service.Param(name="parentPath", value="cluster-config/services"), @Service.Param(name="attributePath", value="id"), @Service.Param(name="valuePath", value="service-type"), @Service.Param(name="severity", value="ok")})
    @Documentation(content="Specifies the service name configuration info.")
    public static final ValueProperty PROP_SERVICE_NAME = new ValueProperty(TYPE, "ServiceName");
    @Type(base=IOperationBundling.class)
    @XmlBinding(path="operation-bundling")
    @Label(standard="operation bundling")
    public static final ElementProperty PROP_OPERATION_BUNDLING = new ElementProperty(TYPE, "OperationBundling");
    @Type(base=IInitiatorConfig.class)
    @XmlBinding(path="initiator-config")
    @Label(standard="initiator config")
    public static final ElementProperty PROP_INITIATOR_CONFIG = new ElementProperty(TYPE, "InitiatorConfig");
    @Type(base=Boolean.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"defer-key-association-check"})
    @Label(standard="defer key association check")
    @DefaultValue(text="false")
    @Since(value="3.7.1")
    @Documentation(content="Specifies whether a key should be checked for KeyAssociation by the extend client (false) or deferred until the key is received by the PartionedService (true).[pbr/]Set the defer-key-association-check element value to true when the Java key class defined on the Coherence cluster-side should be used for KeyAssociation processing.")
    public static final ValueProperty PROP_DEFER_KEY_ASSOCIATION_CHECK = new ValueProperty(TYPE, "DeferKeyAssociationCheck");
    @XmlBinding(path="proxy-service-name")
    @Label(standard="proxy service")
    @Documentation(content="Specifies the service name of the remote proxy service to which this remote service will connect. This name must match the <service name> element value of the remote proxy service.")
    public static final ValueProperty PROP_PROXY_SERVICE_NAME = new ValueProperty(TYPE, "ProxyServiceName");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"scope-name"})
    @Label(standard="scope")
    @Since(value="12.1.2")
    @Documentation(content="The scope-name element contains the scope name for this configuration. The scope name is typically added to the service name (as a prefix) for all services generated by a cache factory.  Scope may be used to isolate services indicated in this cache configuration from services created by cache factories with other configurations, thus avoiding unintended joining of services with similar names from different configurations.")
    public static final ValueProperty PROP_SCOPE_NAME = new ValueProperty(TYPE, "ScopeName");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"scope-name", "true"})
    public static final ValueProperty PROP_SCOPE_NAME_PARAM = new ValueProperty(TYPE, "ScopeNameParam");

    public Value<String> getServiceName();

    public void setServiceName(String var1);

    public ElementHandle<IOperationBundling> getOperationBundling();

    public ElementHandle<IInitiatorConfig> getInitiatorConfig();

    public Value<Boolean> getDeferKeyAssociationCheck();

    public void setDeferKeyAssociationCheck(String var1);

    public void setDeferKeyAssociationCheck(Boolean var1);

    public Value<String> getProxyServiceName();

    public void setProxyServiceName(String var1);

    public Value<String> getScopeName();

    public void setScopeName(String var1);

    public Value<String> getScopeNameParam();

    public void setScopeNameParam(String var1);
}

