/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.cacheConfig;

import java.math.BigDecimal;
import oracle.eclipse.tools.coherence.descriptors.TimeUnit;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ICachestoreScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ICachingScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IClassInitParam;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IClassScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IExternalScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IFlashjournalScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IListener;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ILocalScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IOverflowScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IPagedExternalScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IRamjournalScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.NumberWithUnitPropertyCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.ParamTypeCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.ReadWriteBackingMapCachingSchemePossibleTypesService;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.SchemeRefDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.internal.NumberUnitEnabler;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlElementBinding;

@Label(standard="read write backing map scheme")
public interface IReadWriteBackingMapScheme
extends ICachingScheme,
IClassInitParam {
    public static final ElementType TYPE = new ElementType(IReadWriteBackingMapScheme.class);
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS}, type={"com.tangosol.net.cache.ReadWriteBackingMap"})
    @Documentation(content="Specifies a custom implementation of the read write backing map. Any custom implementation must extend the com.tangosol.net.cache.ReadWriteBackingMap class and declare the exact same set of public constructors. ")
    public static final ValueProperty PROP_CLASS_NAME = new ValueProperty(TYPE, IClassInitParam.PROP_CLASS_NAME);
    @Type(base=ICachingScheme.class)
    @Service(impl=ReadWriteBackingMapCachingSchemePossibleTypesService.class)
    @XmlElementBinding(path="internal-cache-scheme", mappings={@XmlElementBinding.Mapping(element="class-scheme", type=IClassScheme.class), @XmlElementBinding.Mapping(element="external-scheme", type=IExternalScheme.class), @XmlElementBinding.Mapping(element="flashjournal-scheme", type=IFlashjournalScheme.class), @XmlElementBinding.Mapping(element="local-scheme", type=ILocalScheme.class), @XmlElementBinding.Mapping(element="overflow-scheme", type=IOverflowScheme.class), @XmlElementBinding.Mapping(element="paged-external-scheme", type=IPagedExternalScheme.class), @XmlElementBinding.Mapping(element="ramjournal-scheme", type=IRamjournalScheme.class)})
    @Label(standard="internal cache scheme")
    @Required
    public static final ElementProperty PROP_INTERNAL_CACHE_SCHEME = new ElementProperty(TYPE, "InternalCacheScheme");
    @Type(base=Integer.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"write-max-batch-size"})
    @Label(standard="write max batch size")
    @NumericRange(min="0")
    @DefaultValue(text="128")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="dependsOn", value="/CachingSchemes[#type=IReadWriteBackingMapScheme]/WriteMaxBatchSize")})
    @Documentation(content="Specifies the maximum number of entries to write in a single storeAll operation.")
    @Since(value="3.6")
    public static final ValueProperty PROP_WRITE_MAX_BATCH_SIZE = new ValueProperty(TYPE, "WriteMaxBatchSize");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"write-max-batch-size", "true"})
    public static final ValueProperty PROP_WRITE_MAX_BATCH_SIZE_PARAM = new ValueProperty(TYPE, "WriteMaxBatchSizeParam");
    @Type(base=ILocalScheme.class)
    @XmlElementBinding(path="miss-cache-scheme", mappings={@XmlElementBinding.Mapping(element="local-scheme", type=ILocalScheme.class)})
    public static final ElementProperty PROP_MISS_CACHE_SCHEME = new ElementProperty(TYPE, "MissCacheScheme");
    @Type(base=ICachestoreScheme.class)
    @XmlBinding(path="cachestore-scheme")
    public static final ImpliedElementProperty PROP_CACHE_STORE_SCHEME = new ImpliedElementProperty(TYPE, "CachestoreScheme");
    @Type(base=Boolean.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"read-only"})
    @Label(standard="read only")
    @DefaultValue(text="false")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="dependsOn", value="/CachingSchemes[#type=IReadWriteBackingMapScheme]/ReadOnly")})
    @Documentation(content="Specifies a readonly setting for the cachestore. If true the cache will only load data from cachestore for read operations and will not perform any writing to the cachestore when the cache is updated.")
    public static final ValueProperty PROP_READ_ONLY = new ValueProperty(TYPE, "ReadOnly");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"read-only", "true"})
    public static final ValueProperty PROP_READ_ONLY_PARAM = new ValueProperty(TYPE, "ReadOnlyParam");
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"write-delay", "true"})
    @Label(standard="write delay")
    @NumericRange(min="0")
    @DefaultValue(text="0")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="default", value="true"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IReadWriteBackingMapScheme]/WriteDelay")})
    @Documentation(content="Specifies the time interval for a write-behind queue to defer asynchronous writes to the cachestore by.")
    public static final ValueProperty PROP_WRITE_DELAY = new ValueProperty(TYPE, "WriteDelay");
    @Type(base=TimeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"write-delay", "false"})
    @DefaultValue(text="s")
    @Services(value={@Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="default", value="false"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IReadWriteBackingMapScheme]/WriteDelayUnit")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="WriteDelay")})})
    public static final ValueProperty PROP_WRITE_DELAY_UNIT = new ValueProperty(TYPE, "WriteDelayUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"write-delay", "true", "true"})
    public static final ValueProperty PROP_WRITE_DELAY_PARAM = new ValueProperty(TYPE, "WriteDelayParam");
    @Type(base=Double.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"write-batch-factor"})
    @Label(standard="write batch factor")
    @DefaultValue(text="0")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="dependsOn", value="/CachingSchemes[#type=IReadWriteBackingMapScheme]/WriteBatchFactor")})
    @NumericRange(min="0.0", max="1.0")
    @Documentation(content="Specifies the \"soft-ripe\" time for write-behind queue entries. [pbr/]A queue entry is considered to be \"ripe\" for a write operation if it has been in the write-behind queue for no less than the write-delay interval. The \"soft-rip\" time is the point in time prior to the actual ripe time after which an entry will be included in a batched asynchronous write operation to the cachestore (along with all other ripe and soft-ripe entries).")
    public static final ValueProperty PROP_WRITE_BATCH_FACTOR = new ValueProperty(TYPE, "WriteBatchFactor");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"write-batch-factor", "true"})
    public static final ValueProperty PROP_WRITE_BATCH_FACTOR_PARAM = new ValueProperty(TYPE, "WriteBatchFactorParam");
    @Type(base=Integer.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"write-requeue-threshold"})
    @Label(standard="write requeue threshold")
    @DefaultValue(text="0")
    @NumericRange(min="0")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="dependsOn", value="/CachingSchemes[#type=IReadWriteBackingMapScheme]/WriteRequeueThreshold")})
    @Documentation(content="Specifies the size of the write-behind queue at which additional actions could be taken. [pbr/]If zero, the requeueing is disabled. ")
    public static final ValueProperty PROP_WRITE_REQUEUE_THRESHOLD = new ValueProperty(TYPE, "WriteRequeueThreshold");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"write-requeue-threshold", "true"})
    public static final ValueProperty PROP_WRITE_REQUEUE_THRESHOLD_PARAM = new ValueProperty(TYPE, "WriteRequeueThresholdParam");
    @Type(base=Double.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"refresh-ahead-factor"})
    @Label(standard="refresh-ahead-factor")
    @DefaultValue(text="0")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="dependsOn", value="/CachingSchemes[#type=IReadWriteBackingMapScheme]/RefreshAheadFactor")})
    @NumericRange(min="0.0", max="1.0")
    @Documentation(content="Specifies the factor used to calculate the \"soft-expiration\" time for cache entries. [pbr/]Soft-expiration is the point in time prior to the actual expiration after which any access request for an entry will schedule an asynchronous load request for the entry. This element is only applicable for a ReadWriteBackingMap which has an internal LocalCache with scheduled automatic expiration.[pbr/]If zero, refresh-ahead scheduling will be disabled.")
    public static final ValueProperty PROP_REFRESH_AHEAD_FACTOR = new ValueProperty(TYPE, "RefreshAheadFactor");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"refresh-ahead-factor", "true"})
    public static final ValueProperty PROP_REFRESH_AHEAD_FACTOR_PARAM = new ValueProperty(TYPE, "RefreshAheadFactorParam");
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"cachestore-timeout", "true"})
    @Label(standard="cachestore timeout")
    @DefaultValue(text="0")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="default", value="true"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IReadWriteBackingMapScheme]/CachestoreTimeout")})
    @NumericRange(min="0")
    @Documentation(content="Specifies the timeout interval to use for cachestore read and write operations. If zero is specified, the default service guardian timeout will be used. If a cache store operation times out, the executing thread will be interrupted and may ultimately lead to the termination of the cache service.[pbr/]Note: As of Coherence 3.6, timeouts of asynchronous CacheStore operations (e.g. Refresh-Ahead, Write-Behind) will not result in service termination.")
    public static final ValueProperty PROP_CACHESTORE_TIMEOUT = new ValueProperty(TYPE, "CachestoreTimeout");
    @Type(base=TimeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"cachestore-timeout", "false"})
    @DefaultValue(text="ms")
    @Services(value={@Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="default", value="false"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IReadWriteBackingMapScheme]/CachestoreTimeoutUnit")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="CachestoreTimeout")})})
    public static final ValueProperty PROP_CACHESTORE_TIMEOUT_UNIT = new ValueProperty(TYPE, "CachestoreTimeoutUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"cachestore-timeout", "true", "true"})
    public static final ValueProperty PROP_CACHESTORE_TIMEOUT_PARAM = new ValueProperty(TYPE, "CachestoreTimeoutParam");
    @Type(base=Boolean.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"rollback-cachestore-failures"})
    @Label(standard="rollback cachestore failures")
    @DefaultValue(text="true")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="dependsOn", value="/CachingSchemes[#type=IReadWriteBackingMapScheme]/RollbackCachestoreFailures")})
    @Documentation(content="Specifies whether or not exceptions caught during synchronous cachestore operations are rethrown to the calling thread (possibly over the network to a remote member).")
    public static final ValueProperty PROP_ROLLBACK_CACHESTORE_FAILURES = new ValueProperty(TYPE, "RollbackCachestoreFailures");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"rollback-cachestore-failures", "true"})
    public static final ValueProperty PROP_ROLLBACK_CACHESTORE_FAILURES_PARAM = new ValueProperty(TYPE, "RollbackCachestoreFailuresParam");
    @Type(base=IListener.class)
    @XmlBinding(path="listener/class-scheme")
    public static final ImpliedElementProperty PROP_LISTENER = new ImpliedElementProperty(TYPE, "Listener");

    public ElementHandle<ICachingScheme> getInternalCacheScheme();

    public Value<Integer> getWriteMaxBatchSize();

    public void setWriteMaxBatchSize(String var1);

    public void setWriteMaxBatchSize(Integer var1);

    public Value<String> getWriteMaxBatchSizeParam();

    public void setWriteMaxBatchSizeParam(String var1);

    public ElementHandle<ILocalScheme> getMissCacheScheme();

    public ICachestoreScheme getCachestoreScheme();

    public Value<Boolean> getReadOnly();

    public void setReadOnly(String var1);

    public void setReadOnly(Boolean var1);

    public Value<String> getReadOnlyParam();

    public void setReadOnlyParam(String var1);

    public Value<BigDecimal> getWriteDelay();

    public void setWriteDelay(String var1);

    public void setWriteDelay(BigDecimal var1);

    public Value<TimeUnit> getWriteDelayUnit();

    public void setWriteDelayUnit(String var1);

    public void setWriteDelayUnit(TimeUnit var1);

    public Value<String> getWriteDelayParam();

    public void setWriteDelayParam(String var1);

    public Value<Double> getWriteBatchFactor();

    public void setWriteBatchFactor(String var1);

    public void setWriteBatchFactor(Double var1);

    public Value<String> getWriteBatchFactorParam();

    public void setWriteBatchFactorParam(String var1);

    public Value<Integer> getWriteRequeueThreshold();

    public void setWriteRequeueThreshold(String var1);

    public void setWriteRequeueThreshold(Integer var1);

    public Value<String> getWriteRequeueThresholdParam();

    public void setWriteRequeueThresholdParam(String var1);

    public Value<Double> getRefreshAheadFactor();

    public void setRefreshAheadFactor(String var1);

    public void setRefreshAheadFactor(Double var1);

    public Value<String> getRefreshAheadFactorParam();

    public void setRefreshAheadFactorParam(String var1);

    public Value<BigDecimal> getCachestoreTimeout();

    public void setCachestoreTimeout(String var1);

    public void setCachestoreTimeout(BigDecimal var1);

    public Value<TimeUnit> getCachestoreTimeoutUnit();

    public void setCachestoreTimeoutUnit(String var1);

    public void setCachestoreTimeoutUnit(TimeUnit var1);

    public Value<String> getCachestoreTimeoutParam();

    public void setCachestoreTimeoutParam(String var1);

    public Value<Boolean> getRollbackCachestoreFailures();

    public void setRollbackCachestoreFailures(String var1);

    public void setRollbackCachestoreFailures(Boolean var1);

    public Value<String> getRollbackCachestoreFailuresParam();

    public void setRollbackCachestoreFailuresParam(String var1);

    public IListener getListener();
}

