/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.cacheConfig;

import java.math.BigDecimal;
import oracle.eclipse.tools.coherence.descriptors.TimeUnit;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IAsyncStoreManager;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IBdbFileManager;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ICachingScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IClassInitParam;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ICustomStoreManager;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ILhFileManager;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IListener;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.INioFileManager;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.INioMemoryManager;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IStoreManagerBase;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.NumberWithUnitPropertyCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.PageLimitValidationService;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.ParamTypeCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.SchemeRefDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.TimeValidator;
import oracle.eclipse.tools.coherence.descriptors.internal.NumberUnitEnabler;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlElementBinding;

@Label(standard="page external scheme")
public interface IPagedExternalScheme
extends ICachingScheme,
IClassInitParam {
    public static final ElementType TYPE = new ElementType(IPagedExternalScheme.class);
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS}, type={"com.tangosol.net.cache.SerializationPagedCache"})
    @Documentation(content="Specifies a custom implementation of the external paged cache. Any custom implementation must extend the com.tangosol.net.cache.SerializationPagedCache class and declare the exact same set of public constructors.")
    public static final ValueProperty PROP_CLASS_NAME = new ValueProperty(TYPE, IClassInitParam.PROP_CLASS_NAME);
    @Type(base=IStoreManagerBase.class, possible={IAsyncStoreManager.class, IBdbFileManager.class, ICustomStoreManager.class, ILhFileManager.class, INioFileManager.class, INioMemoryManager.class})
    @XmlElementBinding(path="", mappings={@XmlElementBinding.Mapping(element="async-store-manager", type=IAsyncStoreManager.class), @XmlElementBinding.Mapping(element="bdb-store-manager", type=IBdbFileManager.class), @XmlElementBinding.Mapping(element="custom-store-manager", type=ICustomStoreManager.class), @XmlElementBinding.Mapping(element="lh-file-manager", type=ILhFileManager.class), @XmlElementBinding.Mapping(element="nio-file-manager", type=INioFileManager.class), @XmlElementBinding.Mapping(element="nio-memory-manager", type=INioMemoryManager.class)})
    @Label(standard="store manager")
    public static final ElementProperty PROP_STORE_MANAGER = new ElementProperty(TYPE, "StoreManager");
    @Type(base=Integer.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"page-limit"})
    @Label(standard="page limit")
    @DefaultValue(text="0")
    @Services(value={@Service(impl=PageLimitValidationService.class), @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="dependsOn", value="/CachingSchemes[#type=IPagedExternalScheme]/PageLimit")})})
    @Documentation(content="Specifies the maximum number of active pages.")
    public static final ValueProperty PROP_PAGE_LIMIT = new ValueProperty(TYPE, "PageLimit");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"page-limit", "true"})
    public static final ValueProperty PROP_PAGE_LIMIT_PARAM = new ValueProperty(TYPE, "PageLimitParam");
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"page-duration", "true"})
    @Label(standard="page duration")
    @NumericRange(min="0")
    @DefaultValue(text="0")
    @Services(value={@Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="default", value="true"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IPagedExternalScheme]/PageDuration")}), @Service(impl=TimeValidator.class, params={@Service.Param(name="unitProp", value="PageDurationUnit"), @Service.Param(name="min", value="5"), @Service.Param(name="max", value="604800")})})
    @Documentation(content="Specifies length of time, that a page is current.")
    public static final ValueProperty PROP_PAGE_DURATION = new ValueProperty(TYPE, "PageDuration");
    @Type(base=TimeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"page-duration", "false"})
    @DefaultValue(text="s")
    @Services(value={@Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="default", value="false"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IPagedExternalScheme]/PageDurationUnit")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="PageDuration")})})
    public static final ValueProperty PROP_PAGE_DURATION_UNIT = new ValueProperty(TYPE, "PageDurationUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"page-duration", "true", "true"})
    public static final ValueProperty PROP_PAGE_DURATION_PARAM = new ValueProperty(TYPE, "PageDurationParam");
    @Type(base=IListener.class)
    @XmlBinding(path="listener/class-scheme")
    public static final ImpliedElementProperty PROP_LISTENER = new ImpliedElementProperty(TYPE, "Listener");

    public ElementHandle<IStoreManagerBase> getStoreManager();

    public Value<Integer> getPageLimit();

    public void setPageLimit(String var1);

    public void setPageLimit(Integer var1);

    public Value<String> getPageLimitParam();

    public void setPageLimitParam(String var1);

    public Value<BigDecimal> getPageDuration();

    public void setPageDuration(String var1);

    public void setPageDuration(BigDecimal var1);

    public Value<TimeUnit> getPageDurationUnit();

    public void setPageDurationUnit(String var1);

    public void setPageDurationUnit(TimeUnit var1);

    public Value<String> getPageDurationParam();

    public void setPageDurationParam(String var1);

    public IListener getListener();
}

