/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.cacheConfig;

import java.math.BigDecimal;
import oracle.eclipse.tools.coherence.descriptors.TimeUnit;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ICachingScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IClassInitParam;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IClassScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IDistributedScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IExternalScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IFlashjournalScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IListener;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ILocalScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IOptimisticScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IPagedExternalScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IRamjournalScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IRemoteCacheScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IReplicatedScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ITransactionalScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.NearCachingSchemePossibleTypesService;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.NumberWithUnitPropertyCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.ParamTypeCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.SchemeRefDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.SchemesModelElementHandleValidationService;
import oracle.eclipse.tools.coherence.descriptors.internal.NumberUnitEnabler;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeConstraintBehavior;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlElementBinding;

@Label(standard="overflow scheme")
public interface IOverflowScheme
extends ICachingScheme,
IClassInitParam {
    public static final ElementType TYPE = new ElementType(IOverflowScheme.class);
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS}, type={"com.tangosol.net.cache.OverflowMap", "com.tangosol.net.cache.SimpleOverflowMap"}, behavior=JavaTypeConstraintBehavior.AT_LEAST_ONE)
    @Documentation(content="Specifies a custom implementation of the overflow cache. Any custom implementation must extend either the com.tangosol.net.cache.OverflowMap or com.tangosol.net.cache.SimpleOverflowMap class, and declare the exact same set of public constructors.")
    public static final ValueProperty PROP_CLASS_NAME = new ValueProperty(TYPE, IClassInitParam.PROP_CLASS_NAME);
    @Type(base=ICachingScheme.class, possible={IClassScheme.class, ILocalScheme.class})
    @XmlElementBinding(path="front-scheme", mappings={@XmlElementBinding.Mapping(element="class-scheme", type=IClassScheme.class), @XmlElementBinding.Mapping(element="local-scheme", type=ILocalScheme.class)})
    @Label(standard="front scheme")
    public static final ElementProperty PROP_FRONT_SCHEME = new ElementProperty(TYPE, "FrontScheme");
    @Type(base=ICachingScheme.class)
    @Services(value={@Service(impl=NearCachingSchemePossibleTypesService.class), @Service(impl=SchemesModelElementHandleValidationService.class)})
    @XmlElementBinding(path="back-scheme", mappings={@XmlElementBinding.Mapping(element="class-scheme", type=IClassScheme.class), @XmlElementBinding.Mapping(element="distributed-scheme", type=IDistributedScheme.class), @XmlElementBinding.Mapping(element="external-scheme", type=IExternalScheme.class), @XmlElementBinding.Mapping(element="flashjournal-scheme", type=IFlashjournalScheme.class), @XmlElementBinding.Mapping(element="local-scheme", type=ILocalScheme.class), @XmlElementBinding.Mapping(element="optimistic-scheme", type=IOptimisticScheme.class), @XmlElementBinding.Mapping(element="overflow-scheme", type=IOverflowScheme.class), @XmlElementBinding.Mapping(element="paged-external-scheme", type=IPagedExternalScheme.class), @XmlElementBinding.Mapping(element="ramjournal-scheme", type=IRamjournalScheme.class), @XmlElementBinding.Mapping(element="remote-cache-scheme", type=IRemoteCacheScheme.class), @XmlElementBinding.Mapping(element="replicated-scheme", type=IReplicatedScheme.class), @XmlElementBinding.Mapping(element="transactional-scheme", type=ITransactionalScheme.class)})
    @Label(standard="back scheme")
    public static final ElementProperty PROP_BACK_SCHEME = new ElementProperty(TYPE, "BackScheme");
    @Type(base=ILocalScheme.class)
    @XmlElementBinding(path="miss-cache-scheme", mappings={@XmlElementBinding.Mapping(element="local-scheme", type=ILocalScheme.class)})
    public static final ElementProperty PROP_MISS_CACHE_SCHEME = new ElementProperty(TYPE, "MissCacheScheme");
    @Type(base=Boolean.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"expiry-enabled"})
    @Label(standard="expiry enabled")
    @DefaultValue(text="false")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="dependsOn", value="/CachingSchemes[#type=IOverflowScheme]/ExpiryEnabled")})
    @Documentation(content="Turns on support for automatically-expiring data, as provided by the CacheMap API.")
    public static final ValueProperty PROP_EXPIRY_ENABLED = new ValueProperty(TYPE, "ExpiryEnabled");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"expiry-enabled", "true"})
    public static final ValueProperty PROP_EXPIRY_ENABLED_PARAM = new ValueProperty(TYPE, "ExpiryEnabledParam");
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"expiry-delay", "true"})
    @Label(standard="expiry delay")
    @NumericRange(min="0")
    @DefaultValue(text="0")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="default", value="true"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IOverflowScheme]/ExpiryDelay")})
    @Documentation(content="Specifies the amount of time from last update that entries will be kept by the cache before being discarded. A value of zero implies no expiry.")
    public static final ValueProperty PROP_EXPIRY_DELAY = new ValueProperty(TYPE, "ExpiryDelay");
    @Type(base=TimeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"expiry-delay", "false"})
    @DefaultValue(text="s")
    @Services(value={@Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="default", value="false"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IOverflowScheme]/ExpiryDelayUnit")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="ExpiryDelay")})})
    public static final ValueProperty PROP_EXPIRY_DELAY_UNIT = new ValueProperty(TYPE, "ExpiryDelayUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"expiry-delay", "true", "true"})
    public static final ValueProperty PROP_EXPIRY_DELAY_PARAM = new ValueProperty(TYPE, "ExpiryDelayParam");
    @Type(base=Boolean.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"autostart"})
    @Label(standard="autostart")
    @DefaultValue(text="false")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="dependsOn", value="/CachingSchemes[#type=IOverflowScheme]/Autostart")})
    @Since(value="3.7")
    @Documentation(content="Specifies whether or not the cache services associated with the cache scheme should be automatically started at a cluster node.")
    public static final ValueProperty PROP_AUTOSTART = new ValueProperty(TYPE, "Autostart");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"autostart", "true"})
    public static final ValueProperty PROP_AUTOSTART_PARAM = new ValueProperty(TYPE, "AutostartParam");
    @Type(base=IListener.class)
    @XmlBinding(path="listener/class-scheme")
    public static final ImpliedElementProperty PROP_LISTENER = new ImpliedElementProperty(TYPE, "Listener");

    public ElementHandle<ICachingScheme> getFrontScheme();

    public ElementHandle<ICachingScheme> getBackScheme();

    public ElementHandle<ILocalScheme> getMissCacheScheme();

    public Value<Boolean> getExpiryEnabled();

    public void setExpiryEnabled(String var1);

    public void setExpiryEnabled(Boolean var1);

    public Value<String> getExpiryEnabledParam();

    public void setExpiryEnabledParam(String var1);

    public Value<BigDecimal> getExpiryDelay();

    public void setExpiryDelay(String var1);

    public void setExpiryDelay(BigDecimal var1);

    public Value<TimeUnit> getExpiryDelayUnit();

    public void setExpiryDelayUnit(String var1);

    public void setExpiryDelayUnit(TimeUnit var1);

    public Value<String> getExpiryDelayParam();

    public void setExpiryDelayParam(String var1);

    public Value<Boolean> getAutostart();

    public void setAutostart(String var1);

    public void setAutostart(Boolean var1);

    public Value<String> getAutostartParam();

    public void setAutostartParam(String var1);

    public IListener getListener();
}

