/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.cacheConfig;

import oracle.eclipse.tools.coherence.descriptors.SizeUnit;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IStoreManagerBase;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.NumberWithUnitPropertyCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.internal.NumberUnitEnabler;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.annotations.AbsolutePath;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.FileSystemResourceType;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.annotations.ValidFileSystemResourceType;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

@Label(standard="NIO file manager")
public interface INioFileManager
extends IStoreManagerBase {
    public static final ElementType TYPE = new ElementType(INioFileManager.class);
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS}, type={"com.tangosol.io.nio.MappedStoreManager"})
    @Documentation(content="Specifies a custom implementation of the local cache. Any custom implementation must extend the com.tangosol.io.nio.MappedStoreManager class and declare the exact same set of public constructors.")
    public static final ValueProperty PROP_CLASS_NAME = new ValueProperty(TYPE, IStoreManagerBase.PROP_CLASS_NAME);
    @Type(base=Integer.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"initial-size", "true"})
    @Label(standard="initial size")
    @DefaultValue(text="1")
    @NumericRange(min="1")
    @Documentation(content="Specifies the initial buffer size in bytes.")
    public static final ValueProperty PROP_INITIAL_SIZE = new ValueProperty(TYPE, "InitialSize");
    @Type(base=SizeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"initial-size", "false"})
    @DefaultValue(text="MB")
    @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="InitialSize")})
    public static final ValueProperty PROP_INITIAL_SIZE_UNIT = new ValueProperty(TYPE, "InitialSizeUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"initial-size", "true", "true"})
    public static final ValueProperty PROP_INITIAL_SIZE_PARAM = new ValueProperty(TYPE, "InitialSizeParam");
    @Type(base=Integer.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"maximum-size", "true"})
    @Label(standard="maximum size")
    @DefaultValue(text="1024")
    @NumericRange(min="1")
    @Documentation(content="Specifies the maximum buffer size in bytes.")
    public static final ValueProperty PROP_MAXIMUM_SIZE = new ValueProperty(TYPE, "MaximumSize");
    @Type(base=SizeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"maximum-size", "false"})
    @DefaultValue(text="MB")
    @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="MaximumSize")})
    public static final ValueProperty PROP_MAXIMUM_SIZE_UNIT = new ValueProperty(TYPE, "MaximumSizeUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"maximum-size", "true", "true"})
    public static final ValueProperty PROP_MAXIMUM_SIZE_PARAM = new ValueProperty(TYPE, "MaximumSizeParam");
    @Type(base=Path.class)
    @XmlBinding(path="directory")
    @Label(standard="directory")
    @ValidFileSystemResourceType(value=FileSystemResourceType.FOLDER)
    @AbsolutePath
    @Documentation(content="Specifies the pathname for the [root] directory that a disk persistence manager or flashjournal-manager will use to store files in. If not specified or specifies a non-existent directory,a temporary file in the default location will be used.")
    public static final ValueProperty PROP_DIRECTORY = new ValueProperty(TYPE, "Directory");

    public Value<Integer> getInitialSize();

    public void setInitialSize(String var1);

    public void setInitialSize(Integer var1);

    public Value<SizeUnit> getInitialSizeUnit();

    public void setInitialSizeUnit(String var1);

    public void setInitialSizeUnit(SizeUnit var1);

    public Value<String> getInitialSizeParam();

    public void setInitialSizeParam(String var1);

    public Value<Integer> getMaximumSize();

    public void setMaximumSize(String var1);

    public void setMaximumSize(Integer var1);

    public Value<SizeUnit> getMaximumSizeUnit();

    public void setMaximumSizeUnit(String var1);

    public void setMaximumSizeUnit(SizeUnit var1);

    public Value<String> getMaximumSizeParam();

    public void setMaximumSizeParam(String var1);

    public Value<Path> getDirectory();

    public void setDirectory(String var1);

    public void setDirectory(Path var1);
}

