/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.cacheConfig;

import java.math.BigDecimal;
import oracle.eclipse.tools.coherence.descriptors.IModelElementBase;
import oracle.eclipse.tools.coherence.descriptors.IServiceFailurePolicyExitCluster;
import oracle.eclipse.tools.coherence.descriptors.IServiceFailurePolicyExitProcess;
import oracle.eclipse.tools.coherence.descriptors.IServiceFailurePolicyInstance;
import oracle.eclipse.tools.coherence.descriptors.IServiceFailurePolicyLogging;
import oracle.eclipse.tools.coherence.descriptors.TimeUnit;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ICachingScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IInterceptor;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IMemberListener;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ISerializer35;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ISerializerInstance;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ISerializerName;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.NumberWithUnitPropertyCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.OverrideValuesProvider;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.ParamTypeCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.SchemeRefDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.internal.NumberUnitEnabler;
import oracle.eclipse.tools.coherence.descriptors.internal.TextAndElementBinding;
import oracle.eclipse.tools.coherence.descriptors.override.ReliableTransport;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.VersionCompatibility;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlElementBinding;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlElementBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;

public interface IInvocationScheme
extends ICachingScheme {
    public static final ElementType TYPE = new ElementType(IInvocationScheme.class);
    @XmlBinding(path="service-name")
    @Label(standard="service")
    @Service(impl=OverrideValuesProvider.class, params={@Service.Param(name="parentPath", value="cluster-config/services"), @Service.Param(name="attributePath", value="id"), @Service.Param(name="valuePath", value="service-type"), @Service.Param(name="severity", value="ok")})
    @Documentation(content="Specifies the service name configuration info.")
    public static final ValueProperty PROP_SERVICE_NAME = new ValueProperty(TYPE, "ServiceName");
    @Type(base=ISerializer35.class)
    @XmlBinding(path="serializer")
    @Documentation(content="Specifies the class configuration info for a com.tangosol.io.Serializer implementation.")
    @VersionCompatibility(value="3.5]")
    public static final ImpliedElementProperty PROP_SERIALIZER35 = new ImpliedElementProperty(TYPE, "Serializer35");
    @Type(base=IModelElementBase.class, possible={ISerializerName.class, ISerializerInstance.class})
    @CustomXmlElementBinding(impl=TextAndElementBinding.class)
    @Since(value="3.6")
    @Label(standard="serializer")
    @XmlElementBinding(path="serializer", mappings={@XmlElementBinding.Mapping(element="$$ANY", type=ISerializerName.class), @XmlElementBinding.Mapping(element="instance", type=ISerializerInstance.class)})
    public static final ElementProperty PROP_SERIALIZER = new ElementProperty(TYPE, "Serializer");
    @Type(base=Integer.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"thread-count"})
    @Label(standard="thread count")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(4)/init-params/init-param(1)/param-value"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IInvocationScheme]/ThreadCount")})
    @Documentation(content="Specifies the number of daemon threads. If zero, all relevant tasks are performed on the service thread.If negative, tasks are performed on the caller's thread where possible.")
    public static final ValueProperty PROP_THREAD_COUNT = new ValueProperty(TYPE, "ThreadCount");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"thread-count", "true"})
    public static final ValueProperty PROP_THREAD_COUNT_PARAM = new ValueProperty(TYPE, "ThreadCountParam");
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"task-hung-threshold", "true"})
    @Label(standard="task hung threshold")
    @NumericRange(min="0")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(4)/init-params/init-param(2)/param-value"), @Service.Param(name="default", value="true"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IInvocationScheme]/TaskHungThreshold")})
    @Enablement(expr="${ThreadCount > 0}")
    @Documentation(content="Specifies the amount of time that a request can execute on a service worker thread before it is considered as \"hung\".")
    public static final ValueProperty PROP_TASK_HUNG_THRESHOLD = new ValueProperty(TYPE, "TaskHungThreshold");
    @Type(base=TimeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"task-hung-threshold", "false"})
    @DefaultValue(text="ms")
    @Services(value={@Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(4)/init-params/init-param(2)/param-value"), @Service.Param(name="default", value="false"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IInvocationScheme]/TaskHungThresholdUnit")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="TaskHungThreshold")})})
    @Enablement(expr="${ThreadCount > 0}")
    @Since(value="3.7.1")
    public static final ValueProperty PROP_TASK_HUNG_THRESHOLD_UNIT = new ValueProperty(TYPE, "TaskHungThresholdUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"task-hung-threshold", "true", "true"})
    public static final ValueProperty PROP_TASK_HUNG_THRESHOLD_PARAM = new ValueProperty(TYPE, "TaskHungThresholdParam");
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"task-timeout", "true"})
    @Label(standard="task timeout")
    @NumericRange(min="0")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(4)/init-params/init-param(3)/param-value"), @Service.Param(name="default", value="true"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IInvocationScheme]/TaskTimeout")})
    @Enablement(expr="${ThreadCount > 0}")
    @Documentation(content="Specifies the timeout value for requests executing on the service worker threads.")
    public static final ValueProperty PROP_TASK_TIMEOUT = new ValueProperty(TYPE, "TaskTimeout");
    @Type(base=TimeUnit.class)
    @DefaultValue(text="ms")
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"task-timeout", "false"})
    @Services(value={@Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(4)/init-params/init-param(3)/param-value"), @Service.Param(name="default", value="false"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IInvocationScheme]/TaskTimeoutUnit")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="TaskTimeout")})})
    @Enablement(expr="${ThreadCount > 0}")
    @Since(value="3.7.1")
    public static final ValueProperty PROP_TASK_TIMEOUT_UNIT = new ValueProperty(TYPE, "TaskTimeoutUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"task-timeout", "true", "true"})
    public static final ValueProperty PROP_TASK_TIMEOUT_PARAM = new ValueProperty(TYPE, "TaskTimeoutParam");
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"request-timeout", "true"})
    @Label(standard="request timeout")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(4)/init-params/init-param(4)/param-value"), @Service.Param(name="default", value="true"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IInvocationScheme]/RequestTimeout")})
    @NumericRange(min="0")
    @Documentation(content="Specifies the maximum amount of time a client waits for a response before abandoning the original request. The request time is measured on the client side as the time elapsed from the moment a request is sent for execution to the corresponding server node(s) and includes the following:[ul][li]the time it takes to deliver the request to an executing node (server) [/li][li]the interval between the time the task is received and placed into a service queue until the execution starts [/li][li]the task execution time [/li][li]the time it takes to deliver a result back to the client [/li][/ul]")
    public static final ValueProperty PROP_REQUEST_TIMEOUT = new ValueProperty(TYPE, "RequestTimeout");
    @Type(base=TimeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"request-timeout", "false"})
    @DefaultValue(text="ms")
    @Services(value={@Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(4)/init-params/init-param(4)/param-value"), @Service.Param(name="default", value="false"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IInvocationScheme]/RequestTimeoutUnit")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="RequestTimeout")})})
    public static final ValueProperty PROP_REQUEST_TIMEOUT_UNIT = new ValueProperty(TYPE, "RequestTimeoutUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"request-timeout", "true", "true"})
    public static final ValueProperty PROP_REQUEST_TIMEOUT_PARAM = new ValueProperty(TYPE, "RequestTimeoutParam");
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"guardian-timeout", "true"})
    @Label(standard="guardian timeout")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/service-guardian/timeout-milliseconds"), @Service.Param(name="default", value="true"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IInvocationScheme]/GuardianTimeout")})
    @NumericRange(min="0")
    @Documentation(content="Specifies the the guardian timeout value to use for guarding the service and any dependant threads.")
    public static final ValueProperty PROP_GUARDIAN_TIMEOUT = new ValueProperty(TYPE, "GuardianTimeout");
    @Type(base=TimeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"guardian-timeout", "false"})
    @DefaultValue(text="ms")
    @Services(value={@Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/service-guardian/timeout-milliseconds"), @Service.Param(name="default", value="false"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IInvocationScheme]/GuardianTimeoutUnit")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="GuardianTimeout")})})
    public static final ValueProperty PROP_GUARDIAN_TIMEOUT_UNIT = new ValueProperty(TYPE, "GuardianTimeoutUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"guardian-timeout", "true", "true"})
    public static final ValueProperty PROP_GUARDIAN_TIMEOUT_PARAM = new ValueProperty(TYPE, "GuardianTimeoutParam");
    @Type(base=IModelElementBase.class, possible={IServiceFailurePolicyExitProcess.class, IServiceFailurePolicyExitCluster.class, IServiceFailurePolicyLogging.class, IServiceFailurePolicyInstance.class})
    @CustomXmlElementBinding(impl=TextAndElementBinding.class)
    @Since(value="3.6")
    @Label(standard="service failure policy")
    @XmlElementBinding(path="service-failure-policy", mappings={@XmlElementBinding.Mapping(element="$$exit-process", type=IServiceFailurePolicyExitProcess.class), @XmlElementBinding.Mapping(element="$$exit-cluster", type=IServiceFailurePolicyExitCluster.class), @XmlElementBinding.Mapping(element="$$logging", type=IServiceFailurePolicyLogging.class), @XmlElementBinding.Mapping(element="instance", type=IServiceFailurePolicyInstance.class)})
    public static final ElementProperty PROP_SERVICE_FAILURE_POLICY = new ElementProperty(TYPE, "ServiceFailurePolicy");
    @Type(base=IMemberListener.class)
    @XmlBinding(path="member-listener")
    @Since(value="3.6")
    public static final ElementProperty PROP_MEMBER_LISTENER = new ElementProperty(TYPE, "MemberListener");
    @Type(base=Boolean.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"autostart"})
    @Label(standard="autostart")
    @DefaultValue(text="false")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="dependsOn", value="/CachingSchemes[#type=IInvocationScheme]/Autostart")})
    @Documentation(content="Specifies whether or not the cache services associated with the cache scheme should be automatically started at a cluster node.")
    public static final ValueProperty PROP_AUTOSTART = new ValueProperty(TYPE, "Autostart");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"autostart", "true"})
    public static final ValueProperty PROP_AUTOSTART_PARAM = new ValueProperty(TYPE, "AutostartParam");
    @Type(base=Integer.class)
    @Label(standard="service priority")
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"service-priority"})
    @NumericRange(min="1", max="10")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(4)/init-params/init-param(9)/param-value"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IInvocationScheme]/ServicePriority")})
    @Since(value="12.1.2")
    @Documentation(content="specifies the priority for the service thread.")
    public static final ValueProperty PROP_SERVICE_PRIORITY = new ValueProperty(TYPE, "ServicePriority");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"service-priority", "true"})
    public static final ValueProperty PROP_SERVICE_PRIORITY_PARAM = new ValueProperty(TYPE, "ServicePriorityParam");
    @Type(base=Integer.class)
    @Label(standard="event dispatcher priority")
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"event-dispatcher-priority"})
    @NumericRange(min="1", max="10")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(4)/init-params/init-param(10)/param-value"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IInvocationScheme]/EventDispatcherPriority")})
    @Since(value="12.1.2")
    @Documentation(content="specifies the priority for the event dispatcher thread for each service.")
    public static final ValueProperty PROP_EVENT_DISPATCHER_PRIORITY = new ValueProperty(TYPE, "EventDispatcherPriority");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"event-dispatcher-priority", "true"})
    public static final ValueProperty PROP_EVENT_DISPATCHER_PRIORITY_PARAM = new ValueProperty(TYPE, "EventDispatcherPriorityParam");
    @Type(base=ReliableTransport.class)
    @Label(standard="reliable transport")
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"reliable-transport"})
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/unicast-listener/reliable-transport"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IInvocationScheme]/ReliableTransport")})
    @Since(value="12.1.2")
    @Documentation(content="Contains the name of the transport used by the TCMP for reliable point-to-point communications.")
    public static final ValueProperty PROP_RELIABLE_TRANSPORT = new ValueProperty(TYPE, "ReliableTransport");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"reliable-transport", "true"})
    public static final ValueProperty PROP_RELIABLE_TRANSPORT_PARAM = new ValueProperty(TYPE, "ReliableTransportParam");
    @Type(base=Integer.class)
    @Label(standard="worker priority")
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"worker-priority"})
    @NumericRange(min="1", max="10")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(4)/init-params/init-param(11)/param-value"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IInvocationScheme]/WorkerPriority")})
    @Since(value="12.1.2")
    @Documentation(content="specifies the priority for the worker threads.")
    public static final ValueProperty PROP_WORKER_PRIORITY = new ValueProperty(TYPE, "WorkerPriority");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"worker-priority", "true"})
    public static final ValueProperty PROP_WORKER_PRIORITY_PARAM = new ValueProperty(TYPE, "WorkerPriorityParam");
    @Type(base=IInterceptor.class)
    @XmlListBinding(path="interceptors", mappings={@XmlListBinding.Mapping(element="interceptor", type=IInterceptor.class)})
    @Since(value="12.1.2")
    @Label(standard="interceptors")
    public static final ListProperty PROP_INTERCEPTORS = new ListProperty(TYPE, "Interceptors");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"scope-name"})
    @Label(standard="scope")
    @Since(value="12.1.2")
    @Documentation(content="The scope-name element contains the scope name for this configuration. The scope name is typically added to the service name (as a prefix) for all services generated by a cache factory.  Scope may be used to isolate services indicated in this cache configuration from services created by cache factories with other configurations, thus avoiding unintended joining of services with similar names from different configurations.")
    public static final ValueProperty PROP_SCOPE_NAME = new ValueProperty(TYPE, "ScopeName");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"scope-name", "true"})
    public static final ValueProperty PROP_SCOPE_NAME_PARAM = new ValueProperty(TYPE, "ScopeNameParam");

    public Value<String> getServiceName();

    public void setServiceName(String var1);

    public ISerializer35 getSerializer35();

    public ElementHandle<IModelElementBase> getSerializer();

    public Value<Integer> getThreadCount();

    public void setThreadCount(String var1);

    public void setThreadCount(Integer var1);

    public Value<String> getThreadCountParam();

    public void setThreadCountParam(String var1);

    public Value<BigDecimal> getTaskHungThreshold();

    public void setTaskHungThreshold(String var1);

    public void setTaskHungThreshold(BigDecimal var1);

    public Value<TimeUnit> getTaskHungThresholdUnit();

    public void setTaskHungThresholdUnit(String var1);

    public void setTaskHungThresholdUnit(TimeUnit var1);

    public Value<String> getTaskHungThresholdParam();

    public void setTaskHungThresholdParam(String var1);

    public Value<BigDecimal> getTaskTimeout();

    public void setTaskTimeout(String var1);

    public void setTaskTimeout(BigDecimal var1);

    public Value<TimeUnit> getTaskTimeoutUnit();

    public void setTaskTimeoutUnit(String var1);

    public void setTaskTimeoutUnit(TimeUnit var1);

    public Value<String> getTaskTimeoutParam();

    public void setTaskTimeoutParam(String var1);

    public Value<BigDecimal> getRequestTimeout();

    public void setRequestTimeout(String var1);

    public void setRequestTimeout(BigDecimal var1);

    public Value<TimeUnit> getRequestTimeoutUnit();

    public void setRequestTimeoutUnit(String var1);

    public void setRequestTimeoutUnit(TimeUnit var1);

    public Value<String> getRequestTimeoutParam();

    public void setRequestTimeoutParam(String var1);

    public Value<BigDecimal> getGuardianTimeout();

    public void setGuardianTimeout(String var1);

    public void setGuardianTimeout(BigDecimal var1);

    public Value<TimeUnit> getGuardianTimeoutUnit();

    public void setGuardianTimeoutUnit(String var1);

    public void setGuardianTimeoutUnit(TimeUnit var1);

    public Value<String> getGuardianTimeoutParam();

    public void setGuardianTimeoutParam(String var1);

    public ElementHandle<IModelElementBase> getServiceFailurePolicy();

    public ElementHandle<IMemberListener> getMemberListener();

    public Value<Boolean> getAutostart();

    public void setAutostart(String var1);

    public void setAutostart(Boolean var1);

    public Value<String> getAutostartParam();

    public void setAutostartParam(String var1);

    public Value<Integer> getServicePriority();

    public void setServicePriority(String var1);

    public void setServicePriority(Integer var1);

    public Value<String> getServicePriorityParam();

    public void setServicePriorityParam(String var1);

    public Value<Integer> getEventDispatcherPriority();

    public void setEventDispatcherPriority(String var1);

    public void setEventDispatcherPriority(Integer var1);

    public Value<String> getEventDispatcherPriorityParam();

    public void setEventDispatcherPriorityParam(String var1);

    public Value<ReliableTransport> getReliableTransport();

    public void setReliableTransport(String var1);

    public void setReliableTransport(ReliableTransport var1);

    public Value<String> getReliableTransportParam();

    public void setReliableTransportParam(String var1);

    public Value<Integer> getWorkerPriority();

    public void setWorkerPriority(String var1);

    public void setWorkerPriority(Integer var1);

    public Value<String> getWorkerPriorityParam();

    public void setWorkerPriorityParam(String var1);

    public ElementList<IInterceptor> getInterceptors();

    public Value<String> getScopeName();

    public void setScopeName(String var1);

    public Value<String> getScopeNameParam();

    public void setScopeNameParam(String var1);
}

