/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.cacheConfig;

import oracle.eclipse.tools.coherence.descriptors.ILocalAddress;
import oracle.eclipse.tools.coherence.descriptors.IModelElementBase;
import oracle.eclipse.tools.coherence.descriptors.ISocketProviderInstance;
import oracle.eclipse.tools.coherence.descriptors.ISocketProviderSdp;
import oracle.eclipse.tools.coherence.descriptors.ISocketProviderSsl;
import oracle.eclipse.tools.coherence.descriptors.ISocketProviderSystem;
import oracle.eclipse.tools.coherence.descriptors.ISocketProviderTcp;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.AuthMethod;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IClassInitParam;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IResourceConfig;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ISocketProviderCacheConfigName;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.CacheConfigSocketProviderNamePossibleTypesService;
import oracle.eclipse.tools.coherence.descriptors.internal.TextAndElementBinding;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlElementBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlElementBinding;

@Label(standard="HTTP Acceptor")
public interface IHttpAcceptor
extends IClassInitParam,
IModelElementBase {
    public static final ElementType TYPE = new ElementType(IHttpAcceptor.class);
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS}, type={"com.tangosol.coherence.rest.server.HttpServer"})
    @Documentation(content="Specifies the configuration info for a connection acceptor that accepts connections from remote REST clients over HTTP. Any custom implementation must extend the com.tangosol.coherence.rest.server.HttpServer class")
    public static final ValueProperty PROP_CLASS_NAME = new ValueProperty(TYPE, IClassInitParam.PROP_CLASS_NAME);
    @Type(base=ILocalAddress.class)
    @XmlBinding(path="local-address")
    @Label(standard="local address")
    public static final ImpliedElementProperty PROP_LOCAL_ADDRESS = new ImpliedElementProperty(TYPE, "LocalAddress");
    @Type(base=IResourceConfig.class)
    @XmlBinding(path="resource-config/instance")
    public static final ElementProperty PROP_RESOURCE_CONFIG = new ElementProperty(TYPE, "ResourceConfig");
    @Type(base=IModelElementBase.class)
    @Service(impl=CacheConfigSocketProviderNamePossibleTypesService.class)
    @CustomXmlElementBinding(impl=TextAndElementBinding.class)
    @Label(standard="socket provider")
    @Since(value="12.1.2")
    @XmlElementBinding(path="socket-provider", mappings={@XmlElementBinding.Mapping(element="$$ANY", type=ISocketProviderCacheConfigName.class), @XmlElementBinding.Mapping(element="system", type=ISocketProviderSystem.class), @XmlElementBinding.Mapping(element="ssl", type=ISocketProviderSsl.class), @XmlElementBinding.Mapping(element="tcp", type=ISocketProviderTcp.class), @XmlElementBinding.Mapping(element="sdp", type=ISocketProviderSdp.class), @XmlElementBinding.Mapping(element="instance", type=ISocketProviderInstance.class)})
    public static final ElementProperty PROP_SOCKET_PROVIDER = new ElementProperty(TYPE, "SocketProvider");
    @Type(base=AuthMethod.class)
    @XmlBinding(path="auth-method")
    @Label(standard="authentication mechanism")
    @DefaultValue(text="none")
    @Since(value="12.1.2")
    @Documentation(content="Configures the authentication mechanism for the HTTP server. As a prerequisite to gaining access to any resources exposed by the server, a client must have authenticated using the configured mechanism.[pbr/]Legal values are: [ul][li]basic: This method requires the client to be authenticated using HTTP basic authentication.[/li][li]cert: This method requires the client to be authenticated using client-side SSL certificate-based authentication. The certificate must be passed to the server to authenticate. Additionally, this method requires an SSL-based socket provider to be configured for the HTTP server.[/li][li]cert+basic: This method requires the client to be authenticated using both client-side SSL certificate and HTTP basic authentication.[/li][li]none: This method does not require the client to be authenticated.[/li][/ul]")
    public static final ValueProperty PROP_AUTH_METHOD = new ValueProperty(TYPE, "AuthMethod");

    public ILocalAddress getLocalAddress();

    public ElementHandle<IResourceConfig> getResourceConfig();

    public ElementHandle<IModelElementBase> getSocketProvider();

    public Value<AuthMethod> getAuthMethod();

    public void setAuthMethod(String var1);

    public void setAuthMethod(AuthMethod var1);
}

