/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.cacheConfig;

import java.math.BigDecimal;
import oracle.eclipse.tools.coherence.descriptors.IModelElementBase;
import oracle.eclipse.tools.coherence.descriptors.SizeUnit;
import oracle.eclipse.tools.coherence.descriptors.TimeUnit;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IAsyncStoreManager;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IBdbFileManager;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ICachingScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IClassInitParam;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ICustomStoreManager;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ILhFileManager;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IListener;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.INioFileManager;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.INioMemoryManager;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IStoreManagerBase;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IUnitCalculatorBinary;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IUnitCalculatorClassScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IUnitCalculatorFixed;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.NumberWithUnitPropertyCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.ParamTypeCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.SchemeRefDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.internal.NumberUnitEnabler;
import oracle.eclipse.tools.coherence.descriptors.internal.TextAndElementBinding;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeConstraintBehavior;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlElementBinding;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlElementBinding;

@Label(standard="external scheme")
public interface IExternalScheme
extends ICachingScheme,
IClassInitParam {
    public static final ElementType TYPE = new ElementType(IExternalScheme.class);
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS}, type={"com.tangosol.net.cache.SerializationCache", "com.tangosol.net.cache.SerializationMap", "com.tangosol.net.cache.SimpleSerializationMap"}, behavior=JavaTypeConstraintBehavior.AT_LEAST_ONE)
    @Documentation(content="Specifies a custom implementation of the external cache. Any custom implementation must extend either of the following classes:[pbr/][ul][li]com.tangosol.net.cache.SerializationCache \u2014 for size limited caches[/li][li]com.tangosol.net.cache.SerializationMap \u2014 for unlimited size caches[/li][li]com.tangosol.net.cache.SimpleSerializationMap \u2014 for unlimited size caches[/li][/ul]")
    public static final ValueProperty PROP_CLASS_NAME = new ValueProperty(TYPE, IClassInitParam.PROP_CLASS_NAME);
    @Type(base=IStoreManagerBase.class, possible={IAsyncStoreManager.class, IBdbFileManager.class, ICustomStoreManager.class, ILhFileManager.class, INioFileManager.class, INioMemoryManager.class})
    @XmlElementBinding(path="", mappings={@XmlElementBinding.Mapping(element="async-store-manager", type=IAsyncStoreManager.class), @XmlElementBinding.Mapping(element="bdb-store-manager", type=IBdbFileManager.class), @XmlElementBinding.Mapping(element="custom-store-manager", type=ICustomStoreManager.class), @XmlElementBinding.Mapping(element="lh-file-manager", type=ILhFileManager.class), @XmlElementBinding.Mapping(element="nio-file-manager", type=INioFileManager.class), @XmlElementBinding.Mapping(element="nio-memory-manager", type=INioMemoryManager.class)})
    @Label(standard="pluggable store manager")
    @Documentation(content="Supported store managers include:[ul][li]async-store-manager\u2014 a wrapper providing asynchronous write capabilities for of other store manager implementations[/li][li]custom-store-manager\u2014 allows definition of custom implementations of store managers[/li][li]bdb-store-manager\u2014 uses Berkeley Database JE to implement an on disk cache[/li][li]lh-file-manager\u2014 uses a Coherence LH on disk database cache[/li][li]nio-file-manager\u2014 uses NIO to implement memory-mapped file based cache[/li][li]nio-memory-manager\u2014 uses NIO to implement an off JVM heap, in-memory cache[/li][/ul]")
    public static final ElementProperty PROP_STORE_MANAGER = new ElementProperty(TYPE, "StoreManager");
    @Type(base=Integer.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"high-units", "true"})
    @Label(standard="high units")
    @NumericRange(min="0")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value=""), @Service.Param(name="default", value="true"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IExternalScheme]/HighUnits")})
    @DefaultValue(text="0")
    @Documentation(content="Used to limit the size of the cache. Contains the maximum number of units that can be placed in the cache before pruning occurs. An entry is the unit of measurement, unless it is overridden by an alternate unit-calculator (see <unit-calculator> subelement). When this limit is exceeded, the cache begins the pruning process, evicting entries according to the eviction policy. Zero implies no limit.")
    public static final ValueProperty PROP_HIGH_UNITS = new ValueProperty(TYPE, "HighUnits");
    @Type(base=SizeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"high-units", "false"})
    @Services(value={@Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value=""), @Service.Param(name="default", value="false"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IExternalScheme]/HighUnitsUnit")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="HighUnits")})})
    public static final ValueProperty PROP_HIGH_UNITS_UNIT = new ValueProperty(TYPE, "HighUnitsUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"high-units", "true", "true"})
    public static final ValueProperty PROP_HIGH_UNITS_PARAM = new ValueProperty(TYPE, "HighUnitsParam");
    @Type(base=IModelElementBase.class, possible={IUnitCalculatorFixed.class, IUnitCalculatorBinary.class, IUnitCalculatorClassScheme.class})
    @CustomXmlElementBinding(impl=TextAndElementBinding.class)
    @Label(standard="unit calculator")
    @XmlElementBinding(path="unit-calculator", mappings={@XmlElementBinding.Mapping(element="$$fixed", type=IUnitCalculatorFixed.class), @XmlElementBinding.Mapping(element="$$binary", type=IUnitCalculatorBinary.class), @XmlElementBinding.Mapping(element="class-scheme", type=IUnitCalculatorClassScheme.class)})
    public static final ElementProperty PROP_UNIT_CALCULATOR = new ElementProperty(TYPE, "UnitCalculator");
    @Type(base=Integer.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"unit-factor"})
    @Label(standard="unit factor")
    @NumericRange(min="1")
    @DefaultValue(text="1")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="dependsOn", value="/CachingSchemes[#type=IExternalScheme]/UnitFactor")})
    @Documentation(content="Specifies the factor by which the units, low-units and high-units properties are adjusted. Using a BINARY unit calculator, for example, the factor of 1048576 could be used to count megabytes instead of bytes.")
    public static final ValueProperty PROP_UNIT_FACTOR = new ValueProperty(TYPE, "UnitFactor");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"unit-factor", "true"})
    public static final ValueProperty PROP_UNIT_FACTOR_PARAM = new ValueProperty(TYPE, "UnitFactorParam");
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"expiry-delay", "true"})
    @Label(standard="expiry delay")
    @DefaultValue(text="0")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="default", value="true"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IExternalScheme]/ExpiryDelay")})
    @NumericRange(min="0")
    @Documentation(content="Specifies the amount of time from last update that entries will be kept by the cache before being discarded.")
    public static final ValueProperty PROP_EXPIRY_DELAY = new ValueProperty(TYPE, "ExpiryDelay");
    @Type(base=TimeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"expiry-delay", "false"})
    @DefaultValue(text="s")
    @Services(value={@Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="default", value="false"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IExternalScheme]/ExpiryDelayUnit")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="ExpiryDelay")})})
    public static final ValueProperty PROP_EXPIRY_DELAY_UNIT = new ValueProperty(TYPE, "ExpiryDelayUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"expiry-delay", "true", "true"})
    public static final ValueProperty PROP_EXPIRY_DELAY_PARAM = new ValueProperty(TYPE, "ExpiryDelayParam");
    @Type(base=IListener.class)
    @XmlBinding(path="listener/class-scheme")
    public static final ImpliedElementProperty PROP_LISTENER = new ImpliedElementProperty(TYPE, "Listener");

    public ElementHandle<IStoreManagerBase> getStoreManager();

    public Value<Integer> getHighUnits();

    public void setHighUnits(String var1);

    public void setHighUnits(Integer var1);

    public Value<SizeUnit> getHighUnitsUnit();

    public void setHighUnitsUnit(String var1);

    public void setHighUnitsUnit(SizeUnit var1);

    public Value<String> getHighUnitsParam();

    public void setHighUnitsParam(String var1);

    public ElementHandle<IModelElementBase> getUnitCalculator();

    public Value<Integer> getUnitFactor();

    public void setUnitFactor(String var1);

    public void setUnitFactor(Integer var1);

    public Value<String> getUnitFactorParam();

    public void setUnitFactorParam(String var1);

    public Value<BigDecimal> getExpiryDelay();

    public void setExpiryDelay(String var1);

    public void setExpiryDelay(BigDecimal var1);

    public Value<TimeUnit> getExpiryDelayUnit();

    public void setExpiryDelayUnit(String var1);

    public void setExpiryDelayUnit(TimeUnit var1);

    public Value<String> getExpiryDelayParam();

    public void setExpiryDelayParam(String var1);

    public IListener getListener();
}

