/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.cacheConfig;

import java.math.BigDecimal;
import oracle.eclipse.tools.coherence.descriptors.IModelElementBase;
import oracle.eclipse.tools.coherence.descriptors.IServiceFailurePolicyExitCluster;
import oracle.eclipse.tools.coherence.descriptors.IServiceFailurePolicyExitProcess;
import oracle.eclipse.tools.coherence.descriptors.IServiceFailurePolicyInstance;
import oracle.eclipse.tools.coherence.descriptors.IServiceFailurePolicyLogging;
import oracle.eclipse.tools.coherence.descriptors.LeaseGranularity;
import oracle.eclipse.tools.coherence.descriptors.TimeUnit;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IBackingMapScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IBackupStorage;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ICachingScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ICompressorInstance;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ICompressorStandard;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IInterceptor;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IKeyAssociator;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IKeyPartitioning;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IListener;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IMemberListener;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IOperationBundling;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IPartitionAssighmentStrategyInstance;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IPartitionAssighmentStrategyLegacy;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IPartitionAssighmentStrategyMirror;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IPartitionAssighmentStrategySimple;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IPartitionListener;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IPartitionedQuorumPolicyScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ISerializer35;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ISerializerInstance;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ISerializerName;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.NumberWithUnitPropertyCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.OverrideValuesProvider;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.ParamTypeCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.PartitionAssignmentStrategyPossibleTypesService;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.SchemeRefDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.internal.NumberUnitEnabler;
import oracle.eclipse.tools.coherence.descriptors.internal.PrimeNumberValidator;
import oracle.eclipse.tools.coherence.descriptors.internal.TextAndElementBinding;
import oracle.eclipse.tools.coherence.descriptors.override.ReliableTransport;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Validation;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.VersionCompatibility;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Fact;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlElementBinding;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlElementBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;

public interface IDistributedScheme
extends ICachingScheme,
IBackupStorage {
    public static final ElementType TYPE = new ElementType(IDistributedScheme.class);
    @XmlBinding(path="service-name")
    @Label(standard="service")
    @Service(impl=OverrideValuesProvider.class, params={@Service.Param(name="parentPath", value="cluster-config/services"), @Service.Param(name="attributePath", value="id"), @Service.Param(name="valuePath", value="service-type"), @Service.Param(name="severity", value="ok")})
    @Documentation(content="Specifies the service name configuration info.")
    public static final ValueProperty PROP_SERVICE_NAME = new ValueProperty(TYPE, "ServiceName");
    @Type(base=ISerializer35.class)
    @XmlBinding(path="serializer")
    @Documentation(content="Specifies the class configuration info for a com.tangosol.io.Serializer implementation.")
    @VersionCompatibility(value="3.5]")
    public static final ImpliedElementProperty PROP_SERIALIZER35 = new ImpliedElementProperty(TYPE, "Serializer35");
    @Type(base=IModelElementBase.class, possible={ISerializerName.class, ISerializerInstance.class})
    @CustomXmlElementBinding(impl=TextAndElementBinding.class)
    @Since(value="3.6")
    @Label(standard="serializer")
    @XmlElementBinding(path="serializer", mappings={@XmlElementBinding.Mapping(element="$$ANY", type=ISerializerName.class), @XmlElementBinding.Mapping(element="instance", type=ISerializerInstance.class)})
    public static final ElementProperty PROP_SERIALIZER = new ElementProperty(TYPE, "Serializer");
    @Type(base=IModelElementBase.class, possible={ICompressorStandard.class, ICompressorInstance.class})
    @CustomXmlElementBinding(impl=TextAndElementBinding.class)
    @Since(value="3.7.1")
    @Label(standard="compressor")
    @XmlElementBinding(path="compressor", mappings={@XmlElementBinding.Mapping(element="$$standard", type=ICompressorStandard.class), @XmlElementBinding.Mapping(element="instance", type=ICompressorInstance.class)})
    public static final ElementProperty PROP_COMPRESSOR = new ElementProperty(TYPE, "Compressor");
    @Type(base=Integer.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"thread-count"})
    @Label(standard="thread count")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(3)/init-params/init-param(8)/param-value"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IDistributedScheme]/ThreadCount")})
    @Documentation(content="Specifies the number of daemon threads. If zero, all relevant tasks are performed on the service thread.If negative, tasks are performed on the caller's thread where possible.")
    public static final ValueProperty PROP_THREAD_COUNT = new ValueProperty(TYPE, "ThreadCount");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"thread-count", "true"})
    public static final ValueProperty PROP_THREAD_COUNT_PARAM = new ValueProperty(TYPE, "ThreadCountParam");
    @Type(base=Integer.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"standard-lease-milliseconds"})
    @Label(standard="standard lease (ms)")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(3)/init-params/init-param(1)/param-value"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IDistributedScheme]/StandardLease")})
    @Documentation(content="Specifies the duration of the standard lease in milliseconds. When a lease has aged past this number of milliseconds, the lock is automatically released. Set this value to zero to specify a lease that never expires. The purpose of this setting is to avoid deadlocks or blocks caused by stuck threads; the value should be set higher than the longest expected lock duration (for example, higher than a transaction timeout). It's also recommended to set this value higher than packet-delivery/timeout-milliseconds value. ")
    @VersionCompatibility(value="3.5]")
    public static final ValueProperty PROP_STANDARD_LEASE = new ValueProperty(TYPE, "StandardLease");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"standard-lease-milliseconds", "true"})
    public static final ValueProperty PROP_STANDARD_LEASE_PARAM = new ValueProperty(TYPE, "StandardLeaseParam");
    @Type(base=LeaseGranularity.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"lease-granularity"})
    @Label(standard="lease granularity")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(3)/init-params/init-param(2)/param-value"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IDistributedScheme]/LeaseGranularity")})
    @Documentation(content="Specifies the lease ownership granularity.[pbr/]Legal values are: [ul][li]thread: locks are held by a thread that obtained them and can only be released by that thread.[/li][li]member: locks are held by a cluster node and any thread running on the cluster node that obtained the lock can release it.[/li][/ul]")
    public static final ValueProperty PROP_LEASE_GRANULARITY = new ValueProperty(TYPE, "LeaseGranularity");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"lease-granularity", "true"})
    public static final ValueProperty PROP_LEASE_GRANULARITY_PARAM = new ValueProperty(TYPE, "LeaseGranularityParam");
    @Type(base=Boolean.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"local-storage"})
    @Label(standard="local storage")
    @DefaultValue(text="true")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(3)/init-params/init-param(4)/param-value"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IDistributedScheme]/LocalStorage")})
    @Documentation(content="Specifies whether or not this member will store a portion of the data managed by the partitioned (distributed) cache service.[pbr/]A value of false means that the cluster member will not store any of the data locally. A value of true means that the cluster member will store its fair share of the data.")
    public static final ValueProperty PROP_LOCAL_STORAGE = new ValueProperty(TYPE, "LocalStorage");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"local-storage", "true"})
    public static final ValueProperty PROP_LOCAL_STORAGE_PARAM = new ValueProperty(TYPE, "LocalStorageParam");
    @Type(base=Integer.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"partition-count"})
    @Label(standard="partition count")
    @NumericRange(min="0")
    @Services(value={@Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(3)/init-params/init-param(3)/param-value"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IDistributedScheme]/PartitionCount")}), @Service(impl=PrimeNumberValidator.class)})
    @Documentation(content="Specifies the number of partitions that a partitioned (distributed) cache will be \"chopped up\" into. Each member running the partitioned cache service that has the local-storage option set to true will manage a \"fair\" (balanced) number of partitions.[pbr/]The number of partitions should be a prime number and sufficiently large such that a given partition is expected to be no larger than 50MB in size.[pbr/]Good defaults for example service storage sizes are provided below: [pbr/][code]service storage   parition-count[br/]100M                   257[br/]1G                        509[br/]10G                      2039[br/]50G                      4093[br/]100G                    8191[/code]")
    public static final ValueProperty PROP_PARTITION_COUNT = new ValueProperty(TYPE, "PartitionCount");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"partition-count", "true"})
    public static final ValueProperty PROP_PARTITION_COUNT_PARAM = new ValueProperty(TYPE, "PartitionCountParam");
    @Type(base=Integer.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"transfer-threshold"})
    @Label(standard="transfer threshold")
    @NumericRange(min="1")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(3)/init-params/init-param(5)/param-value"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IDistributedScheme]/TransferThreshold")})
    @Documentation(content="Specifies the threshold for the primary buckets distribution in kilo-bytes. When a new node joins the distributed cache service or when a member of the service leaves, the remaining nodes perform a task of bucket ownership re-destribution. During this process, the existing data gets re-balanced along with the ownership information. This parameter indicates a preferred message size for data transfer communications. Setting this value lower will make the distribution process take longer, but will reduce network bandwidth utilization during this activity.")
    public static final ValueProperty PROP_TRANSFER_THRESHOLD = new ValueProperty(TYPE, "TransferThreshold");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"transfer-threshold", "true"})
    public static final ValueProperty PROP_TRANSFER_THRESHOLD_PARAM = new ValueProperty(TYPE, "TransferThresholdParam");
    @Type(base=Integer.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"backup-count"})
    @Label(standard="backup count")
    @NumericRange(min="0", max="256")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(3)/init-params/init-param(6)/param-value"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IDistributedScheme]/BackupCount")})
    @Documentation(content="Specifies the number of members of the DistributedCache service that hold the backup data for each unit of storage in the cache.[pbr/]Value of 0 means that in the case of abnormal termination, some portion of the data in the cache will be lost. Value of N means that if up to N cluster nodes terminate at once, the cache data will be preserved.[pbr/]To maintain the distributed cache of size M, the total memory usage in the cluster does not depend on the number of cluster nodes and will be in the order of M*(N+1).[pbr/]Recommended values are 0, 1 or 2.")
    public static final ValueProperty PROP_BACKUP_COUNT = new ValueProperty(TYPE, "BackupCount");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"backup-count", "true"})
    public static final ValueProperty PROP_BACKUP_COUNT_PARAM = new ValueProperty(TYPE, "BackupCountParam");
    @Type(base=Integer.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"backup-count-after-writebehind"})
    @Label(standard="backup count after writebehind")
    @NumericRange(min="0")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(3)/init-params/init-param(16)/param-value"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IDistributedScheme]/BackupCountAfterWritebehind")})
    @Validation(rule="${ Empty( BackupCountAfterWritebehind ) || BackupCountAfterWritebehind <= BackupCount }", message="Must be less than or equal to backup count.")
    @Fact(statement="Must be less than or equal to backup count.")
    @Documentation(content="Specifies the number of members of the partitioned cache service that holds the backup data for each unit of storage in the cache that does not require write-behind, that is, data that is not vulnerable to being lost even if the entire cluster were shut down. Specifically, if a unit of storage is marked as requiring write-behind, then it is backed up on the number of members specified by the <backup-count> subelement, and if the unit of storage is not marked as requiring write-behind, then it is backed up by the number of members specified by the <backup-count-after-writebehind> element.[pbr/]This value should be set to 0 or this setting should not be specified at all. The rationale is that since this data is being backed up to another data store, no in-memory backup is required, other than the data temporarily queued on the write-behind queue to be written. The value of 0 means that when write-behind has occurred, the backup copies of that data is discarded. However, until write-behind occurs, the data is backed up in accordance with the <backup-count> setting.")
    public static final ValueProperty PROP_BACKUP_COUNT_AFTER_WRITEBEHIND = new ValueProperty(TYPE, "BackupCountAfterWritebehind");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"backup-count-after-writebehind", "true"})
    public static final ValueProperty PROP_BACKUP_COUNT_AFTER_WRITEBEHIND_PARAM = new ValueProperty(TYPE, "BackupCountAfterWritebehindParam");
    @Type(base=IKeyAssociator.class)
    @XmlBinding(path="key-associator")
    public static final ElementProperty PROP_KEY_ASSOCIATOR = new ElementProperty(TYPE, "KeyAssociator");
    @Type(base=IKeyPartitioning.class)
    @XmlBinding(path="key-partitioning")
    public static final ElementProperty PROP_KEY_PARTITIONING = new ElementProperty(TYPE, "KeyPartitioning");
    @Type(base=IModelElementBase.class)
    @Service(impl=PartitionAssignmentStrategyPossibleTypesService.class)
    @CustomXmlElementBinding(impl=TextAndElementBinding.class)
    @Since(value="3.7")
    @Label(standard="partition assignment strategy")
    @XmlElementBinding(path="partition-assignment-strategy", mappings={@XmlElementBinding.Mapping(element="$$legacy", type=IPartitionAssighmentStrategyLegacy.class), @XmlElementBinding.Mapping(element="$$simple", type=IPartitionAssighmentStrategySimple.class), @XmlElementBinding.Mapping(element="$$mirror:AssociatedServiceName", type=IPartitionAssighmentStrategyMirror.class), @XmlElementBinding.Mapping(element="instance", type=IPartitionAssighmentStrategyInstance.class)})
    public static final ElementProperty PROP_PARTITION_ASSIGNMENT_STRATEGY = new ElementProperty(TYPE, "PartitionAssignmentStrategy");
    @Type(base=IPartitionListener.class)
    @XmlBinding(path="partition-listener")
    public static final ElementProperty PROP_PARTITION_LISTENER = new ElementProperty(TYPE, "PartitionListener");
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"task-hung-threshold", "true"})
    @Label(standard="task hung threshold")
    @NumericRange(min="0")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(3)/init-params/init-param(12)/param-value"), @Service.Param(name="default", value="true"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IDistributedScheme]/TaskHungThreshold")})
    @Enablement(expr="${ThreadCount > 0}")
    @Documentation(content="Specifies the amount of time that a request can execute on a service worker thread before it is considered as \"hung\".")
    public static final ValueProperty PROP_TASK_HUNG_THRESHOLD = new ValueProperty(TYPE, "TaskHungThreshold");
    @Type(base=TimeUnit.class)
    @DefaultValue(text="ms")
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"task-hung-threshold", "false"})
    @Services(value={@Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(3)/init-params/init-param(12)/param-value"), @Service.Param(name="default", value="false"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IDistributedScheme]/TaskHungThresholdUnit")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="TaskHungThreshold")})})
    @Enablement(expr="${ThreadCount > 0}")
    @Since(value="3.7.1")
    public static final ValueProperty PROP_TASK_HUNG_THRESHOLD_UNIT = new ValueProperty(TYPE, "TaskHungThresholdUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"task-hung-threshold", "true", "true"})
    public static final ValueProperty PROP_TASK_HUNG_THRESHOLD_PARAM = new ValueProperty(TYPE, "TaskHungThresholdParam");
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"task-timeout", "true"})
    @Label(standard="task timeout")
    @NumericRange(min="0")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(3)/init-params/init-param(13)/param-value"), @Service.Param(name="default", value="true"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IDistributedScheme]/TaskTimeout")})
    @Enablement(expr="${ThreadCount > 0}")
    @Documentation(content="Specifies the timeout value for requests executing on the service worker threads.")
    public static final ValueProperty PROP_TASK_TIMEOUT = new ValueProperty(TYPE, "TaskTimeout");
    @Type(base=TimeUnit.class)
    @DefaultValue(text="ms")
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"task-timeout", "false"})
    @Services(value={@Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(3)/init-params/init-param(13)/param-value"), @Service.Param(name="default", value="false"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IDistributedScheme]/TaskTimeout")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="TaskTimeout")})})
    @Enablement(expr="${ThreadCount > 0}")
    @Since(value="3.7.1")
    public static final ValueProperty PROP_TASK_TIMEOUT_UNIT = new ValueProperty(TYPE, "TaskTimeoutUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"task-timeout", "true", "true"})
    public static final ValueProperty PROP_TASK_TIMEOUT_PARAM = new ValueProperty(TYPE, "TaskTimeoutParam");
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"request-timeout", "true"})
    @Label(standard="request timeout")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(3)/init-params/init-param(14)/param-value"), @Service.Param(name="default", value="true"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IDistributedScheme]/RequestTimeout")})
    @NumericRange(min="0")
    @Documentation(content="Specifies the maximum amount of time a client waits for a response before abandoning the original request. The request time is measured on the client side as the time elapsed from the moment a request is sent for execution to the corresponding server node(s) and includes the following:[ul][li]the time it takes to deliver the request to an executing node (server) [/li][li]the interval between the time the task is received and placed into a service queue until the execution starts [/li][li]the task execution time [/li][li]the time it takes to deliver a result back to the client [/li][/ul]")
    public static final ValueProperty PROP_REQUEST_TIMEOUT = new ValueProperty(TYPE, "RequestTimeout");
    @Type(base=TimeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"request-timeout", "false"})
    @DefaultValue(text="ms")
    @Services(value={@Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(3)/init-params/init-param(14)/param-value"), @Service.Param(name="default", value="false"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IDistributedScheme]/RequestTimeoutUnit")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="RequestTimeout")})})
    public static final ValueProperty PROP_REQUEST_TIMEOUT_UNIT = new ValueProperty(TYPE, "RequestTimeoutUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"request-timeout", "true", "true"})
    public static final ValueProperty PROP_REQUEST_TIMEOUT_PARAM = new ValueProperty(TYPE, "RequestTimeoutParam");
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"guardian-timeout", "true"})
    @Label(standard="guardian timeout")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/service-guardian/timeout-milliseconds"), @Service.Param(name="default", value="true"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IDistributedScheme]/GuardianTimeout")})
    @NumericRange(min="0")
    @Documentation(content="Specifies the the guardian timeout value to use for guarding the service and any dependant threads.")
    public static final ValueProperty PROP_GUARDIAN_TIMEOUT = new ValueProperty(TYPE, "GuardianTimeout");
    @Type(base=TimeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"guardian-timeout", "false"})
    @DefaultValue(text="ms")
    @Services(value={@Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/service-guardian/timeout-milliseconds"), @Service.Param(name="default", value="false"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IDistributedScheme]/GuardianTimeoutUnit")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="GuardianTimeout")})})
    public static final ValueProperty PROP_GUARDIAN_TIMEOUT_UNIT = new ValueProperty(TYPE, "GuardianTimeoutUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"guardian-timeout", "true", "true"})
    public static final ValueProperty PROP_GUARDIAN_TIMEOUT_PARAM = new ValueProperty(TYPE, "GuardianTimeoutParam");
    @Type(base=IModelElementBase.class, possible={IServiceFailurePolicyExitProcess.class, IServiceFailurePolicyExitCluster.class, IServiceFailurePolicyLogging.class, IServiceFailurePolicyInstance.class})
    @CustomXmlElementBinding(impl=TextAndElementBinding.class)
    @Since(value="3.6")
    @Label(standard="service failure policy")
    @XmlElementBinding(path="service-failure-policy", mappings={@XmlElementBinding.Mapping(element="$$exit-process", type=IServiceFailurePolicyExitProcess.class), @XmlElementBinding.Mapping(element="$$exit-cluster", type=IServiceFailurePolicyExitCluster.class), @XmlElementBinding.Mapping(element="$$logging", type=IServiceFailurePolicyLogging.class), @XmlElementBinding.Mapping(element="instance", type=IServiceFailurePolicyInstance.class)})
    public static final ElementProperty PROP_SERVICE_FAILURE_POLICY = new ElementProperty(TYPE, "ServiceFailurePolicy");
    @Type(base=IMemberListener.class)
    @XmlBinding(path="member-listener")
    @Since(value="3.6")
    public static final ElementProperty PROP_MEMBER_LISTENER = new ElementProperty(TYPE, "MemberListener");
    @Type(base=IOperationBundling.class)
    @XmlBinding(path="operation-bundling")
    @Label(standard="operation bundling")
    public static final ElementProperty PROP_OPERATION_BUNDLING = new ElementProperty(TYPE, "OperationBundling");
    @Type(base=IBackingMapScheme.class)
    @XmlBinding(path="backing-map-scheme")
    public static final ImpliedElementProperty PROP_BACKING_MAP_SCHEME = new ImpliedElementProperty(TYPE, "BackingMapScheme");
    @Type(base=IPartitionedQuorumPolicyScheme.class)
    @XmlBinding(path="partitioned-quorum-policy-scheme")
    @Since(value="3.6")
    public static final ElementProperty PROP_PARTITIONED_QUORUM_POLICY_SCHEME = new ElementProperty(TYPE, "PartitionedQuorumPolicyScheme");
    @Type(base=IListener.class)
    @XmlBinding(path="listener/class-scheme")
    public static final ImpliedElementProperty PROP_LISTENER = new ImpliedElementProperty(TYPE, "Listener");
    @Type(base=Boolean.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"autostart"})
    @Label(standard="autostart")
    @DefaultValue(text="false")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="dependsOn", value="/CachingSchemes[#type=IDistributedScheme]/Autostart")})
    @Documentation(content="Specifies whether or not the cache services associated with the cache scheme should be automatically started at a cluster node.")
    public static final ValueProperty PROP_AUTOSTART = new ValueProperty(TYPE, "Autostart");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"autostart", "true"})
    public static final ValueProperty PROP_AUTOSTART_PARAM = new ValueProperty(TYPE, "AutostartParam");
    @Type(base=Integer.class)
    @Label(standard="service priority")
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"service-priority"})
    @NumericRange(min="1", max="10")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(3)/init-params/init-param(23)/param-value"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IDistributedScheme]/ServicePriority")})
    @Since(value="12.1.2")
    @Documentation(content="specifies the priority for the service thread.")
    public static final ValueProperty PROP_SERVICE_PRIORITY = new ValueProperty(TYPE, "ServicePriority");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"service-priority", "true"})
    public static final ValueProperty PROP_SERVICE_PRIORITY_PARAM = new ValueProperty(TYPE, "ServicePriorityParam");
    @Type(base=Integer.class)
    @Label(standard="event dispatcher priority")
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"event-dispatcher-priority"})
    @NumericRange(min="1", max="10")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(3)/init-params/init-param(24)/param-value"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IDistributedScheme]/EventDispatcherPriority")})
    @Since(value="12.1.2")
    @Documentation(content="specifies the priority for the event dispatcher thread for each service.")
    public static final ValueProperty PROP_EVENT_DISPATCHER_PRIORITY = new ValueProperty(TYPE, "EventDispatcherPriority");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"event-dispatcher-priority", "true"})
    public static final ValueProperty PROP_EVENT_DISPATCHER_PRIORITY_PARAM = new ValueProperty(TYPE, "EventDispatcherPriorityParam");
    @Type(base=ReliableTransport.class)
    @Label(standard="reliable transport")
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"reliable-transport"})
    @DefaultValue(text="datagram")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/unicast-listener/reliable-transport"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IDistributedScheme]/ReliableTransport")})
    @Since(value="12.1.2")
    @Documentation(content="Contains the name of the transport used by the TCMP for reliable point-to-point communications.")
    public static final ValueProperty PROP_RELIABLE_TRANSPORT = new ValueProperty(TYPE, "ReliableTransport");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"reliable-transport", "true"})
    public static final ValueProperty PROP_RELIABLE_TRANSPORT_PARAM = new ValueProperty(TYPE, "ReliableTransportParam");
    @Type(base=Integer.class)
    @Label(standard="worker priority")
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"worker-priority"})
    @NumericRange(min="1", max="10")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(3)/init-params/init-param(25)/param-value"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IDistributedScheme]/WorkerPriority")})
    @Since(value="12.1.2")
    @Documentation(content="specifies the priority for the worker threads.")
    public static final ValueProperty PROP_WORKER_PRIORITY = new ValueProperty(TYPE, "WorkerPriority");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"worker-priority", "true"})
    public static final ValueProperty PROP_WORKER_PRIORITY_PARAM = new ValueProperty(TYPE, "WorkerPriorityParam");
    @Type(base=IInterceptor.class)
    @XmlListBinding(path="interceptors", mappings={@XmlListBinding.Mapping(element="interceptor", type=IInterceptor.class)})
    @Since(value="12.1.2")
    @Label(standard="interceptors")
    public static final ListProperty PROP_INTERCEPTORS = new ListProperty(TYPE, "Interceptors");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"scope-name"})
    @Label(standard="scope")
    @Since(value="12.1.2")
    @Documentation(content="The scope-name element contains the scope name for this configuration. The scope name is typically added to the service name (as a prefix) for all services generated by a cache factory.  Scope may be used to isolate services indicated in this cache configuration from services created by cache factories with other configurations, thus avoiding unintended joining of services with similar names from different configurations.")
    public static final ValueProperty PROP_SCOPE_NAME = new ValueProperty(TYPE, "ScopeName");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"scope-name", "true"})
    public static final ValueProperty PROP_SCOPE_NAME_PARAM = new ValueProperty(TYPE, "ScopeNameParam");
    @Type(base=Boolean.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"async-backup"})
    @Label(standard="backup asynchronously")
    @DefaultValue(text="false")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="dependsOn", value="/CachingSchemes[#type=IDistributedScheme]/AsyncBackup")})
    @Since(value="12.1.2")
    @Documentation(content="Specifies if the partitioned (distributed) cache service should backup changes asynchronously while concurrently responding to the client.")
    public static final ValueProperty PROP_ASYNC_BACKUP = new ValueProperty(TYPE, "AsyncBackup");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"async-backup", "true"})
    public static final ValueProperty PROP_ASYNC_BACKUP_PARAM = new ValueProperty(TYPE, "AsyncBackupParam");

    public Value<String> getServiceName();

    public void setServiceName(String var1);

    public ISerializer35 getSerializer35();

    public ElementHandle<IModelElementBase> getSerializer();

    public ElementHandle<IModelElementBase> getCompressor();

    public Value<Integer> getThreadCount();

    public void setThreadCount(String var1);

    public void setThreadCount(Integer var1);

    public Value<String> getThreadCountParam();

    public void setThreadCountParam(String var1);

    public Value<Integer> getStandardLease();

    public void setStandardLease(String var1);

    public void setStandardLease(Integer var1);

    public Value<String> getStandardLeaseParam();

    public void setStandardLeaseParam(String var1);

    public Value<LeaseGranularity> getLeaseGranularity();

    public void setLeaseGranularity(String var1);

    public void setLeaseGranularity(LeaseGranularity var1);

    public Value<String> getLeaseGranularityParam();

    public void setLeaseGranularityParam(String var1);

    public Value<Boolean> getLocalStorage();

    public void setLocalStorage(String var1);

    public void setLocalStorage(Boolean var1);

    public Value<String> getLocalStorageParam();

    public void setLocalStorageParam(String var1);

    public Value<Integer> getPartitionCount();

    public void setPartitionCount(String var1);

    public void setPartitionCount(Integer var1);

    public Value<String> getPartitionCountParam();

    public void setPartitionCountParam(String var1);

    public Value<Integer> getTransferThreshold();

    public void setTransferThreshold(String var1);

    public void setTransferThreshold(Integer var1);

    public Value<String> getTransferThresholdParam();

    public void setTransferThresholdParam(String var1);

    public Value<Integer> getBackupCount();

    public void setBackupCount(String var1);

    public void setBackupCount(Integer var1);

    public Value<String> getBackupCountParam();

    public void setBackupCountParam(String var1);

    public Value<Integer> getBackupCountAfterWritebehind();

    public void setBackupCountAfterWritebehind(String var1);

    public void setBackupCountAfterWritebehind(Integer var1);

    public Value<String> getBackupCountAfterWritebehindParam();

    public void setBackupCountAfterWritebehindParam(String var1);

    public ElementHandle<IKeyAssociator> getKeyAssociator();

    public ElementHandle<IKeyPartitioning> getKeyPartitioning();

    public ElementHandle<IModelElementBase> getPartitionAssignmentStrategy();

    public ElementHandle<IPartitionListener> getPartitionListener();

    public Value<BigDecimal> getTaskHungThreshold();

    public void setTaskHungThreshold(String var1);

    public void setTaskHungThreshold(BigDecimal var1);

    public Value<TimeUnit> getTaskHungThresholdUnit();

    public void setTaskHungThresholdUnit(String var1);

    public void setTaskHungThresholdUnit(TimeUnit var1);

    public Value<String> getTaskHungThresholdParam();

    public void setTaskHungThresholdParam(String var1);

    public Value<BigDecimal> getTaskTimeout();

    public void setTaskTimeout(String var1);

    public void setTaskTimeout(BigDecimal var1);

    public Value<TimeUnit> getTaskTimeoutUnit();

    public void setTaskTimeoutUnit(String var1);

    public void setTaskTimeoutUnit(TimeUnit var1);

    public Value<String> getTaskTimeoutParam();

    public void setTaskTimeoutParam(String var1);

    public Value<BigDecimal> getRequestTimeout();

    public void setRequestTimeout(String var1);

    public void setRequestTimeout(BigDecimal var1);

    public Value<TimeUnit> getRequestTimeoutUnit();

    public void setRequestTimeoutUnit(String var1);

    public void setRequestTimeoutUnit(TimeUnit var1);

    public Value<String> getRequestTimeoutParam();

    public void setRequestTimeoutParam(String var1);

    public Value<BigDecimal> getGuardianTimeout();

    public void setGuardianTimeout(String var1);

    public void setGuardianTimeout(BigDecimal var1);

    public Value<TimeUnit> getGuardianTimeoutUnit();

    public void setGuardianTimeoutUnit(String var1);

    public void setGuardianTimeoutUnit(TimeUnit var1);

    public Value<String> getGuardianTimeoutParam();

    public void setGuardianTimeoutParam(String var1);

    public ElementHandle<IModelElementBase> getServiceFailurePolicy();

    public ElementHandle<IMemberListener> getMemberListener();

    public ElementHandle<IOperationBundling> getOperationBundling();

    public IBackingMapScheme getBackingMapScheme();

    public ElementHandle<IPartitionedQuorumPolicyScheme> getPartitionedQuorumPolicyScheme();

    public IListener getListener();

    public Value<Boolean> getAutostart();

    public void setAutostart(String var1);

    public void setAutostart(Boolean var1);

    public Value<String> getAutostartParam();

    public void setAutostartParam(String var1);

    public Value<Integer> getServicePriority();

    public void setServicePriority(String var1);

    public void setServicePriority(Integer var1);

    public Value<String> getServicePriorityParam();

    public void setServicePriorityParam(String var1);

    public Value<Integer> getEventDispatcherPriority();

    public void setEventDispatcherPriority(String var1);

    public void setEventDispatcherPriority(Integer var1);

    public Value<String> getEventDispatcherPriorityParam();

    public void setEventDispatcherPriorityParam(String var1);

    public Value<ReliableTransport> getReliableTransport();

    public void setReliableTransport(String var1);

    public void setReliableTransport(ReliableTransport var1);

    public Value<String> getReliableTransportParam();

    public void setReliableTransportParam(String var1);

    public Value<Integer> getWorkerPriority();

    public void setWorkerPriority(String var1);

    public void setWorkerPriority(Integer var1);

    public Value<String> getWorkerPriorityParam();

    public void setWorkerPriorityParam(String var1);

    public ElementList<IInterceptor> getInterceptors();

    public Value<String> getScopeName();

    public void setScopeName(String var1);

    public Value<String> getScopeNameParam();

    public void setScopeNameParam(String var1);

    public Value<Boolean> getAsyncBackup();

    public void setAsyncBackup(String var1);

    public void setAsyncBackup(Boolean var1);

    public Value<String> getAsyncBackupParam();

    public void setAsyncBackupParam(String var1);
}

