/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.cacheConfig;

import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IClassInitParam;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.ParamTypeCustomBinding;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.DocumentationMergeStrategy;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;

public interface ICacheServiceProxy
extends IClassInitParam {
    public static final ElementType TYPE = new ElementType(ICacheServiceProxy.class);
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS}, type={"com.tangosol.net.CacheService"})
    @Since(value="3.6")
    @Documentation(content="Specifies the fully qualified name of a class that implements the com.tangosol.net.CacheService interface. The class acts as an interceptor between a client and a proxied cache service to implement custom processing as required. For example, the class could be used to perform authorization checks before allowing the use of the proxied cache service.")
    public static final ValueProperty PROP_CLASS_NAME = new ValueProperty(TYPE, IClassInitParam.PROP_CLASS_NAME);
    @Since(value="3.6")
    @Documentation(content="Contains initialization parameters for the CacheService implementation.", mergeStrategy=DocumentationMergeStrategy.REPLACE)
    public static final ListProperty PROP_INIT_PARAMS = new ListProperty(TYPE, IClassInitParam.PROP_INIT_PARAMS);
    @Type(base=Boolean.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"enabled"})
    @Label(standard="enabled")
    @DefaultValue(text="true")
    @Documentation(content="Specifies whether or not a proxy managed by the proxy service is enabled.")
    public static final ValueProperty PROP_ENABLED = new ValueProperty(TYPE, "Enabled");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"enabled", "true"})
    public static final ValueProperty PROP_ENABLED_PARAM = new ValueProperty(TYPE, "EnabledParam");
    @Type(base=Boolean.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"lock-enabled"})
    @Label(standard="lock enabled")
    @DefaultValue(text="false")
    @Documentation(content="Specifies whether or not lock requests from remote clients are permitted on a cache.")
    public static final ValueProperty PROP_LOCK_ENABLED = new ValueProperty(TYPE, "LockEnabled");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"lock-enabled", "true"})
    public static final ValueProperty PROP_LOCK_ENABLED_PARAM = new ValueProperty(TYPE, "LockEnabledParam");
    @Type(base=Boolean.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"read-only"})
    @Label(standard="read only")
    @DefaultValue(text="false")
    @Documentation(content="Specifies a readonly setting for the cachestore. If true the cache will only load data from cachestore for read operations and will not perform any writing to the cachestore when the cache is updated.")
    public static final ValueProperty PROP_READ_ONLY = new ValueProperty(TYPE, "ReadOnly");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"read-only", "true"})
    public static final ValueProperty PROP_READ_ONLY_PARAM = new ValueProperty(TYPE, "ReadOnlyParam");

    public Value<Boolean> getEnabled();

    public void setEnabled(String var1);

    public void setEnabled(Boolean var1);

    public Value<String> getEnabledParam();

    public void setEnabledParam(String var1);

    public Value<Boolean> getLockEnabled();

    public void setLockEnabled(String var1);

    public void setLockEnabled(Boolean var1);

    public Value<String> getLockEnabledParam();

    public void setLockEnabledParam(String var1);

    public Value<Boolean> getReadOnly();

    public void setReadOnly(String var1);

    public void setReadOnly(Boolean var1);

    public Value<String> getReadOnlyParam();

    public void setReadOnlyParam(String var1);
}

