/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.cacheConfig;

import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.OperationalNameValuesProvider;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.ParamTypeCustomBinding;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IBundleConfig
extends Element {
    public static final ElementType TYPE = new ElementType(IBundleConfig.class);
    @XmlBinding(path="operation-name")
    @Label(standard="operation name")
    @DefaultValue(text="all")
    @Service(impl=OperationalNameValuesProvider.class)
    @Documentation(content="Specifies the operation name for which calls performed concurrently on multiple threads are \"bundled\" into a functionally analogous \"bulk\" operation that takes a collection of arguments instead of a single one.[pbr/]Valid values depend on the bundle configuration context. For the <cachestore-scheme> the valid operations are:[ul][li]load[/li][li]store[/li][li]erase[/li][/ul][br/]For the <distributed-scheme> and <remote-cache-scheme> the valid operations are:[ul][li]get[/li][li]put[/li][li]remove[/li][/ul][br/]In all cases there is a pseudo operation named all, referring to all valid operations.")
    public static final ValueProperty PROP_OPERATION_NAME = new ValueProperty(TYPE, "OperationName");
    @Type(base=Integer.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"preferred-size"})
    @Label(standard="preferred size")
    @NumericRange(min="0")
    @DefaultValue(text="0")
    @Documentation(content="Specifies the bundle size threshold. When a bundle size reaches this value, the corresponding \"bulk\" operation will be invoked immediately. This value is measured in context-specific units.")
    public static final ValueProperty PROP_PREFERRED_SIZE = new ValueProperty(TYPE, "PreferredSize");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"preferred-size", "true"})
    public static final ValueProperty PROP_PREFERRED_SIZE_PARAM = new ValueProperty(TYPE, "PreferredSizeParam");
    @Type(base=Integer.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"delay-millis"})
    @Label(standard="delay (msec)")
    @NumericRange(min="1")
    @DefaultValue(text="1")
    @Documentation(content="Specifies the maximum amount of time in milliseconds that individual execution requests are allowed to be deferred for a purpose of \"bundling\" them together and passing into a corresponding bulk operation. If the preferred-size threshold is reached before the specified delay, the bundle is processed immediately.")
    public static final ValueProperty PROP_DELAY_MILLIS = new ValueProperty(TYPE, "DelayMillis");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"delay-millis", "true"})
    public static final ValueProperty PROP_DELAY_MILLIS_PARAM = new ValueProperty(TYPE, "DelayMillisParam");
    @Type(base=Integer.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"thread-threshold"})
    @Label(standard="thread threshold")
    @NumericRange(min="1")
    @DefaultValue(text="4")
    @Documentation(content="Specifies the minimum number of threads that must be concurrently executing individual (non-bundled) requests for the bundler to switch from a pass-through to a bundling mode.")
    public static final ValueProperty PROP_THREAD_THRESHOLD = new ValueProperty(TYPE, "ThreadThreshold");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"thread-threshold", "true"})
    public static final ValueProperty PROP_THREAD_THRESHOLD_PARAM = new ValueProperty(TYPE, "ThreadThresholdParam");
    @Type(base=Boolean.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"auto-adjust"})
    @Label(standard="auto adjust")
    @DefaultValue(text="false")
    @Documentation(content="Specifies whether or not the auto adjustment of the preferred-size value (based on the run-time statistics) is allowed.")
    public static final ValueProperty PROP_AUTO_ADJUST = new ValueProperty(TYPE, "AutoAdjust");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"auto-adjust", "true"})
    public static final ValueProperty PROP_AUTO_ADJUST_PARAM = new ValueProperty(TYPE, "AutoAdjustParam");

    public Value<String> getOperationName();

    public void setOperationName(String var1);

    public Value<Integer> getPreferredSize();

    public void setPreferredSize(String var1);

    public void setPreferredSize(Integer var1);

    public Value<String> getPreferredSizeParam();

    public void setPreferredSizeParam(String var1);

    public Value<Integer> getDelayMillis();

    public void setDelayMillis(String var1);

    public void setDelayMillis(Integer var1);

    public Value<String> getDelayMillisParam();

    public void setDelayMillisParam(String var1);

    public Value<Integer> getThreadThreshold();

    public void setThreadThreshold(String var1);

    public void setThreadThreshold(Integer var1);

    public Value<String> getThreadThresholdParam();

    public void setThreadThresholdParam(String var1);

    public Value<Boolean> getAutoAdjust();

    public void setAutoAdjust(String var1);

    public void setAutoAdjust(Boolean var1);

    public Value<String> getAutoAdjustParam();

    public void setAutoAdjustParam(String var1);
}

