/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.cacheConfig;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideDomUtil;
import oracle.eclipse.tools.coherence.internal.CoherenceURIResolverExtension;
import oracle.eclipse.tools.common.util.DomUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class CoherenceCacheConfigService {
    public static final String SYSTEM_PROPERTY = "system-property";
    static CoherenceCacheConfigService service = new CoherenceCacheConfigService();
    private Map<IProject, List<Element>> projectToDom = new HashMap<IProject, List<Element>>();
    private List<IPath> triggerFiles = new ArrayList<IPath>();
    private List<IPath> srcFiles;

    private CoherenceCacheConfigService() {
        this.triggerFiles.add((IPath)new Path(".settings/org.eclipse.wst.common.project.facet.core.xml"));
        this.triggerFiles.add((IPath)new Path(".settings/oracle.eclipse.tools.weblogic.syslib.xml"));
        this.triggerFiles.add((IPath)new Path(".settings/com.bea.workshop.wls.core.systemlibs.xml"));
        this.triggerFiles.add((IPath)new Path("oracle.eclipse.tools.coherence.lib.omw"));
        this.srcFiles = new ArrayList<IPath>();
    }

    private List<Element> getDomForProject(IProject project) {
        if (this.projectToDom.containsKey(project)) {
            return this.projectToDom.get(project);
        }
        ArrayList<Element> elements = new ArrayList<Element>(3);
        CoherenceURIResolverExtension resolver = new CoherenceURIResolverExtension();
        URI path = resolver.resolve(project, "tangosol-coherence.xml");
        Element jarElement = null;
        if (path != null) {
            try {
                Document doc = DomUtil.doc((InputStream)path.toURL().openStream());
                jarElement = doc.getDocumentElement();
                this.addListeners(project);
            }
            catch (MalformedURLException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.coherence", (Throwable)e);
            }
            catch (IOException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.coherence", (Throwable)e);
            }
        }
        elements.add(jarElement);
        IPath srcPath = null;
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            try {
                IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 3) {
                        srcPath = entry.getPath();
                        IPath filePath = srcPath.append("tangosol-coherence-override.xml");
                        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
                        if (file.exists()) {
                            this.srcFiles.add(filePath);
                            Document doc = DomUtil.doc((InputStream)file.getContents());
                            elements.add(doc.getDocumentElement());
                        }
                    }
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {
                LoggingService.logError((String)"oracle.eclipse.tools.coherence", (String)Resources.error);
            }
            catch (CoreException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.coherence", (CoreException)e);
            }
        }
        this.projectToDom.put(project, elements);
        return elements;
    }

    private void addListeners(IProject project) {
        project.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event.getDelta() != null) {
                    IResourceDelta[] iResourceDeltaArray = event.getDelta().getAffectedChildren();
                    int n = iResourceDeltaArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResourceDelta subdelta = iResourceDeltaArray[n2];
                        IProject project = (IProject)subdelta.getResource();
                        boolean relevant = false;
                        for (IPath p : CoherenceCacheConfigService.this.triggerFiles) {
                            if (subdelta.findMember(p) == null) continue;
                            relevant = true;
                            break;
                        }
                        for (IPath p : CoherenceCacheConfigService.this.srcFiles) {
                            if (subdelta.getFullPath().equals((Object)p)) {
                                relevant = true;
                                break;
                            }
                            if (!CoherenceCacheConfigService.this.isSrcRelevant(subdelta)) continue;
                            relevant = true;
                            break;
                        }
                        if (relevant) {
                            CoherenceCacheConfigService.this.projectToDom.remove(project);
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    private boolean isSrcRelevant(IResourceDelta delta) {
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta subdelta = iResourceDeltaArray[n2];
            for (IPath p : this.srcFiles) {
                if (!subdelta.getFullPath().equals((Object)p)) continue;
                return true;
            }
            boolean relevant = this.isSrcRelevant(subdelta);
            if (relevant) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String getTextValueImpl(IProject project, String path) {
        String text = null;
        for (Element elem : this.getDomForProject(project)) {
            String elemText;
            if (elem == null || (elemText = OverrideDomUtil.getText(elem, path)) == null) continue;
            text = elemText;
        }
        return text;
    }

    private Collection<String> getListOfValuesImpl(IProject project, String parentPath, String attributePath, String valuePath) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Element elem : this.getDomForProject(project)) {
            Element baseParent;
            if (elem == null || (baseParent = OverrideDomUtil.getChildElement(elem, parentPath)) == null) continue;
            for (Element baseElement : DomUtil.elements((Element)baseParent)) {
                if (attributePath != null) {
                    String key = baseElement.getAttribute(attributePath);
                    String value = valuePath != null && valuePath.length() > 0 ? DomUtil.text((Element)baseElement, (String)valuePath) : key;
                    if (value == null) continue;
                    map.put(key, value.trim());
                    continue;
                }
                String value = DomUtil.text((Element)baseElement, (String)valuePath);
                map.put(value, value.trim());
            }
        }
        return map.values();
    }

    public static String getTextValue(IProject project, String path) {
        return service.getTextValueImpl(project, path);
    }

    public static Collection<String> getListOfValues(IProject project, String parentPath, String attributePath, String valuePath) {
        return service.getListOfValuesImpl(project, parentPath, attributePath, valuePath);
    }

    public static String getFullXmlPath(XmlElement element, String relative) {
        LinkedList<String> trail = new LinkedList<String>();
        XmlElement el = element;
        while (el.getParent() != null) {
            trail.addFirst(el.getLocalName());
            el = el.getParent();
        }
        StringBuilder buf = new StringBuilder();
        for (String segment : trail) {
            if (buf.length() > 0) {
                buf.append('/');
            }
            buf.append(segment);
        }
        if (buf.length() > 0) {
            buf.append('/');
        }
        buf.append(relative);
        return buf.toString();
    }

    private static final class Resources
    extends NLS {
        public static String error;

        static {
            Resources.initializeMessages((String)CoherenceCacheConfigService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

