/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.classpath;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.coherence.classpath.GarAppLibrariesStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.common.internal.modulecore.ClasspathContainerVirtualComponent;
import org.eclipse.jst.common.jdt.internal.classpath.FlexibleProjectContainer;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.internal.builder.IDependencyGraph;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class GarLibrariesContainer
extends FlexibleProjectContainer {
    private GarAppLibrariesStore.RestoreState restoreState;
    public static final String LIB_PATH = "lib";
    private static final IPath[] libPaths = new IPath[]{new Path("/lib")};
    private static final FlexibleProjectContainer.PathType[] types = new FlexibleProjectContainer.PathType[]{FlexibleProjectContainer.PathType.LIB_DIRECTORY};
    public static final String CONTAINER_ID = "oracle.eclipse.tools.coherence.gar.libs.container";
    private static Map<String, Object> referenceOptions = new HashMap<String, Object>();
    protected List<IVirtualReference> consumedReferences;

    static {
        referenceOptions.put("GET_JAVA_REFS", Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GarLibrariesContainer(IPath path, IJavaProject jproject) {
        super(path, jproject, GarLibrariesContainer.getProject(path, jproject), libPaths, types);
        boolean needToVerify = false;
        if (this.restoreState != null) {
            GarAppLibrariesStore.RestoreState restoreState = this.restoreState;
            synchronized (restoreState) {
                needToVerify = this.restoreState.needToVerify;
                this.restoreState.needToVerify = false;
            }
        }
        if (needToVerify) {
            Job verifyJob = new Job(Resources.verify){

                protected IStatus run(IProgressMonitor monitor) {
                    GarLibrariesContainer.this.refresh(false);
                    return Status.OK_STATUS;
                }
            };
            verifyJob.setSystem(true);
            verifyJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            verifyJob.schedule();
        }
    }

    public String getDescription() {
        if (this.owner.getProject() != this.project) {
            return NLS.bind((String)Resources.labelWithProject, (Object)this.project.getName());
        }
        return Resources.label;
    }

    public void install() {
        IJavaProject[] projects = new IJavaProject[]{this.owner};
        IClasspathContainer[] conts = new IClasspathContainer[]{this};
        try {
            JavaCore.setClasspathContainer((IPath)this.path, (IJavaProject[])projects, (IClasspathContainer[])conts, null);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    public boolean isOutOfDate() {
        boolean outOfDate;
        if (IDependencyGraph.INSTANCE.isStale()) {
            J2EEComponentClasspathUpdater.getInstance().queueUpdate(this.owner.getProject());
            return true;
        }
        List currentEntries = this.computeClasspathEntries(false);
        boolean bl = outOfDate = !this.entries.equals(currentEntries);
        if (outOfDate) {
            GarAppLibrariesStore.flush(this.project.getName());
        }
        return outOfDate;
    }

    public void refresh(boolean forceUpdate) {
        if (IDependencyGraph.INSTANCE.isStale()) {
            J2EEComponentClasspathUpdater.getInstance().queueUpdate(this.owner.getProject());
            return;
        }
        if (forceUpdate || this.isOutOfDate()) {
            this.refresh();
        }
    }

    public void refresh() {
        if (IDependencyGraph.INSTANCE.isStale()) {
            J2EEComponentClasspathUpdater.getInstance().queueUpdate(this.owner.getProject());
            return;
        }
        new GarLibrariesContainer(this.path, this.owner).install();
    }

    protected IVirtualReference[] computeReferences(IVirtualComponent vc) {
        IVirtualReference[] baseRefs = ((VirtualComponent)vc).getReferences(referenceOptions);
        ArrayList<IVirtualReference> refs = new ArrayList<IVirtualReference>();
        IVirtualReference[] iVirtualReferenceArray = baseRefs;
        int n = baseRefs.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualReference ref = iVirtualReferenceArray[n2];
            if (ref.getDependencyType() == 0) {
                refs.add(ref);
            } else if (ref.getRuntimePath().equals((Object)libPaths[0].makeAbsolute())) {
                if (this.consumedReferences == null) {
                    this.consumedReferences = new ArrayList<IVirtualReference>();
                }
                this.consumedReferences.add(ref);
            }
            ++n2;
        }
        return refs.toArray(new IVirtualReference[refs.size()]);
    }

    protected List computeClasspathEntries() {
        return this.computeClasspathEntries(true);
    }

    protected List computeClasspathEntries(boolean useRestoreState) {
        if (useRestoreState) {
            this.restoreState = GarAppLibrariesStore.getRestoreState(this.project.getName());
            if (this.restoreState != null) {
                return this.restoreState.paths;
            }
        }
        List entries = super.computeClasspathEntries();
        if (this.consumedReferences != null) {
            for (IVirtualReference ref : this.consumedReferences) {
                IClasspathEntry[] newEntries;
                IClasspathContainer container;
                ClasspathContainerVirtualComponent cpvc;
                if (!(ref.getReferencedComponent() instanceof ClasspathContainerVirtualComponent) || (cpvc = (ClasspathContainerVirtualComponent)ref.getReferencedComponent()) == null || (container = cpvc.getClasspathContainer()) == null) continue;
                IClasspathEntry[] iClasspathEntryArray = newEntries = container.getClasspathEntries();
                int n = newEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    IPath entryPath = entry.getPath();
                    if (!entries.contains(entryPath)) {
                        entries.add(entryPath);
                    }
                    ++n2;
                }
            }
        }
        GarAppLibrariesStore.saveState(this.project.getName(), entries);
        return entries;
    }

    private static final IProject getProject(IPath path, IJavaProject jproject) {
        if (path.segmentCount() == 1) {
            return jproject.getProject();
        }
        String name = path.segment(1);
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }

    private static final class Resources
    extends NLS {
        public static String label;
        public static String labelWithProject;
        public static String verify;

        static {
            Resources.initializeMessages((String)GarLibrariesContainer.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

