/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.jpql.spi;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.utility.internal.StringBuilderTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.jpa2.context.ElementCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.jpql.spi.JpaTypeDeclaration;
import org.eclipse.persistence.jpa.jpql.tools.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.tools.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.tools.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.tools.spi.IType;
import org.eclipse.persistence.jpa.jpql.tools.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.tools.spi.ITypeRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JpaMapping
implements IMapping {
    private final AttributeMapping mapping;
    private int mappingType;
    private final IManagedType parent;
    private IType type;
    private ITypeDeclaration typeDeclaration;

    protected JpaMapping(IManagedType parent, AttributeMapping mapping) {
        this.parent = parent;
        this.mapping = mapping;
        this.mappingType = -1;
    }

    protected ITypeDeclaration[] buildGenericTypeDeclarations() {
        JavaSpecifiedPersistentAttribute javaPersistentAttribute = this.mapping.getPersistentAttribute().getJavaPersistentAttribute();
        JavaResourceAttribute resource = javaPersistentAttribute == null ? null : javaPersistentAttribute.getResourceAttribute();
        ArrayList declarations = ListTools.list(this.buildGenericTypeDeclarations(resource));
        return declarations.toArray(new ITypeDeclaration[declarations.size()]);
    }

    protected Iterable<ITypeDeclaration> buildGenericTypeDeclarations(JavaResourceAttribute resource) {
        return resource != null ? IterableTools.transform((ListIterable)resource.getTypeBinding().getTypeArgumentNames(), (Transformer)new TypeDeclarationTransformer()) : IterableTools.emptyIterable();
    }

    protected IType buildType(boolean resolveRelationshipType) {
        SpecifiedPersistentAttribute property = this.mapping.getPersistentAttribute();
        String typeName = property.getTypeName();
        if (typeName == null) {
            return this.getTypeRepository().getTypeHelper().unknownType();
        }
        if (resolveRelationshipType && this.isRelationship()) {
            if (this.mappingType == 2) {
                String targetClass = ((ElementCollectionMapping2_0)this.mapping).getTargetClass();
                if (StringTools.isNotBlank((String)targetClass)) {
                    return this.getTypeRepository().getType(targetClass);
                }
            } else {
                IEntity entity;
                typeName = ((RelationshipMapping)this.mapping).getFullyQualifiedTargetEntity();
                if (StringTools.isNotBlank((String)typeName) && (entity = this.getParent().getProvider().getEntity(typeName)) != null) {
                    return entity.getType();
                }
            }
        }
        return this.getTypeRepository().getType(typeName);
    }

    protected ITypeDeclaration buildTypeDeclaration() {
        SpecifiedPersistentAttribute property = this.mapping.getPersistentAttribute();
        String typeName = property.getTypeName();
        if (typeName == null) {
            return this.getTypeRepository().getTypeHelper().unknownTypeDeclaration();
        }
        boolean array = typeName.endsWith("[]");
        int dimensionality = 0;
        if (array) {
            dimensionality = this.getType().getTypeDeclaration().getDimensionality();
        }
        return new JpaTypeDeclaration(this.buildType(false), this.buildGenericTypeDeclarations(), dimensionality);
    }

    protected int calculateMappingType() {
        String type = this.mapping.getKey();
        if (type == "basic") {
            return 1;
        }
        if (type == "embedded") {
            return 3;
        }
        if (type == "embeddedId") {
            return 4;
        }
        if (type == "id") {
            return 5;
        }
        if (type == "manyToMany") {
            return 6;
        }
        if (type == "oneToMany") {
            return 8;
        }
        if (type == "manyToOne") {
            return 7;
        }
        if (type == "oneToOne") {
            return 9;
        }
        if (type == "version") {
            return 11;
        }
        if (type == "elementCollection") {
            return 2;
        }
        return 10;
    }

    public int compareTo(IMapping mapping) {
        return this.getName().compareTo(mapping.getName());
    }

    protected AttributeMapping getMapping() {
        return this.mapping;
    }

    public int getMappingType() {
        if (this.mappingType == -1) {
            this.mappingType = this.calculateMappingType();
        }
        return this.mappingType;
    }

    public String getName() {
        return this.mapping.getName();
    }

    public IManagedType getParent() {
        return this.parent;
    }

    public IType getType() {
        if (this.type == null) {
            this.type = this.buildType(true);
        }
        return this.type;
    }

    public ITypeDeclaration getTypeDeclaration() {
        if (this.typeDeclaration == null) {
            this.typeDeclaration = this.buildTypeDeclaration();
        }
        return this.typeDeclaration;
    }

    protected ITypeRepository getTypeRepository() {
        return this.parent.getProvider().getTypeRepository();
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        JavaResourceAttribute attribute = this.mapping.getPersistentAttribute().getJavaPersistentAttribute().getResourceAttribute();
        return attribute.getAnnotation(annotationType.getName()) != null;
    }

    public boolean isCollection() {
        switch (this.getMappingType()) {
            case 2: 
            case 6: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public boolean isProperty() {
        switch (this.getMappingType()) {
            case 1: 
            case 5: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public boolean isRelationship() {
        switch (this.getMappingType()) {
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public boolean isTransient() {
        return this.getMappingType() == 10;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.appendHashCodeToString((StringBuilder)sb, (Object)this);
        sb.append(" name=");
        sb.append(this.getName());
        sb.append(", mappingType=");
        sb.append(this.mapping.getKey());
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TypeDeclarationTransformer
    extends TransformerAdapter<String, ITypeDeclaration> {
        protected TypeDeclarationTransformer() {
        }

        public ITypeDeclaration transform(String typeName) {
            return JpaMapping.this.getTypeRepository().getType(typeName).getTypeDeclaration();
        }
    }
}

