/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.resource.java.GeneratorAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceGeneratorAnnotation
extends SourceAnnotation
implements GeneratorAnnotation {
    final DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter = this.getNameAdapter();
    final AnnotationElementAdapter<String> nameAdapter = this.buildAdapter(this.nameDeclarationAdapter);
    String name;
    TextRange nameTextRange;

    protected SourceGeneratorAnnotation(JavaResourceModel parent, AnnotatedElement element, DeclarationAnnotationAdapter daa) {
        super(parent, element, daa);
    }

    protected AnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.name = this.buildName(astAnnotation);
        this.nameTextRange = this.buildNameTextRange(astAnnotation);
    }

    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncName(this.buildName(astAnnotation));
        this.nameTextRange = this.buildNameTextRange(astAnnotation);
    }

    public boolean isUnset() {
        return super.isUnset() && this.name == null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (ObjectTools.notEquals((Object)this.name, (Object)name)) {
            this.name = name;
            this.nameAdapter.setValue((Object)name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(Annotation astAnnotation) {
        return (String)this.nameAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getNameTextRange() {
        return this.nameTextRange;
    }

    private TextRange buildNameTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astAnnotation);
    }

    protected abstract DeclarationAnnotationElementAdapter<String> getNameAdapter();

    protected static DeclarationAnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)annotationAdapter, (String)elementName);
    }
}

