/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.jdt.CombinationIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.jpa.core.internal.resource.java.NullAttributeOverrideColumnAnnotation;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceColumnAnnotation;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.ColumnAnnotation;

public final class SourceAttributeOverrideAnnotation
extends SourceOverrideAnnotation
implements AttributeOverrideAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.AttributeOverride");
    private static final DeclarationAnnotationAdapter CONTAINER_DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.AttributeOverrides");
    private ElementAnnotationAdapter columnAdapter = this.buildColumnAdapter();
    private ColumnAnnotation column;
    private final ColumnAnnotation nullColumn = this.buildNullColumn();

    public static SourceAttributeOverrideAnnotation buildSourceAttributeOverrideAnnotation(JavaResourceModel parent, AnnotatedElement element) {
        return new SourceAttributeOverrideAnnotation(parent, element, DECLARATION_ANNOTATION_ADAPTER);
    }

    public static SourceAttributeOverrideAnnotation buildSourceAttributeOverrideAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement annotatedElement, int index) {
        IndexedDeclarationAnnotationAdapter idaa = SourceAttributeOverrideAnnotation.buildAttributeOverrideDeclarationAnnotationAdapter(index);
        IndexedAnnotationAdapter iaa = SourceAttributeOverrideAnnotation.buildAttributeOverrideAnnotationAdapter(annotatedElement, idaa);
        return new SourceAttributeOverrideAnnotation((JavaResourceModel)parent, annotatedElement, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)iaa);
    }

    public static SourceAttributeOverrideAnnotation buildNestedSourceAttributeOverrideAnnotation(JavaResourceModel parent, AnnotatedElement element, IndexedDeclarationAnnotationAdapter idaa) {
        return new SourceAttributeOverrideAnnotation(parent, element, idaa);
    }

    private SourceAttributeOverrideAnnotation(JavaResourceModel parent, AnnotatedElement element, DeclarationAnnotationAdapter daa) {
        this(parent, element, daa, (AnnotationAdapter)new ElementAnnotationAdapter(element, daa));
    }

    private SourceAttributeOverrideAnnotation(JavaResourceModel parent, AnnotatedElement element, IndexedDeclarationAnnotationAdapter idaa) {
        this(parent, element, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)new ElementIndexedAnnotationAdapter(element, idaa));
    }

    private SourceAttributeOverrideAnnotation(JavaResourceModel parent, AnnotatedElement element, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, element, daa, annotationAdapter);
    }

    public String getAnnotationName() {
        return "javax.persistence.AttributeOverride";
    }

    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        Annotation columnAnnotation = this.columnAdapter.getAnnotation(astRoot);
        if (columnAnnotation != null) {
            this.column = SourceColumnAnnotation.createAttributeOverrideColumn((JavaResourceModel)this, this.annotatedElement, this.daa);
            this.column.initialize(columnAnnotation);
        }
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncColumn(astRoot);
    }

    protected String getNameElementName() {
        return "name";
    }

    public ColumnAnnotation getColumn() {
        return this.column;
    }

    public ColumnAnnotation getNonNullColumn() {
        return this.column != null ? this.column : this.nullColumn;
    }

    public ColumnAnnotation addColumn() {
        if (this.column != null) {
            throw new IllegalStateException("'column' element already exists: " + this.column);
        }
        this.column = SourceColumnAnnotation.createAttributeOverrideColumn((JavaResourceModel)this, this.annotatedElement, this.daa);
        this.column.newAnnotation();
        return this.column;
    }

    public void removeColumn() {
        if (this.column == null) {
            throw new IllegalStateException("'column' element does not exist");
        }
        ColumnAnnotation old = this.column;
        this.column = null;
        old.removeAnnotation();
    }

    private void syncColumn(CompilationUnit astRoot) {
        Annotation columnAnnotation = this.columnAdapter.getAnnotation(astRoot);
        if (columnAnnotation == null) {
            this.syncColumn_(null);
        } else if (this.column == null) {
            ColumnAnnotation col = SourceColumnAnnotation.createAttributeOverrideColumn((JavaResourceModel)this, this.annotatedElement, this.daa);
            col.initialize(columnAnnotation);
            this.syncColumn_(col);
        } else {
            this.column.synchronizeWith(columnAnnotation);
        }
    }

    private void syncColumn_(ColumnAnnotation astColumn) {
        ColumnAnnotation old = this.column;
        this.column = astColumn;
        this.firePropertyChanged("column", old, astColumn);
    }

    private ElementAnnotationAdapter buildColumnAdapter() {
        return new ElementAnnotationAdapter(this.annotatedElement, SourceColumnAnnotation.buildAttributeOverrideAnnotationAdapter(this.daa));
    }

    private ColumnAnnotation buildNullColumn() {
        return new NullAttributeOverrideColumnAnnotation(this);
    }

    public boolean isUnset() {
        return super.isUnset() && this.column == null;
    }

    protected static IndexedAnnotationAdapter buildAttributeOverrideAnnotationAdapter(AnnotatedElement annotatedElement, IndexedDeclarationAnnotationAdapter idaa) {
        return new ElementIndexedAnnotationAdapter(annotatedElement, idaa);
    }

    protected static IndexedDeclarationAnnotationAdapter buildAttributeOverrideDeclarationAnnotationAdapter(int index) {
        CombinationIndexedDeclarationAnnotationAdapter idaa = new CombinationIndexedDeclarationAnnotationAdapter(DECLARATION_ANNOTATION_ADAPTER, CONTAINER_DECLARATION_ANNOTATION_ADAPTER, index, "javax.persistence.AttributeOverride");
        return idaa;
    }
}

