/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.ValidationMessage;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.RelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmMappedByRelationship;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedMappedByRelationshipStrategy;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextModel;
import org.eclipse.jpt.jpa.core.jpa2.context.OverrideRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.SpecifiedMappingRelationshipStrategy2_0;
import org.eclipse.jpt.jpa.core.resource.orm.XmlMappedByMapping;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationArgumentMessages;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmMappedByRelationshipStrategy
extends AbstractOrmXmlContextModel<OrmMappedByRelationship>
implements SpecifiedMappingRelationshipStrategy2_0,
OrmSpecifiedMappedByRelationshipStrategy {
    protected String mappedByAttribute = this.getXmlMappedByMapping().getMappedBy();

    public GenericOrmMappedByRelationshipStrategy(OrmMappedByRelationship parent) {
        super(parent);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setMappedByAttribute_(this.getXmlMappedByMapping().getMappedBy());
    }

    @Override
    public String getMappedByAttribute() {
        return this.mappedByAttribute;
    }

    @Override
    public void setMappedByAttribute(String mappedByAttribute) {
        this.setMappedByAttribute_(mappedByAttribute);
        this.getXmlMappedByMapping().setMappedBy(mappedByAttribute);
    }

    protected void setMappedByAttribute_(String mappedByAttribute) {
        String old = this.mappedByAttribute;
        this.mappedByAttribute = mappedByAttribute;
        this.firePropertyChanged("mappedByAttribute", old, mappedByAttribute);
    }

    @Override
    public OrmMappedByRelationship getRelationship() {
        return (OrmMappedByRelationship)this.parent;
    }

    protected XmlMappedByMapping getXmlMappedByMapping() {
        return this.getRelationship().getXmlContainer();
    }

    @Override
    public void initializeFrom(OrmSpecifiedMappedByRelationshipStrategy oldStrategy) {
        this.setMappedByAttribute(oldStrategy.getMappedByAttribute());
    }

    @Override
    public String getTableName() {
        RelationshipMapping owner = this.getRelationshipOwner();
        return owner == null ? null : owner.getRelationship().getStrategy().getTableName();
    }

    @Override
    public Table resolveDbTable(String tableName) {
        RelationshipMapping owner = this.getRelationshipOwner();
        return owner == null ? null : owner.getRelationship().getStrategy().resolveDbTable(tableName);
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        RelationshipMapping owner = this.getRelationshipOwner();
        return owner != null && owner.getRelationship().getStrategy().tableNameIsInvalid(tableName);
    }

    @Override
    public String getColumnTableNotValidDescription() {
        return this.getRelationshipOwner().getRelationship().getStrategy().getColumnTableNotValidDescription();
    }

    protected RelationshipMapping getRelationshipOwner() {
        return this.getRelationshipMapping().getRelationshipOwner();
    }

    @Override
    public boolean isOverridable() {
        return false;
    }

    protected RelationshipMapping getRelationshipMapping() {
        return this.getRelationship().getMapping();
    }

    @Override
    public boolean relationshipIsOwnedBy(RelationshipMapping otherMapping) {
        String otherEntityName;
        String thisEntityName = this.getEntityName();
        Entity otherEntity = otherMapping.getResolvedTargetEntity();
        String string = otherEntityName = otherEntity == null ? null : otherEntity.getName();
        return ObjectTools.equals((Object)thisEntityName, (Object)otherEntityName) && ObjectTools.equals((Object)this.mappedByAttribute, (Object)otherMapping.getName());
    }

    protected String getEntityName() {
        Entity entity = this.getRelationship().getEntity();
        return entity == null ? null : entity.getName();
    }

    @Override
    public RelationshipStrategy selectOverrideStrategy(OverrideRelationship2_0 overrideRelationship) {
        return null;
    }

    @Override
    public void addStrategy() {
        if (this.mappedByAttribute == null) {
            this.setMappedByAttribute("");
        }
    }

    @Override
    public void removeStrategy() {
        if (this.mappedByAttribute != null) {
            this.setMappedByAttribute(null);
        }
    }

    @Override
    public Iterable<String> getCandidateMappedByAttributeNames() {
        return this.getRelationshipMapping().getTargetEntityNonTransientAttributeNames();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.mappedByAttribute == null) {
            return;
        }
        Entity targetEntity = this.getRelationshipMapping().getResolvedTargetEntity();
        if (targetEntity == null) {
            return;
        }
        AttributeMapping mappedByMapping = targetEntity.resolveAttributeMapping(this.mappedByAttribute);
        if (mappedByMapping == null) {
            messages.add(this.buildMessage(JptJpaCoreValidationMessages.MAPPING_UNRESOLVED_MAPPED_BY, new String[]{this.mappedByAttribute}));
            return;
        }
        if (!this.getRelationship().mayBeMappedBy(mappedByMapping)) {
            messages.add(this.buildMessage(JptJpaCoreValidationMessages.MAPPING_INVALID_MAPPED_BY, new String[]{this.mappedByAttribute}));
            return;
        }
        if (!((RelationshipMapping)mappedByMapping).isRelationshipOwner()) {
            messages.add(this.buildMessage(JptJpaCoreValidationMessages.MAPPING_MAPPED_BY_ON_BOTH_SIDES, new String[]{this.mappedByAttribute}));
        }
    }

    protected IMessage buildMessage(ValidationMessage msg, Object[] args) {
        SpecifiedPersistentAttribute attribute = this.getRelationshipMapping().getPersistentAttribute();
        String attributeDescription = NLS.bind((String)JptJpaCoreValidationArgumentMessages.ATTRIBUTE_DESC, (Object)attribute.getName());
        args = ArrayTools.add((Object[])args, (int)0, (Object)attributeDescription);
        return this.buildValidationMessage(this.getValidationTextRange(), msg, args);
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getXmlMappedByMapping().getMappedByTextRange();
        return textRange != null ? textRange : this.getRelationship().getValidationTextRange();
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.mappedByTouches(pos)) {
            return this.getCandidateMappedByAttributeNames();
        }
        return null;
    }

    protected boolean mappedByTouches(int pos) {
        return this.getXmlMappedByMapping().mappedByTouches(pos);
    }
}

