/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.ArrayList;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.internal.utility.ContentTypeTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeMappingDefinition;
import org.eclipse.jpt.jpa.core.context.orm.OrmManagedTypeDefinition;
import org.eclipse.jpt.jpa.core.context.orm.OrmTypeMappingDefinition;
import org.eclipse.jpt.jpa.core.context.orm.OrmXmlContextModelFactory;
import org.eclipse.jpt.jpa.core.context.orm.OrmXmlDefinition;
import org.eclipse.jpt.jpa.core.context.orm.UnsupportedOrmAttributeMappingDefinition;
import org.eclipse.jpt.jpa.core.internal.context.orm.OrmEmbeddableDefinition;
import org.eclipse.jpt.jpa.core.internal.context.orm.OrmEntityDefinition;
import org.eclipse.jpt.jpa.core.internal.context.orm.OrmMappedSuperclassDefinition;
import org.eclipse.jpt.jpa.core.internal.context.orm.OrmPersistentTypeDefinition;
import org.eclipse.jpt.jpa.core.resource.orm.XmlManagedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmXmlDefinition
implements OrmXmlDefinition {
    protected final OrmXmlContextModelFactory factory = this.buildContextModelFactory();
    protected ArrayList<OrmManagedTypeDefinition> managedTypeDefinitions;
    protected ArrayList<OrmTypeMappingDefinition> typeMappingDefinitions;
    protected ArrayList<OrmAttributeMappingDefinition> attributeMappingDefinitions;
    protected static final OrmManagedTypeDefinition[] MANAGED_TYPE_DEFINITIONS = new OrmManagedTypeDefinition[]{OrmPersistentTypeDefinition.instance()};
    protected static final OrmTypeMappingDefinition[] TYPE_MAPPING_DEFINITIONS = new OrmTypeMappingDefinition[]{OrmEntityDefinition.instance(), OrmEmbeddableDefinition.instance(), OrmMappedSuperclassDefinition.instance()};

    protected AbstractOrmXmlDefinition() {
    }

    protected abstract OrmXmlContextModelFactory buildContextModelFactory();

    @Override
    public OrmXmlContextModelFactory getContextModelFactory() {
        return this.factory;
    }

    @Override
    public OrmManagedTypeDefinition getManagedTypeDefinition(Class<? extends XmlManagedType> resourceType) {
        for (OrmManagedTypeDefinition definition : this.getManagedTypeDefinitions()) {
            if (definition.getResourceManagedTypeType() != resourceType) continue;
            return definition;
        }
        throw new IllegalArgumentException("Illegal managed type resource type: " + resourceType);
    }

    protected synchronized ArrayList<OrmManagedTypeDefinition> getManagedTypeDefinitions() {
        if (this.managedTypeDefinitions == null) {
            this.managedTypeDefinitions = this.buildManagedTypeDefinitions();
        }
        return this.managedTypeDefinitions;
    }

    protected ArrayList<OrmManagedTypeDefinition> buildManagedTypeDefinitions() {
        ArrayList<OrmManagedTypeDefinition> definitions = new ArrayList<OrmManagedTypeDefinition>();
        this.addManagedTypeDefinitionsTo(definitions);
        return definitions;
    }

    protected void addManagedTypeDefinitionsTo(ArrayList<OrmManagedTypeDefinition> definitions) {
        CollectionTools.addAll(definitions, (Object[])MANAGED_TYPE_DEFINITIONS);
    }

    @Override
    public OrmTypeMappingDefinition getTypeMappingDefinition(String mappingKey) {
        for (OrmTypeMappingDefinition definition : this.getTypeMappingDefinitions()) {
            if (!ObjectTools.equals((Object)definition.getKey(), (Object)mappingKey)) continue;
            return definition;
        }
        throw new IllegalArgumentException("Illegal type mapping key: " + mappingKey);
    }

    protected synchronized ArrayList<OrmTypeMappingDefinition> getTypeMappingDefinitions() {
        if (this.typeMappingDefinitions == null) {
            this.typeMappingDefinitions = this.buildTypeMappingDefinitions();
        }
        return this.typeMappingDefinitions;
    }

    protected ArrayList<OrmTypeMappingDefinition> buildTypeMappingDefinitions() {
        ArrayList<OrmTypeMappingDefinition> definitions = new ArrayList<OrmTypeMappingDefinition>();
        this.addTypeMappingDefinitionsTo(definitions);
        return definitions;
    }

    protected void addTypeMappingDefinitionsTo(ArrayList<OrmTypeMappingDefinition> definitions) {
        CollectionTools.addAll(definitions, (Object[])TYPE_MAPPING_DEFINITIONS);
    }

    @Override
    public OrmAttributeMappingDefinition getAttributeMappingDefinition(String mappingKey) {
        for (OrmAttributeMappingDefinition definition : this.getAttributeMappingDefinitions()) {
            if (!ObjectTools.equals((Object)definition.getKey(), (Object)mappingKey)) continue;
            return definition;
        }
        return UnsupportedOrmAttributeMappingDefinition.instance();
    }

    protected synchronized ArrayList<OrmAttributeMappingDefinition> getAttributeMappingDefinitions() {
        if (this.attributeMappingDefinitions == null) {
            this.attributeMappingDefinitions = this.buildAttributeMappingDefinitions();
        }
        return this.attributeMappingDefinitions;
    }

    protected ArrayList<OrmAttributeMappingDefinition> buildAttributeMappingDefinitions() {
        ArrayList<OrmAttributeMappingDefinition> definitions = new ArrayList<OrmAttributeMappingDefinition>();
        this.addAttributeMappingDefinitionsTo(definitions);
        return definitions;
    }

    protected abstract void addAttributeMappingDefinitionsTo(ArrayList<OrmAttributeMappingDefinition> var1);

    protected JptResourceType getResourceType(IContentType contentType, String version) {
        return ContentTypeTools.getResourceType((IContentType)contentType, (String)version);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

