/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.NameTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.SpecifiedUniqueConstraint;
import org.eclipse.jpt.jpa.core.context.Table;
import org.eclipse.jpt.jpa.core.context.UniqueConstraint;
import org.eclipse.jpt.jpa.core.context.VirtualTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedUniqueConstraint;
import org.eclipse.jpt.jpa.core.internal.context.AbstractJpaContextModel;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextModel;
import org.eclipse.jpt.jpa.core.resource.orm.AbstractXmlTable;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlUniqueConstraint;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmTable<P extends JpaContextModel, PA extends Table.ParentAdapter<P>, X extends AbstractXmlTable>
extends AbstractOrmXmlContextModel<P>
implements OrmSpecifiedTable,
SpecifiedUniqueConstraint.Parent {
    protected final PA parentAdapter;
    protected String specifiedName;
    protected String defaultName;
    protected String specifiedSchema;
    protected String defaultSchema;
    protected String specifiedCatalog;
    protected String defaultCatalog;
    protected final AbstractJpaContextModel.ContextListContainer<OrmSpecifiedUniqueConstraint, XmlUniqueConstraint> uniqueConstraintContainer;

    protected AbstractOrmTable(PA parentAdapter) {
        this(parentAdapter, null);
    }

    protected AbstractOrmTable(PA parentAdapter, X xmlTable) {
        super(parentAdapter.getTableParent());
        this.parentAdapter = parentAdapter;
        this.setXmlTable(xmlTable);
        this.specifiedName = this.buildSpecifiedName();
        this.specifiedSchema = this.buildSpecifiedSchema();
        this.specifiedCatalog = this.buildSpecifiedCatalog();
        this.uniqueConstraintContainer = this.buildUniqueConstraintContainer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedName_(this.buildSpecifiedName());
        this.setSpecifiedSchema_(this.buildSpecifiedSchema());
        this.setSpecifiedCatalog_(this.buildSpecifiedCatalog());
        this.syncUniqueConstraints();
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultName(this.buildDefaultName());
        this.setDefaultSchema(this.buildDefaultSchema());
        this.setDefaultCatalog(this.buildDefaultCatalog());
        this.updateModels((Iterable<? extends JpaContextModel>)this.getUniqueConstraints());
    }

    protected abstract X getXmlTable();

    protected void setXmlTable(X xmlTable) {
        if (xmlTable != null) {
            throw new IllegalArgumentException("this method must be overridden if the XML table is not null: " + xmlTable);
        }
    }

    protected X getXmlTableForUpdate() {
        X xmlTable = this.getXmlTable();
        return xmlTable != null ? xmlTable : this.buildXmlTable();
    }

    protected abstract X buildXmlTable();

    protected void removeXmlTableIfUnset() {
        if (this.getXmlTable().isUnset()) {
            this.removeXmlTable();
        }
    }

    protected abstract void removeXmlTable();

    @Override
    public boolean isSpecifiedInResource() {
        return this.getXmlTable() != null;
    }

    @Override
    public String getName() {
        return this.specifiedName != null ? this.specifiedName : this.defaultName;
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String name) {
        if (ObjectTools.notEquals((Object)this.specifiedName, (Object)name)) {
            X xmlTable = this.getXmlTableForUpdate();
            this.setSpecifiedName_(name);
            ((AbstractXmlTable)((Object)xmlTable)).setName(name);
            this.removeXmlTableIfUnset();
        }
    }

    protected void setSpecifiedName_(String name) {
        String old = this.specifiedName;
        this.specifiedName = name;
        this.firePropertyChanged("specifiedName", old, name);
    }

    protected String buildSpecifiedName() {
        X xmlTable = this.getXmlTable();
        return xmlTable == null ? null : ((AbstractXmlTable)((Object)xmlTable)).getName();
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String name) {
        String old = this.defaultName;
        this.defaultName = name;
        this.firePropertyChanged("defaultName", old, name);
    }

    protected abstract String buildDefaultName();

    @Override
    public String getSchema() {
        return this.specifiedSchema != null ? this.specifiedSchema : this.defaultSchema;
    }

    @Override
    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    @Override
    public void setSpecifiedSchema(String schema) {
        if (ObjectTools.notEquals((Object)this.specifiedSchema, (Object)schema)) {
            X xmlTable = this.getXmlTableForUpdate();
            this.setSpecifiedSchema_(schema);
            ((AbstractXmlTable)((Object)xmlTable)).setSchema(schema);
            this.removeXmlTableIfUnset();
        }
    }

    protected void setSpecifiedSchema_(String schema) {
        String old = this.specifiedSchema;
        this.specifiedSchema = schema;
        this.firePropertyChanged("specifiedSchema", old, schema);
    }

    protected String buildSpecifiedSchema() {
        X xmlTable = this.getXmlTable();
        return xmlTable == null ? null : ((AbstractXmlTable)((Object)xmlTable)).getSchema();
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String schema) {
        String old = this.defaultSchema;
        this.defaultSchema = schema;
        this.firePropertyChanged("defaultSchema", old, schema);
    }

    protected abstract String buildDefaultSchema();

    @Override
    public String getCatalog() {
        return this.specifiedCatalog != null ? this.specifiedCatalog : this.defaultCatalog;
    }

    @Override
    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    @Override
    public void setSpecifiedCatalog(String catalog) {
        if (ObjectTools.notEquals((Object)this.specifiedCatalog, (Object)catalog)) {
            X xmlTable = this.getXmlTableForUpdate();
            this.setSpecifiedCatalog_(catalog);
            ((AbstractXmlTable)((Object)xmlTable)).setCatalog(catalog);
            this.removeXmlTableIfUnset();
        }
    }

    protected void setSpecifiedCatalog_(String catalog) {
        String old = this.specifiedCatalog;
        this.specifiedCatalog = catalog;
        this.firePropertyChanged("specifiedCatalog", old, catalog);
    }

    protected String buildSpecifiedCatalog() {
        X xmlTable = this.getXmlTable();
        return xmlTable == null ? null : ((AbstractXmlTable)((Object)xmlTable)).getCatalog();
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String catalog) {
        String old = this.defaultCatalog;
        this.defaultCatalog = catalog;
        this.firePropertyChanged("defaultCatalog", old, catalog);
    }

    protected abstract String buildDefaultCatalog();

    @Override
    public ListIterable<OrmSpecifiedUniqueConstraint> getUniqueConstraints() {
        return this.uniqueConstraintContainer;
    }

    @Override
    public int getUniqueConstraintsSize() {
        return this.uniqueConstraintContainer.size();
    }

    @Override
    public OrmSpecifiedUniqueConstraint getUniqueConstraint(int index) {
        return (OrmSpecifiedUniqueConstraint)this.uniqueConstraintContainer.get(index);
    }

    @Override
    public OrmSpecifiedUniqueConstraint addUniqueConstraint() {
        return this.addUniqueConstraint(this.getUniqueConstraintsSize());
    }

    @Override
    public OrmSpecifiedUniqueConstraint addUniqueConstraint(int index) {
        X xmlTable = this.getXmlTableForUpdate();
        XmlUniqueConstraint xmlConstraint = this.buildXmlUniqueConstraint();
        OrmSpecifiedUniqueConstraint constraint = (OrmSpecifiedUniqueConstraint)this.uniqueConstraintContainer.addContextElement(index, xmlConstraint);
        ((AbstractXmlTable)((Object)xmlTable)).getUniqueConstraints().add(index, (Object)xmlConstraint);
        return constraint;
    }

    protected XmlUniqueConstraint buildXmlUniqueConstraint() {
        return OrmFactory.eINSTANCE.createXmlUniqueConstraint();
    }

    @Override
    public void removeUniqueConstraint(SpecifiedUniqueConstraint uniqueConstraint) {
        this.removeUniqueConstraint(this.uniqueConstraintContainer.indexOf((OrmSpecifiedUniqueConstraint)uniqueConstraint));
    }

    @Override
    public void removeUniqueConstraint(int index) {
        this.uniqueConstraintContainer.remove(index);
        ((AbstractXmlTable)((Object)this.getXmlTable())).getUniqueConstraints().remove(index);
        this.removeXmlTableIfUnset();
    }

    @Override
    public void moveUniqueConstraint(int targetIndex, int sourceIndex) {
        this.uniqueConstraintContainer.move(targetIndex, sourceIndex);
        ((AbstractXmlTable)((Object)this.getXmlTable())).getUniqueConstraints().move(targetIndex, sourceIndex);
    }

    protected OrmSpecifiedUniqueConstraint buildUniqueConstraint(XmlUniqueConstraint xmlConstraint) {
        return this.getContextModelFactory().buildOrmUniqueConstraint(this, xmlConstraint);
    }

    protected void syncUniqueConstraints() {
        this.uniqueConstraintContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<XmlUniqueConstraint> getXmlUniqueConstraints() {
        X xmlTable = this.getXmlTable();
        return xmlTable == null ? EmptyListIterable.instance() : IterableTools.cloneLive(((AbstractXmlTable)((Object)xmlTable)).getUniqueConstraints());
    }

    protected AbstractJpaContextModel.ContextListContainer<OrmSpecifiedUniqueConstraint, XmlUniqueConstraint> buildUniqueConstraintContainer() {
        return this.buildSpecifiedContextListContainer("uniqueConstraints", new UniqueConstraintContainerAdapter());
    }

    @Override
    public org.eclipse.jpt.jpa.db.Table getDbTable() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema == null ? null : dbSchema.getTableForIdentifier(this.getName());
    }

    @Override
    public Schema getDbSchema() {
        SchemaContainer dbSchemaContainer = this.getDbSchemaContainer();
        return dbSchemaContainer == null ? null : dbSchemaContainer.getSchemaForIdentifier(this.getSchema());
    }

    @Override
    public SchemaContainer getDbSchemaContainer() {
        String catalog = this.getCatalog();
        return catalog != null ? this.resolveDbCatalog(catalog) : this.getDatabase();
    }

    @Override
    public Catalog getDbCatalog() {
        String catalog = this.getCatalog();
        return catalog == null ? null : this.resolveDbCatalog(catalog);
    }

    @Override
    public boolean isResolved() {
        return this.getDbTable() != null;
    }

    @Override
    public boolean schemaIsResolved() {
        return this.getDbSchema() != null;
    }

    @Override
    public boolean catalogIsResolved() {
        String catalog = this.getCatalog();
        return catalog == null || this.resolveDbCatalog(catalog) != null;
    }

    @Override
    public Iterable<String> getCandidateUniqueConstraintColumnNames() {
        org.eclipse.jpt.jpa.db.Table dbTable = this.getDbTable();
        return dbTable != null ? dbTable.getSortedColumnIdentifiers() : EmptyIterable.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.buildTableValidator().validate(messages, reporter);
    }

    protected JpaValidator buildTableValidator() {
        return this.parentAdapter.buildTableValidator(this);
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getXmlTableValidationTextRange();
        return textRange != null ? textRange : ((JpaContextModel)this.parent).getValidationTextRange();
    }

    protected TextRange getXmlTableValidationTextRange() {
        X xmlTable = this.getXmlTable();
        return xmlTable == null ? null : xmlTable.getValidationTextRange();
    }

    @Override
    public TextRange getNameValidationTextRange() {
        return this.getValidationTextRange(this.getXmlTableNameTextRange());
    }

    protected TextRange getXmlTableNameTextRange() {
        X xmlTable = this.getXmlTable();
        return xmlTable == null ? null : ((AbstractXmlTable)((Object)xmlTable)).getNameTextRange();
    }

    @Override
    public TextRange getSchemaValidationTextRange() {
        return this.getValidationTextRange(this.getXmlTableSchemaTextRange());
    }

    protected TextRange getXmlTableSchemaTextRange() {
        X xmlTable = this.getXmlTable();
        return xmlTable == null ? null : ((AbstractXmlTable)((Object)xmlTable)).getSchemaTextRange();
    }

    @Override
    public TextRange getCatalogValidationTextRange() {
        return this.getValidationTextRange(this.getXmlTableCatalogTextRange());
    }

    protected TextRange getXmlTableCatalogTextRange() {
        X xmlTable = this.getXmlTable();
        return xmlTable == null ? null : ((AbstractXmlTable)((Object)xmlTable)).getCatalogTextRange();
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        for (OrmSpecifiedUniqueConstraint constraint : this.getUniqueConstraints()) {
            result = constraint.getCompletionProposals(pos);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    protected Iterable<String> getConnectedCompletionProposals(int pos) {
        Iterable<String> result = super.getConnectedCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.tableNameTouches(pos)) {
            return this.getCandidateTableNames();
        }
        if (this.schemaTouches(pos)) {
            return this.getCandidateSchemata();
        }
        if (this.catalogTouches(pos)) {
            return this.getCandidateCatalogs();
        }
        return null;
    }

    protected boolean tableNameTouches(int pos) {
        X table = this.getXmlTable();
        return table != null && ((AbstractXmlTable)((Object)table)).nameTouches(pos);
    }

    protected Iterable<String> getCandidateTableNames() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema != null ? dbSchema.getSortedTableIdentifiers() : EmptyIterable.instance();
    }

    protected boolean schemaTouches(int pos) {
        X table = this.getXmlTable();
        return table != null && ((AbstractXmlTable)((Object)table)).schemaTouches(pos);
    }

    protected Iterable<String> getCandidateSchemata() {
        if (this.getDbSchemaContainer() == null) {
            return EmptyIterable.instance();
        }
        return this.getDbSchemaContainer().getSortedSchemaIdentifiers();
    }

    protected boolean catalogTouches(int pos) {
        X table = this.getXmlTable();
        return table != null && ((AbstractXmlTable)((Object)table)).catalogTouches(pos);
    }

    protected Iterable<String> getCandidateCatalogs() {
        Database db = this.getDatabase();
        return db != null ? db.getSortedCatalogIdentifiers() : EmptyIterable.instance();
    }

    protected void initializeFrom(Table oldTable) {
        this.initializeFrom_(oldTable);
    }

    protected void initializeFrom(VirtualTable virtualTable) {
        this.initializeFrom_(virtualTable);
    }

    protected void initializeFrom_(Table oldTable) {
        this.setSpecifiedName(oldTable.getSpecifiedName());
        this.setSpecifiedCatalog(oldTable.getSpecifiedCatalog());
        this.setSpecifiedSchema(oldTable.getSpecifiedSchema());
        for (UniqueConstraint constraint : oldTable.getUniqueConstraints()) {
            this.addUniqueConstraint().initializeFrom(constraint);
        }
    }

    public void toString(StringBuilder sb) {
        sb.append(this.buildQualifiedName());
    }

    protected String buildQualifiedName() {
        return NameTools.buildQualifiedName((String[])new String[]{this.getCatalog(), this.getSchema(), this.getName()});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class UniqueConstraintContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<OrmSpecifiedUniqueConstraint, XmlUniqueConstraint> {
        @Override
        public OrmSpecifiedUniqueConstraint buildContextElement(XmlUniqueConstraint resourceElement) {
            return AbstractOrmTable.this.buildUniqueConstraint(resourceElement);
        }

        @Override
        public ListIterable<XmlUniqueConstraint> getResourceElements() {
            return AbstractOrmTable.this.getXmlUniqueConstraints();
        }

        @Override
        public XmlUniqueConstraint extractResourceElement(OrmSpecifiedUniqueConstraint contextElement) {
            return contextElement.getXmlUniqueConstraint();
        }
    }
}

