/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.Query;
import org.eclipse.jpt.jpa.core.context.QueryHint;
import org.eclipse.jpt.jpa.core.context.java.JavaQuery;
import org.eclipse.jpt.jpa.core.context.java.JavaQueryContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaQueryHint;
import org.eclipse.jpt.jpa.core.internal.context.AbstractJpaContextModel;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.jpt.jpa.core.jpql.JpaJpqlQueryHelper;
import org.eclipse.jpt.jpa.core.resource.java.QueryAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.QueryHintAnnotation;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaQuery<P extends JavaQueryContainer, A extends QueryAnnotation>
extends AbstractJavaContextModel<P>
implements JavaQuery {
    protected final A queryAnnotation;
    protected String name;
    protected final AbstractJpaContextModel.ContextListContainer<JavaQueryHint, QueryHintAnnotation> hintContainer;

    protected AbstractJavaQuery(P parent, A queryAnnotation) {
        super(parent);
        this.queryAnnotation = queryAnnotation;
        this.name = queryAnnotation.getName();
        this.hintContainer = this.buildHintContainer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setName_(this.queryAnnotation.getName());
        this.syncHints();
    }

    @Override
    public void update() {
        super.update();
        this.updateModels((Iterable<? extends JpaContextModel>)this.getHints());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.queryAnnotation.setName(name);
        this.setName_(name);
    }

    protected void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    @Override
    public ListIterable<JavaQueryHint> getHints() {
        return this.hintContainer;
    }

    @Override
    public int getHintsSize() {
        return this.hintContainer.size();
    }

    @Override
    public JavaQueryHint addHint() {
        return this.addHint(this.getHintsSize());
    }

    @Override
    public JavaQueryHint addHint(int index) {
        QueryHintAnnotation annotation = this.queryAnnotation.addHint(index);
        return (JavaQueryHint)this.hintContainer.addContextElement(index, annotation);
    }

    @Override
    public void removeHint(QueryHint hint) {
        this.removeHint(this.hintContainer.indexOf((JavaQueryHint)hint));
    }

    @Override
    public void removeHint(int index) {
        this.queryAnnotation.removeHint(index);
        this.hintContainer.remove(index);
    }

    @Override
    public void moveHint(int targetIndex, int sourceIndex) {
        this.queryAnnotation.moveHint(targetIndex, sourceIndex);
        this.hintContainer.move(targetIndex, sourceIndex);
    }

    @Override
    public JavaQueryHint getHint(int index) {
        return (JavaQueryHint)this.hintContainer.get(index);
    }

    protected JavaQueryHint buildHint(QueryHintAnnotation hintAnnotation) {
        return this.getJpaFactory().buildJavaQueryHint(this, hintAnnotation);
    }

    protected void syncHints() {
        this.hintContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<QueryHintAnnotation> getHintAnnotations() {
        return this.queryAnnotation.getHints();
    }

    protected AbstractJpaContextModel.ContextListContainer<JavaQueryHint, QueryHintAnnotation> buildHintContainer() {
        return this.buildSpecifiedContextListContainer("hints", new HintContainerAdapter());
    }

    @Override
    public boolean supportsValidationMessages() {
        return MappingTools.modelIsInternalSource(this, this.getQueryAnnotation());
    }

    @Override
    public void validate(JpaJpqlQueryHelper queryHelper, List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateName(messages);
    }

    protected void validateName(List<IMessage> messages) {
        if (StringTools.isBlank((String)this.name)) {
            messages.add(this.buildValidationMessage(this.getNameTextRange(), JptJpaCoreValidationMessages.QUERY_NAME_UNDEFINED));
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.queryAnnotation.getTextRange();
        return textRange != null ? textRange : ((JavaQueryContainer)this.parent).getValidationTextRange();
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getValidationTextRange(this.queryAnnotation.getNameTextRange());
    }

    @Override
    public boolean isEquivalentTo(Query other) {
        return this != other && this.getQueryType() == other.getQueryType() && this.isEquivalentTo_(other);
    }

    protected boolean isEquivalentTo_(Query other) {
        return ObjectTools.equals((Object)this.name, (Object)other.getName()) && this.hintsAreEquivalentTo(other);
    }

    protected boolean hintsAreEquivalentTo(Query other) {
        ArrayList hints1 = ListTools.list(this.getHints());
        ArrayList hints2 = ListTools.list(other.getHints());
        if (hints1.size() != hints2.size()) {
            return false;
        }
        int i = 0;
        while (i < hints1.size()) {
            if (!((JavaQueryHint)hints1.get(i)).isEquivalentTo((QueryHint)hints2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public A getQueryAnnotation() {
        return this.queryAnnotation;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class HintContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<JavaQueryHint, QueryHintAnnotation> {
        @Override
        public JavaQueryHint buildContextElement(QueryHintAnnotation resourceElement) {
            return AbstractJavaQuery.this.buildHint(resourceElement);
        }

        @Override
        public ListIterable<QueryHintAnnotation> getResourceElements() {
            return AbstractJavaQuery.this.getHintAnnotations();
        }

        @Override
        public QueryHintAnnotation extractResourceElement(JavaQueryHint contextElement) {
            return contextElement.getQueryHintAnnotation();
        }
    }
}

