/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal;

import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.utility.internal.comparator.ComparatorTools;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaPlatformFactory;
import org.eclipse.jpt.jpa.core.JpaPlatformVariation;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.internal.GenericJpaAnnotationDefinitionProvider;
import org.eclipse.jpt.jpa.core.internal.GenericJpaPlatform;
import org.eclipse.jpt.jpa.core.internal.GenericJpaPlatformProvider;
import org.eclipse.jpt.jpa.core.internal.JpaAnnotationProvider;
import org.eclipse.jpt.jpa.core.internal.jpa1.GenericJpaFactory;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar1_0;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class GenericJpaPlatformFactory
implements JpaPlatformFactory {
    public static final String ID = "generic";
    public static final String GROUP_ID = "generic";

    public JpaPlatform buildJpaPlatform(JpaPlatform.Config config) {
        return new GenericJpaPlatform(config, this.buildJpaVersion(config.getJpaFacetVersion()), new GenericJpaFactory(), new JpaAnnotationProvider(GenericJpaAnnotationDefinitionProvider.instance()), GenericJpaPlatformProvider.instance(), this.buildJpaPlatformVariation(), JPQLGrammar1_0.instance());
    }

    private JpaPlatform.Version buildJpaVersion(IProjectFacetVersion jpaFacetVersion) {
        return new GenericJpaPlatformVersion(jpaFacetVersion.getVersionString());
    }

    protected JpaPlatformVariation buildJpaPlatformVariation() {
        return new JpaPlatformVariation(){

            public JpaPlatformVariation.Supported getTablePerConcreteClassInheritanceIsSupported() {
                return JpaPlatformVariation.Supported.MAYBE;
            }

            public boolean isJoinTableOverridable() {
                return false;
            }

            public AccessType[] getSupportedAccessTypes(JptResourceType resourceType) {
                return GENERIC_SUPPORTED_ACCESS_TYPES;
            }
        };
    }

    public static class GenericJpaPlatformVersion
    implements JpaPlatform.Version {
        protected final String jpaVersion;

        public GenericJpaPlatformVersion(String jpaVersion) {
            this.jpaVersion = jpaVersion;
        }

        public String getVersion() {
            return this.getJpaVersion();
        }

        public String getJpaVersion() {
            return this.jpaVersion;
        }

        public boolean isCompatibleWithJpaVersion(String version) {
            return ComparatorTools.integerVersionComparator().compare(this.jpaVersion, version) >= 0;
        }

        public String toString() {
            return "JPA " + this.jpaVersion;
        }
    }
}

