/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters.delegates;

import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.MethodInfo;
import oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters.DelegatingMethodSymbol;
import oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters.DelegatingPropertySymbol;
import oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters.OssSymbolAdaptersFactory;
import oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters.delegates.MethodSymbolDelegate;
import oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters.delegates.PropertySymbolDelegate;
import oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters.delegates.TypeDescriptorDelegate;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.symbol.IJavaTypeDescriptor2;
import org.eclipse.jst.jsf.context.symbol.IMethodSymbol;
import org.eclipse.jst.jsf.context.symbol.IObjectSymbol;
import org.eclipse.jst.jsf.context.symbol.IPropertySymbol;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;

public class DataTypeDescriptorDelegate
extends TypeDescriptorDelegate {
    private final DataType _dataType;
    protected final IModelContext _modelContext;

    public DataTypeDescriptorDelegate(DataType dataType, IModelContext modelContext) {
        this._dataType = dataType;
        this._modelContext = modelContext;
    }

    public final DataType getDataType() {
        return this._dataType;
    }

    @Override
    public EList getProperties() {
        List fields = this._dataType.getFields(this._modelContext);
        BasicEList properties = new BasicEList();
        for (DataType.Field field : fields) {
            IPropertySymbol propertySymbol = this.createPropertySymbol(field);
            properties.add((Object)propertySymbol);
        }
        return properties;
    }

    protected IPropertySymbol createPropertySymbol(DataType.Field field) {
        DelegatingPropertySymbol propertySymbol = OssSymbolAdaptersFactory.eINSTANCE.createDelegatingPropertySymbol();
        propertySymbol.setDelegate(new PropertySymbolDelegate(field, this._modelContext));
        return propertySymbol;
    }

    @Override
    public EList getMethods() {
        List publicMethods = this._dataType.getPublicMethods();
        BasicEList methods = new BasicEList();
        for (MethodInfo methodInfo : publicMethods) {
            IMethodSymbol methodSymbol = this.createMethodSymbol(methodInfo);
            methods.add((Object)methodSymbol);
        }
        return methods;
    }

    protected IMethodSymbol createMethodSymbol(MethodInfo methodInfo) {
        DelegatingMethodSymbol propertySymbol = OssSymbolAdaptersFactory.eINSTANCE.createDelegatingMethodSymbol();
        propertySymbol.setDelegate(new MethodSymbolDelegate(methodInfo));
        return propertySymbol;
    }

    @Override
    public String getTypeSignature() {
        if (this._dataType.isUnknown()) {
            return "Ljava.lang.Object;";
        }
        String name = this._dataType.getName();
        if (name != null && !name.startsWith(String.valueOf('['))) {
            name = Signature.createTypeSignature((String)name, (boolean)true);
        }
        return name;
    }

    @Override
    public boolean isArray() {
        return this._dataType.isArray();
    }

    @Override
    public EList<String> getSuperTypeSignatures() {
        Set superClasses = this._dataType.getSuperClassSignatures();
        return new BasicEList.UnmodifiableEList(superClasses.size(), (Object[])superClasses.toArray(new String[0]));
    }

    @Override
    public EList getInterfaceTypeSignatures() {
        Set interfaces = this._dataType.getSuperInterfaces();
        return new BasicEList.UnmodifiableEList(interfaces.size(), (Object[])interfaces.toArray(new String[0]));
    }

    @Override
    public IType getType() {
        return null;
    }

    @Override
    public IType resolveType(String resolvedTypeSignature) {
        IJavaTypeDescriptor2 delegateTypeDesc = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
        delegateTypeDesc.setType(this.getType());
        return delegateTypeDesc.resolveType(resolvedTypeSignature);
    }

    @Override
    public boolean getIsEnum() {
        return this._dataType.isEnum();
    }

    @Override
    public IObjectSymbol getArrayElement() {
        if (this.isArray()) {
            IJavaTypeDescriptor2 delegateTypeDesc = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
            delegateTypeDesc.setType(this.getType());
            delegateTypeDesc.setArrayCount(Signature.getArrayCount((String)this.getTypeSignature()));
            delegateTypeDesc.setTypeSignatureDelegate(this.getTypeSignature());
            return delegateTypeDesc.getArrayElement();
        }
        throw new IllegalArgumentException("getArrayElement only valid for arrays");
    }
}

