/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.tagsupport;

import java.util.List;
import oracle.eclipse.tools.application.common.services.appservices.IDatatypeProvider;
import oracle.eclipse.tools.application.common.services.include.model.IMergedModelNode;
import oracle.eclipse.tools.application.common.services.tagsupport.IDOMNodeAdaptableHolder;
import oracle.eclipse.tools.application.common.services.tagsupport.TypedComponentSymbolDelegate;
import oracle.eclipse.tools.application.common.services.techextservices.IDataTypeIntrospector;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.JavaResourceBundleDataType;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.MergedTaglibContextResolver;
import oracle.eclipse.tools.webtier.jsf.tagsupport.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.symbol.IComponentSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.context.symbol.source.AbstractContextSymbolFactory;
import org.eclipse.jst.jsf.context.symbol.source.IAdditionalContextSymbolInfo;
import org.eclipse.jst.jsf.designtime.symbols.AbstractDataModelVariableFactory;
import org.eclipse.jst.jsf.designtime.symbols.DefaultDataTableSymbolFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class JSFSymbolFactory
extends AbstractContextSymbolFactory {
    protected ISymbol internalCreate(String symbolName, int scope, IAdaptable context, List problems, IAdditionalContextSymbolInfo additionInfo) {
        Attr attr;
        Element owningElement;
        Node curNode;
        IStructuredDocumentContext sContext = (IStructuredDocumentContext)context.getAdapter(IStructuredDocumentContext.class);
        IDOMContextResolver domResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(sContext);
        if (domResolver != null && (curNode = domResolver.getNode()) instanceof Attr && (owningElement = (attr = (Attr)curNode).getOwnerElement()) != null) {
            return this.handleSymbolCreation(symbolName, sContext, attr, owningElement, problems);
        }
        return null;
    }

    private ISymbol handleSymbolCreation(String symbolName, IStructuredDocumentContext context, Attr attr, Node owningElement, List problems) {
        MergedTaglibContextResolver resolver = null;
        if (!(owningElement instanceof IDOMElement)) {
            return null;
        }
        IMergedModelNode mmNode = (IMergedModelNode)((IDOMElement)owningElement).getAdapterFor(IMergedModelNode.class);
        if (mmNode != null) {
            resolver = new MergedTaglibContextResolver(context);
        }
        if (resolver == null) {
            resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTaglibContextResolver(context);
        }
        if (resolver == null || !resolver.canResolveContext((IModelContext)context)) {
            return null;
        }
        String uri = resolver.getTagURIForNodeName(owningElement);
        if ("http://java.sun.com/jsf/core".equals(uri)) {
            return this.handleCoreTags(symbolName, (IDOMElement)owningElement, attr, context, problems);
        }
        if ("http://java.sun.com/jsf/html".equals(uri)) {
            return this.handleHtmlTags(symbolName, (IDOMElement)owningElement, attr, context, problems);
        }
        return null;
    }

    public boolean supports(IAdaptable context) {
        return context != null && context.getAdapter(IStructuredDocumentContext.class) != null;
    }

    private ISymbol handleHtmlTags(String symbolName, IDOMElement owningElement, Attr attr, IStructuredDocumentContext context, List problems) {
        String elementName = owningElement.getLocalName();
        String attrName = attr.getName();
        if ("dataTable".equals(elementName) && "var".equals(attrName)) {
            return DataModelVariableFactory.getInstance().createSymbolForDataTableValue(symbolName, (Element)owningElement, context);
        }
        return null;
    }

    private ISymbol handleCoreTags(String symbolName, IDOMElement owningElement, Attr attr, IStructuredDocumentContext context, List problems) {
        String elementName = owningElement.getLocalName();
        if ("loadBundle".equals(elementName)) {
            ISymbol symbol = this.handleLoadBundleTag(symbolName, owningElement, attr, context, problems);
            return symbol;
        }
        return null;
    }

    private ISymbol handleLoadBundleTag(String symbolName, IDOMElement owningElement, Attr attr, IStructuredDocumentContext context, List problems) {
        NamedNodeMap attrMap;
        Node baseNameNode;
        String attrName = attr.getName();
        if ("var".equals(attrName) && (baseNameNode = (attrMap = owningElement.getAttributes()).getNamedItem("basename")) != null) {
            IWorkspaceContextResolver wkspaceResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(context);
            IProject project = wkspaceResolver.getProject();
            if (project == null) {
                throw new RuntimeException("Error acquiring project");
            }
            String basename = baseNameNode.getNodeValue() == null ? null : baseNameNode.getNodeValue().trim();
            IComponentSymbol symbol = SymbolFactory.eINSTANCE.createIComponentSymbol();
            symbol.setName(symbolName);
            symbol.setDetailedDescription(NLS.bind((String)Messages.JSFSymbolFactory_detail, (Object)basename));
            TypedComponentSymbolDelegate typedSymbol = new TypedComponentSymbolDelegate(symbol);
            Project prj = (Project)project.getAdapter(Project.class);
            if (prj != null) {
                DataType bundleType = this.getBundleDataType(prj, basename, owningElement);
                typedSymbol.setDataType(bundleType);
                if (baseNameNode instanceof IDOMNode) {
                    typedSymbol.setDOMNode((IAdaptable)new IDOMNodeAdaptableHolder((IDOMNode)baseNameNode));
                }
                return typedSymbol;
            }
        }
        return null;
    }

    private DataType getBundleDataType(Project project, String basename, IDOMElement owningElement) {
        IDatatypeProvider dtp = (IDatatypeProvider)project.getAppService(IDatatypeProvider.class);
        if (dtp != null) {
            IDataTypeIntrospector introspector = dtp.getIntrospector();
            return new JavaResourceBundleDataType(introspector, project, basename);
        }
        throw new IllegalStateException("Web app must have a data type provider");
    }

    private static class DataModelVariableFactory
    extends DefaultDataTableSymbolFactory {
        private static DataModelVariableFactory INSTANCE;

        public static synchronized DataModelVariableFactory getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new DataModelVariableFactory();
            }
            return INSTANCE;
        }

        public ISymbol createSymbolForDataTableValue(String symbolName, Element dataTableElement, IStructuredDocumentContext context) {
            if (!"dataTable".equals(dataTableElement.getLocalName())) {
                throw new AssertionError((Object)"dataTableElement must be a dataTable");
            }
            return super.createSymbolForDataTableValue(symbolName, dataTableElement, context);
        }

        private DataModelVariableFactory() {
            super((AbstractDataModelVariableFactory)new MyDataModelVariableFactory());
        }

        private static class MyDataModelVariableFactory
        extends AbstractDataModelVariableFactory {
            private MyDataModelVariableFactory() {
            }

            protected String getVariableSourceName() {
                return "dataTable";
            }
        }
    }
}

